/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.jdbc;

import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.phoenix.jdbc.DelegateResultSet;
import org.apache.phoenix.jdbc.PhoenixMetricsLog;
import org.apache.phoenix.util.PhoenixRuntime;

public class LoggingPhoenixResultSet
extends DelegateResultSet {
    private PhoenixMetricsLog phoenixMetricsLog;
    private String sql;
    private boolean areMetricsLogged;

    public LoggingPhoenixResultSet(ResultSet rs, PhoenixMetricsLog phoenixMetricsLog, String sql) {
        super(rs);
        this.phoenixMetricsLog = phoenixMetricsLog;
        this.sql = sql;
        this.areMetricsLogged = false;
    }

    @Override
    public void close() throws SQLException {
        if (!this.rs.isClosed()) {
            super.close();
        }
        if (!this.areMetricsLogged) {
            this.phoenixMetricsLog.logOverAllReadRequestMetrics(PhoenixRuntime.getOverAllReadRequestMetricInfo(this.rs), this.sql);
            this.phoenixMetricsLog.logRequestReadMetrics(PhoenixRuntime.getRequestReadMetricInfo(this.rs), this.sql);
            PhoenixRuntime.resetMetrics(this.rs);
            this.areMetricsLogged = true;
        }
    }
}

