/*
 * Decompiled with CFR 0.152.
 */
package org.apache.statemachine;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StateMachine {
    private static final Logger LOG = LoggerFactory.getLogger(StateMachine.class);
    private static final String HANDLER_METHOD_NAME = "handleEvent";
    private static ConcurrentHashMap<Class<?>, ConcurrentHashMap<Class<?>, Method>> stateCaches = new ConcurrentHashMap();

    public static interface DeferrableEvent
    extends Event {
        public void error(Throwable var1);
    }

    public static class FsmImpl
    implements Fsm {
        ScheduledExecutorService executor;
        private State state;
        private Queue<DeferrableEvent> deferred;

        public FsmImpl(ScheduledExecutorService executor) {
            this.executor = executor;
            this.state = null;
            this.deferred = new ArrayDeque<DeferrableEvent>();
        }

        private void errorDeferredEvents(Throwable t) {
            Queue<DeferrableEvent> oldDeferred = this.deferred;
            this.deferred = new ArrayDeque<DeferrableEvent>();
            for (DeferrableEvent e : oldDeferred) {
                e.error(new IllegalStateException(t));
            }
        }

        @Override
        public Fsm newChildFsm() {
            return new FsmImpl(this.executor);
        }

        @Override
        public void setInitState(State initState) {
            assert (this.state == null);
            this.state = initState;
        }

        public State getState() {
            return this.state;
        }

        void setState(State curState, State newState) {
            if (curState != this.state) {
                LOG.error("FSM-{}: Tried to transition from {} to {}, but current state is {}", new Object[]{this.getFsmId(), this.state, newState, curState});
                throw new IllegalArgumentException();
            }
            this.state = newState;
            if (LOG.isDebugEnabled()) {
                LOG.debug("FSM-{}: State transition {} -> {}", new Object[]{this.getFsmId(), curState, newState});
            }
        }

        boolean processEvent(Event e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("FSM-{}: Received event {}@{} in state {}@{}", new Object[]{this.getFsmId(), e.getClass().getSimpleName(), System.identityHashCode(e), this.state.getClass().getSimpleName(), System.identityHashCode(this.state)});
            }
            try {
                State newState = this.state.dispatch(e);
                if (newState != this.state) {
                    this.setState(this.state, newState);
                    return true;
                }
            }
            catch (Throwable t) {
                LOG.error("Caught throwable while handling event", t);
                this.errorDeferredEvents(t);
            }
            return false;
        }

        @Override
        public void sendEvent(Event e) {
            this.executor.submit(new FSMRunnable(e));
        }

        @Override
        public Future<?> sendEvent(Event e, long delay, TimeUnit unit) {
            return this.executor.schedule(new FSMRunnable(e), delay, unit);
        }

        @Override
        public void deferEvent(DeferrableEvent e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("FSM-{}: deferred {}@{}", new Object[]{this.getFsmId(), e.getClass().getSimpleName(), System.identityHashCode(e)});
            }
            this.deferred.add(e);
        }

        int getFsmId() {
            return System.identityHashCode(this);
        }

        protected void finalize() throws Throwable {
            super.finalize();
            LOG.debug("FSM-{}: Finalizing", (Object)this.getFsmId());
        }

        class FSMRunnable
        implements Runnable {
            final Event e;

            FSMRunnable(Event e) {
                this.e = e;
            }

            @Override
            public void run() {
                boolean stateChanged = FsmImpl.this.processEvent(this.e);
                while (stateChanged) {
                    stateChanged = false;
                    Queue prevDeferred = FsmImpl.this.deferred;
                    FsmImpl.this.deferred = new ArrayDeque();
                    for (DeferrableEvent d : prevDeferred) {
                        if (stateChanged) {
                            FsmImpl.this.deferred.add(d);
                            continue;
                        }
                        if (!FsmImpl.this.processEvent(d)) continue;
                        stateChanged = true;
                    }
                }
            }
        }
    }

    public static interface Fsm {
        public Fsm newChildFsm();

        public void setInitState(State var1);

        public void sendEvent(Event var1);

        public Future<?> sendEvent(Event var1, long var2, TimeUnit var4);

        public void deferEvent(DeferrableEvent var1);
    }

    public static interface Event {
    }

    public static abstract class State {
        protected final Fsm fsm;
        private final ConcurrentHashMap<Class<?>, Method> handlerCache;

        public State(Fsm fsm) {
            this.fsm = fsm;
            ConcurrentHashMap handlerCache = (ConcurrentHashMap)stateCaches.get(this.getClass());
            if (handlerCache == null) {
                handlerCache = new ConcurrentHashMap();
                ConcurrentHashMap old = stateCaches.putIfAbsent(this.getClass(), handlerCache);
                if (old != null) {
                    handlerCache = old;
                }
            }
            this.handlerCache = handlerCache;
        }

        private Method findHandlerInternal(Class<?> state2, Class<?> e) throws NoSuchMethodException {
            Method[] methods = state2.getMethods();
            ArrayList<Method> candidates = new ArrayList<Method>();
            for (Method m : methods) {
                if (!m.getName().equals(StateMachine.HANDLER_METHOD_NAME) || !State.class.isAssignableFrom(m.getReturnType()) || m.getGenericParameterTypes().length != 1) continue;
                candidates.add(m);
            }
            Method best = null;
            for (Method m : candidates) {
                if (!m.getParameterTypes()[0].isAssignableFrom(e)) continue;
                if (best == null) {
                    best = m;
                    continue;
                }
                if (!best.getParameterTypes()[0].isAssignableFrom(m.getParameterTypes()[0])) continue;
                best = m;
            }
            if (best != null) {
                best.setAccessible(true);
                return best;
            }
            throw new NoSuchMethodException("Handler doesn't exist");
        }

        private Method findHandler(Class<?> event) throws NoSuchMethodException {
            Method m2;
            Method m = this.handlerCache.get(event);
            if (m == null && (m2 = this.handlerCache.putIfAbsent(event, m = this.findHandlerInternal(this.getClass(), event))) != null) {
                m = m2;
            }
            return m;
        }

        State dispatch(Event e) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
            return (State)this.findHandler(e.getClass()).invoke((Object)this, e);
        }
    }
}

