---
title: "Securing S3"
date: "2019-04-03"
summary: Ozone supports S3 protocol, and uses AWS Signature Version 4 protocol which allows a seamless S3 experience.
weight: 5
menu:
   main:
      parent: Security
icon: cloud
---
<!---
  Licensed to the Apache Software Foundation (ASF) under one or more
  contributor license agreements.  See the NOTICE file distributed with
  this work for additional information regarding copyright ownership.
  The ASF licenses this file to You under the Apache License, Version 2.0
  (the "License"); you may not use this file except in compliance with
  the License.  You may obtain a copy of the License at

      http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  See the License for the specific language governing permissions and
  limitations under the License.
-->

To access an S3 bucket, users need AWS access key ID and AWS secret. Both of
these are generated by going to AWS website. When you use Ozone's S3
protocol, you need the same AWS access key and secret.

Under Ozone, the clients can download the access key directly from Ozone.
The user needs to `kinit` first and once they have authenticated via kerberos
 they can download the S3 access key ID and AWS secret. Just like AWS S3,
 both of these are secrets that needs to be protected by the client since it
 gives full access to the S3 buckets.

## Obtain Secrets

* S3 clients can get the secret access id and user secret from OzoneManager.

```bash
ozone s3 getsecret
```

* Or by sending request to /secret S3 REST endpoint.

```bash
curl -X PUT --negotiate -u : https://localhost:9879/secret
```

This command will talk to ozone, validate the user via Kerberos and generate
the AWS credentials. The values will be printed out on the screen. You can
set these values up in your _.aws_ file for automatic access while working
against Ozone S3 buckets.

<div class="alert alert-danger" role="alert">
 Please note: These S3 credentials are like your Kerberos passwords
 that give complete access to your buckets.
</div>


* Now you can proceed to setup these secrets in aws configs:

```bash
aws configure set default.s3.signature_version s3v4
aws configure set aws_access_key_id ${accessId}
aws configure set aws_secret_access_key ${secret}
aws configure set region us-west-1
```
Please refer to AWS S3 documentation on how to use S3 via command line or via
S3 API.

## Revoking Secrets via REST API

To invalidate/revoke the secret, use `ozone s3 revokesecret` command.
Alternatively, you can use the REST API endpoint to revoke the secret.
Ozone now provides a REST API endpoint that allows administrators to revoke S3 access secrets. This operation invalidates a secret, ensuring it can no longer be used for authentication.

### Endpoint Details

- **URL:** `http://localhost:9879/secret`
- **HTTP Method:** `DELETE`

### Authentication

The API leverages SPNEGO (Kerberos) authentication. The following curl options are used:
- `--negotiate` enables SPNEGO.
- `-u :` uses the current Kerberos ticket (an empty username is provided).

### Example 1: Revoke Secret for the Current User

This command revokes the secret for the currently authenticated user:

```bash
curl -X DELETE --negotiate -u : -v http://localhost:9879/secret
```

### Example 2: Revoke Secret by Username

This command revokes the secret for a specific user by appending the username as a query parameter. Replace `testuser` with the desired username:

```bash
curl -X DELETE --negotiate -u : -v "http://localhost:9879/secret?username=testuser"
```

### Response

- **Success:** Returns HTTP `200 OK` along with a confirmation message in JSON format.
- **Failure:** Returns an appropriate HTTP error status and message if there are issues (e.g., authentication failures).

### Testing and Verification

For a working example of these operations, refer to the [Secret Revoke Robot Test](https://raw.githubusercontent.com/apache/ozone/refs/heads/master/hadoop-ozone/dist/src/main/smoketest/s3/secretrevoke.robot). This test demonstrates both the default secret revocation and the revocation by username.

> **Note:** Ensure your Kerberos authentication is correctly configured, as secret revocation is a privileged operation.
