/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.enhance;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ServiceLoader;
import java.util.stream.StreamSupport;
import org.apache.openjpa.enhance.asm.AsmSpi;
import org.apache.openjpa.enhance.asm.AsmSpi9;
import serp.bytecode.BCClass;

public final class AsmAdaptor {
    private static final AsmSpi impl = StreamSupport.stream(ServiceLoader.load(AsmSpi.class).spliterator(), false).min((a, b) -> {
        int v2;
        int v1;
        try {
            v1 = Integer.parseInt(a.getClass().getName().replace("AsmSpi", ""));
        }
        catch (Exception e) {
            return -1;
        }
        try {
            v2 = Integer.parseInt(b.getClass().getName().replace("AsmSpi", ""));
        }
        catch (Exception e) {
            return 1;
        }
        return v2 - v1;
    }).orElseGet(AsmSpi9::new);

    public static void write(BCClass bc) throws IOException {
        impl.write(bc);
    }

    public static void write(BCClass bc, File outFile) throws IOException {
        impl.write(bc, outFile);
    }

    public static void write(BCClass bc, OutputStream os) throws IOException {
        impl.write(bc, os);
    }

    public static byte[] toByteArray(BCClass bc, byte[] returnBytes) throws IOException {
        return impl.toByteArray(bc, returnBytes);
    }

    public static boolean isEnhanced(byte[] b) {
        return impl.isEnhanced(b);
    }
}

