/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bval.jsr;

import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.validation.ConstraintDefinitionException;
import javax.validation.ConstraintTarget;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorFactory;
import javax.validation.Payload;
import javax.validation.UnexpectedTypeException;
import javax.validation.ValidationException;
import javax.validation.constraintvalidation.SupportedValidationTarget;
import javax.validation.constraintvalidation.ValidationTarget;
import javax.validation.metadata.ConstraintDescriptor;
import org.apache.bval.jsr.ConstraintAnnotationAttributes;
import org.apache.bval.jsr.ConstraintDescriptorImpl;
import org.apache.bval.jsr.ConstraintValidationListener;
import org.apache.bval.jsr.ConstraintValidatorContextImpl;
import org.apache.bval.jsr.GroupValidationContext;
import org.apache.bval.jsr.ParameterAccess;
import org.apache.bval.jsr.ParametersAccess;
import org.apache.bval.jsr.util.NodeImpl;
import org.apache.bval.jsr.util.PathImpl;
import org.apache.bval.model.Validation;
import org.apache.bval.model.ValidationContext;
import org.apache.bval.model.ValidationListener;
import org.apache.bval.util.AccessStrategy;
import org.apache.bval.util.ObjectUtils;
import org.apache.bval.util.StringUtils;
import org.apache.bval.util.reflection.Reflection;
import org.apache.bval.util.reflection.TypeUtils;

public class ConstraintValidation<T extends Annotation>
implements Validation,
ConstraintDescriptor<T> {
    private final AccessStrategy access;
    private final boolean reportFromComposite;
    private final Map<String, Object> attributes = new HashMap<String, Object>();
    private T annotation;
    private volatile ConstraintValidator<T, ?> validator;
    private Set<ConstraintValidation<?>> composedConstraints;
    private boolean validated = false;
    private final Class<?> owner;
    private Set<Class<?>> groups;
    private Set<Class<? extends Payload>> payload;
    private Class<? extends ConstraintValidator<T, ?>>[] validatorClasses;
    private ConstraintTarget validationAppliesTo = null;

    public ConstraintValidation(Class<? extends ConstraintValidator<T, ?>>[] validatorClasses, T annotation, Class<?> owner, AccessStrategy access, boolean reportFromComposite, ConstraintTarget target) {
        this.validatorClasses = validatorClasses != null ? (Class[])validatorClasses.clone() : null;
        this.annotation = annotation;
        this.owner = owner;
        this.access = access;
        this.reportFromComposite = reportFromComposite;
        this.validationAppliesTo = target;
    }

    public ConstraintDescriptor<T> asSerializableDescriptor() {
        return new ConstraintDescriptorImpl(this);
    }

    void setGroups(Set<Class<?>> groups) {
        this.groups = groups;
        ConstraintAnnotationAttributes.GROUPS.put(this.attributes, groups.toArray(new Class[groups.size()]));
    }

    void setGroups(Class<?>[] groups) {
        this.groups = new HashSet();
        Collections.addAll(this.groups, groups);
        ConstraintAnnotationAttributes.GROUPS.put(this.attributes, groups);
    }

    void setPayload(Set<Class<? extends Payload>> payload) {
        this.payload = payload;
        ConstraintAnnotationAttributes.PAYLOAD.put(this.attributes, payload.toArray(new Class[payload.size()]));
    }

    @Override
    public boolean isReportAsSingleViolation() {
        return this.reportFromComposite;
    }

    public void addComposed(ConstraintValidation<?> aConstraintValidation) {
        if (this.composedConstraints == null) {
            this.composedConstraints = new HashSet();
        }
        this.composedConstraints.add(aConstraintValidation);
    }

    public <L extends ValidationListener> void validate(ValidationContext<L> context) {
        this.validateGroupContext((GroupValidationContext)context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validateGroupContext(GroupValidationContext<?> context) {
        if (this.validator == null) {
            ConstraintValidation constraintValidation = this;
            synchronized (constraintValidation) {
                if (this.validator == null) {
                    try {
                        this.validator = this.getConstraintValidator(context.getConstraintValidatorFactory(), (Annotation)this.annotation, (Class<? extends ConstraintValidator<A, ?>>[])this.validatorClasses, this.owner, this.access);
                        if (this.validator != null) {
                            this.validator.initialize(this.annotation);
                        }
                    }
                    catch (RuntimeException re) {
                        if (ValidationException.class.isInstance(re)) {
                            throw re;
                        }
                        throw new ConstraintDefinitionException(re);
                    }
                }
            }
        }
        context.setConstraintValidation(this);
        if (!this.isMemberOf(context.getCurrentGroup().getGroup())) {
            return;
        }
        if (context.getCurrentOwner() != null && !this.owner.equals(context.getCurrentOwner())) {
            return;
        }
        if (this.validator != null && !context.collectValidated(this.validator)) {
            return;
        }
        if (context.getMetaProperty() != null && !this.isReachable(context)) {
            return;
        }
        if (this.isReportAsSingleViolation()) {
            ConstraintValidationListener listener = (ConstraintValidationListener)context.getListener();
            listener.beginReportAsSingle();
            boolean failed = listener.hasViolations();
            try {
                Iterator<ConstraintValidation<?>> composed = this.getComposingValidations().iterator();
                while (!failed && composed.hasNext()) {
                    composed.next().validate((ValidationContext)context);
                    failed = listener.hasViolations();
                }
            }
            finally {
                listener.endReportAsSingle();
                context.setConstraintValidation(this);
            }
            if (failed) {
                this.addErrors(context, new ConstraintValidatorContextImpl(context, this));
                return;
            }
        } else {
            for (ConstraintValidation<?> composed : this.getComposingValidations()) {
                composed.validate((ValidationContext)context);
            }
            context.setConstraintValidation(this);
        }
        if (this.validator != null) {
            ConstraintValidator<Object, ?> objectValidator = this.validator;
            ConstraintValidatorContextImpl jsrContext = new ConstraintValidatorContextImpl(context, this);
            if (!objectValidator.isValid(context.getValidatedValue(), jsrContext)) {
                this.addErrors(context, jsrContext);
            }
        }
    }

    private <A extends Annotation> ConstraintValidator<A, ? super T> getConstraintValidator(ConstraintValidatorFactory factory, A annotation, Class<? extends ConstraintValidator<A, ?>>[] constraintClasses, Class<?> owner, AccessStrategy access) {
        if (ObjectUtils.isNotEmpty(constraintClasses)) {
            Type type = ConstraintValidation.determineTargetedType(owner, access);
            Map<Type, Collection<Class<ConstraintValidator<A, ?>>>> validatorTypes = ConstraintValidation.getValidatorsTypes(constraintClasses);
            this.reduceTarget(validatorTypes, access);
            ArrayList<Type> assignableTypes = new ArrayList<Type>(constraintClasses.length);
            ConstraintValidation.fillAssignableTypes(type, validatorTypes.keySet(), assignableTypes);
            ConstraintValidation.reduceAssignableTypes(assignableTypes);
            ConstraintValidation.checkOneType(assignableTypes, type, owner, annotation, access);
            if ((type.equals(Object.class) || type.equals(Object[].class)) && validatorTypes.containsKey(Object.class) && validatorTypes.containsKey(Object[].class)) {
                throw new ConstraintDefinitionException("Only a validator for Object or Object[] should be provided for cross-parameter validators");
            }
            Collection<Class<ConstraintValidator<A, ?>>> key = validatorTypes.get(assignableTypes.get(0));
            if (key.size() > 1) {
                String message = "Factory returned " + key.size() + " validators";
                if (ParametersAccess.class.isInstance(access)) {
                    throw new ConstraintDefinitionException(message);
                }
                throw new UnexpectedTypeException(message);
            }
            ConstraintValidator<A, ?> validator = factory.getInstance(key.iterator().next());
            if (validator == null) {
                throw new ValidationException("Factory returned null validator for: " + key);
            }
            return validator;
        }
        return null;
    }

    private <A extends Annotation> void reduceTarget(Map<Type, Collection<Class<? extends ConstraintValidator<A, ?>>>> validator, AccessStrategy access) {
        for (Map.Entry<Type, Collection<Class<ConstraintValidator<A, ?>>>> entry : validator.entrySet()) {
            Collection<Class<ConstraintValidator<A, ?>>> validators = entry.getValue();
            Iterator<Class<ConstraintValidator<A, ?>>> it = validators.iterator();
            while (it.hasNext()) {
                boolean isParameter;
                Class clazz;
                SupportedValidationTarget target;
                Type v = it.next();
                if (!Class.class.isInstance(v) || (target = (clazz = (Class)Class.class.cast(v)).getAnnotation(SupportedValidationTarget.class)) == null) continue;
                List<ValidationTarget> targets = Arrays.asList(target.value());
                boolean bl = isParameter = ParameterAccess.class.isInstance(access) || ParametersAccess.class.isInstance(access);
                if ((!isParameter || targets.contains((Object)ValidationTarget.PARAMETERS)) && (isParameter || targets.contains((Object)ValidationTarget.ANNOTATED_ELEMENT))) continue;
                it.remove();
            }
            if (!validators.isEmpty()) continue;
            validator.remove(entry.getKey());
        }
    }

    private static void checkOneType(List<Type> types, Type targetType, Class<?> owner, Annotation anno, AccessStrategy access) {
        if (types.isEmpty()) {
            String message = "No validator could be found for type " + ConstraintValidation.stringForType(targetType) + ". See: @" + anno.annotationType().getSimpleName() + " at " + ConstraintValidation.stringForLocation(owner, access);
            if (Object[].class.equals((Object)targetType)) {
                throw new ConstraintDefinitionException(message);
            }
            throw new UnexpectedTypeException(message);
        }
        if (types.size() > 1) {
            throw new UnexpectedTypeException(String.format("Ambiguous validators for type %s. See: @%s at %s. Validators are: %s", ConstraintValidation.stringForType(targetType), anno.annotationType().getSimpleName(), ConstraintValidation.stringForLocation(owner, access), StringUtils.join(types, ", ")));
        }
    }

    private static String stringForType(Type clazz) {
        if (clazz instanceof Class) {
            return ((Class)clazz).isArray() ? ((Class)clazz).getComponentType().getName() + "[]" : ((Class)clazz).getName();
        }
        return clazz.toString();
    }

    private static String stringForLocation(Class<?> owner, AccessStrategy access) {
        return access == null ? owner.getName() : access.toString();
    }

    private static void fillAssignableTypes(Type type, Set<Type> validatorsTypes, List<Type> suitableTypes) {
        for (Type validatorType : validatorsTypes) {
            if (!TypeUtils.isAssignable(type, validatorType) || suitableTypes.contains(validatorType)) continue;
            suitableTypes.add(validatorType);
        }
    }

    private static void reduceAssignableTypes(List<Type> assignableTypes) {
        if (assignableTypes.size() <= 1) {
            return;
        }
        boolean removed = false;
        do {
            Type type = assignableTypes.get(0);
            for (int i = 1; i < assignableTypes.size(); ++i) {
                Type nextType = assignableTypes.get(i);
                if (TypeUtils.isAssignable(nextType, type)) {
                    assignableTypes.remove(0);
                    --i;
                    removed = true;
                    continue;
                }
                if (!TypeUtils.isAssignable(type, nextType)) continue;
                assignableTypes.remove(i--);
                removed = true;
            }
        } while (removed && assignableTypes.size() > 1);
    }

    private static <A extends Annotation> Map<Type, Collection<Class<? extends ConstraintValidator<A, ?>>>> getValidatorsTypes(Class<? extends ConstraintValidator<A, ?>>[] constraintValidatorClasses) {
        HashMap validatorsTypes = new HashMap();
        for (Class<ConstraintValidator<A, ?>> clazz : constraintValidatorClasses) {
            Type componentType;
            Class<?> validatedType = TypeUtils.getTypeArguments(clazz, ConstraintValidator.class).get(ConstraintValidator.class.getTypeParameters()[1]);
            if (validatedType == null) {
                throw new ValidationException(String.format("Could not detect validated type for %s", clazz));
            }
            if (validatedType instanceof GenericArrayType && (componentType = TypeUtils.getArrayComponentType(validatedType)) instanceof Class) {
                validatedType = Array.newInstance((Class)componentType, 0).getClass();
            }
            if (!validatorsTypes.containsKey(validatedType)) {
                validatorsTypes.put(validatedType, new ArrayList());
            }
            ((Collection)validatorsTypes.get(validatedType)).add(clazz);
        }
        return validatorsTypes;
    }

    private static Type determineTargetedType(Class<?> owner, AccessStrategy access) {
        if (access == null) {
            return owner;
        }
        Class<?> type = access.getJavaType();
        if (type == null) {
            return Object.class;
        }
        return type instanceof Class ? Reflection.primitiveToWrapper(type) : type;
    }

    public void initialize() {
        if (null != this.validator) {
            try {
                this.validator.initialize(this.annotation);
            }
            catch (RuntimeException e) {
                throw new ConstraintDefinitionException("Incorrect validator [" + this.validator.getClass().getCanonicalName() + "] for annotation " + this.annotation.annotationType().getCanonicalName(), e);
            }
        }
    }

    private boolean isReachable(GroupValidationContext<?> context) {
        PathImpl path = context.getPropertyPath();
        NodeImpl node = path.getLeafNode();
        PathImpl beanPath = path.getPathWithoutLeafNode();
        if (beanPath == null) {
            beanPath = PathImpl.create();
        }
        try {
            if (!context.getTraversableResolver().isReachable(context.getBean(), node, context.getRootMetaBean().getBeanClass(), beanPath, this.access.getElementType())) {
                return false;
            }
        }
        catch (RuntimeException e) {
            throw new ValidationException("Error in TraversableResolver.isReachable() for " + context.getBean(), e);
        }
        return true;
    }

    private void addErrors(GroupValidationContext<?> context, ConstraintValidatorContextImpl jsrContext) {
        for (ValidationListener.Error each : jsrContext.getErrorMessages()) {
            ((ConstraintValidationListener)context.getListener()).addError(each, context);
        }
    }

    public String toString() {
        return "ConstraintValidation{" + this.validator + '}';
    }

    @Override
    public String getMessageTemplate() {
        return (String)ConstraintAnnotationAttributes.MESSAGE.get(this.attributes);
    }

    public ConstraintValidator<T, ?> getValidator() {
        return this.validator;
    }

    protected boolean isMemberOf(Class<?> reqGroup) {
        return this.groups.contains(reqGroup);
    }

    public Class<?> getOwner() {
        return this.owner;
    }

    @Override
    public T getAnnotation() {
        return this.annotation;
    }

    public AccessStrategy getAccess() {
        return this.access;
    }

    public void setAnnotation(T annotation) {
        this.annotation = annotation;
    }

    @Override
    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    @Override
    public Set<ConstraintDescriptor<?>> getComposingConstraints() {
        return this.composedConstraints == null ? Collections.EMPTY_SET : this.composedConstraints;
    }

    Set<ConstraintValidation<?>> getComposingValidations() {
        return this.composedConstraints == null ? Collections.emptySet() : this.composedConstraints;
    }

    @Override
    public Set<Class<?>> getGroups() {
        return this.groups;
    }

    @Override
    public Set<Class<? extends Payload>> getPayload() {
        return this.payload;
    }

    @Override
    public ConstraintTarget getValidationAppliesTo() {
        return this.validationAppliesTo;
    }

    @Override
    public List<Class<? extends ConstraintValidator<T, ?>>> getConstraintValidatorClasses() {
        return this.validatorClasses == null ? Collections.emptyList() : Arrays.asList(this.validatorClasses);
    }

    public void setValidationAppliesTo(ConstraintTarget validationAppliesTo) {
        this.validationAppliesTo = validationAppliesTo;
    }

    public boolean isValidated() {
        return this.validated;
    }

    public void setValidated(boolean validated) {
        this.validated = validated;
    }
}

