# Licensed to the Apache Software Foundation (ASF) under one
# or more contributor license agreements.  See the NOTICE file
# distributed with this work for additional information
# regarding copyright ownership.  The ASF licenses this file
# to you under the Apache License, Version 2.0 (the
# "License"); you may not use this file except in compliance
# with the License.  You may obtain a copy of the License at
#
#   http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing,
# software distributed under the License is distributed on an
# "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
# KIND, either express or implied.  See the License for the
# specific language governing permissions and limitations
# under the License.

"""
> DO NOT EDIT IT MANUALLY <

This file is generated by opendal/dev/src/generate/python.rs.
`opendal.__base` doesn't exists.
"""

from typing import Literal, TypeAlias, overload

# `true`/`false`` in any case, for example, `true`/`True`/`TRUE` `false`/`False`/`FALSE`
_bool: TypeAlias = str
# a str represent a int, for example, `"10"`/`"0"`
_int: TypeAlias = str

# a human readable duration string
# see https://docs.rs/humantime/latest/humantime/fn.parse_duration.html
# for more details
_duration: TypeAlias = str

# A "," separated string, for example `"127.0.0.1:1,127.0.0.1:2"`
_strings: TypeAlias = str

class _Base:
    """this is not a real base class but typing mixin,

    The services list here is support by opendal pypi wheel.
    """

    @overload
    def __init__(
        self,
        scheme: Literal["aliyun_drive"],
        /,
        *,
        drive_type: str,
        root: str = ...,
        access_token: str = ...,
        client_id: str = ...,
        client_secret: str = ...,
        refresh_token: str = ...,
    ) -> None: ...
    @overload
    def __init__(
        self,
        scheme: Literal["alluxio"],
        /,
        *,
        root: str = ...,
        endpoint: str = ...,
    ) -> None: ...
    @overload
    def __init__(
        self,
        scheme: Literal["atomicserver"],
        /,
        *,
        root: str = ...,
        endpoint: str = ...,
        private_key: str = ...,
        public_key: str = ...,
        parent_resource_id: str = ...,
    ) -> None: ...
    @overload
    def __init__(
        self,
        scheme: Literal["azblob"],
        /,
        *,
        container: str,
        root: str = ...,
        endpoint: str = ...,
        account_name: str = ...,
        account_key: str = ...,
        encryption_key: str = ...,
        encryption_key_sha256: str = ...,
        encryption_algorithm: str = ...,
        sas_token: str = ...,
        batch_max_operations: _int = ...,
    ) -> None: ...
    @overload
    def __init__(
        self,
        scheme: Literal["azdls"],
        /,
        *,
        filesystem: str,
        root: str = ...,
        endpoint: str = ...,
        account_name: str = ...,
        account_key: str = ...,
    ) -> None: ...
    @overload
    def __init__(
        self,
        scheme: Literal["azfile"],
        /,
        *,
        share_name: str,
        root: str = ...,
        endpoint: str = ...,
        account_name: str = ...,
        account_key: str = ...,
        sas_token: str = ...,
    ) -> None: ...
    @overload
    def __init__(
        self,
        scheme: Literal["b2"],
        /,
        *,
        bucket: str,
        bucket_id: str,
        root: str = ...,
        application_key_id: str = ...,
        application_key: str = ...,
    ) -> None: ...
    @overload
    def __init__(
        self,
        scheme: Literal["cacache"],
        /,
        *,
        datadir: str = ...,
    ) -> None: ...
    @overload
    def __init__(
        self,
        scheme: Literal["cloudflare_kv"],
        /,
        *,
        token: str = ...,
        account_id: str = ...,
        namespace_id: str = ...,
        root: str = ...,
    ) -> None: ...
    @overload
    def __init__(
        self,
        scheme: Literal["compfs"],
        /,
        *,
        root: str = ...,
    ) -> None: ...
    @overload
    def __init__(
        self,
        scheme: Literal["cos"],
        /,
        *,
        root: str = ...,
        endpoint: str = ...,
        secret_id: str = ...,
        secret_key: str = ...,
        bucket: str = ...,
        enable_versioning: _bool = ...,
        disable_config_load: _bool = ...,
    ) -> None: ...
    @overload
    def __init__(
        self,
        scheme: Literal["d1"],
        /,
        *,
        token: str = ...,
        account_id: str = ...,
        database_id: str = ...,
        root: str = ...,
        table: str = ...,
        key_field: str = ...,
        value_field: str = ...,
    ) -> None: ...
    @overload
    def __init__(
        self,
        scheme: Literal["dashmap"],
        /,
        *,
        root: str = ...,
    ) -> None: ...
    @overload
    def __init__(
        self,
        scheme: Literal["dbfs"],
        /,
        *,
        root: str = ...,
        endpoint: str = ...,
        token: str = ...,
    ) -> None: ...
    @overload
    def __init__(
        self,
        scheme: Literal["dropbox"],
        /,
        *,
        root: str = ...,
        access_token: str = ...,
        refresh_token: str = ...,
        client_id: str = ...,
        client_secret: str = ...,
    ) -> None: ...
    @overload
    def __init__(
        self,
        scheme: Literal["fs"],
        /,
        *,
        root: str = ...,
        atomic_write_dir: str = ...,
    ) -> None: ...
    @overload
    def __init__(
        self,
        scheme: Literal["gcs"],
        /,
        *,
        bucket: str,
        root: str = ...,
        endpoint: str = ...,
        scope: str = ...,
        service_account: str = ...,
        credential: str = ...,
        credential_path: str = ...,
        predefined_acl: str = ...,
        default_storage_class: str = ...,
        allow_anonymous: _bool = ...,
        disable_vm_metadata: _bool = ...,
        disable_config_load: _bool = ...,
        token: str = ...,
    ) -> None: ...
    @overload
    def __init__(
        self,
        scheme: Literal["gdrive"],
        /,
        *,
        root: str = ...,
        access_token: str = ...,
        refresh_token: str = ...,
        client_id: str = ...,
        client_secret: str = ...,
    ) -> None: ...
    @overload
    def __init__(
        self,
        scheme: Literal["ghac"],
        /,
        *,
        root: str = ...,
        version: str = ...,
        endpoint: str = ...,
        runtime_token: str = ...,
    ) -> None: ...
    @overload
    def __init__(
        self,
        scheme: Literal["github"],
        /,
        *,
        owner: str,
        repo: str,
        root: str = ...,
        token: str = ...,
    ) -> None: ...
    @overload
    def __init__(
        self,
        scheme: Literal["gridfs"],
        /,
        *,
        connection_string: str = ...,
        database: str = ...,
        bucket: str = ...,
        chunk_size: _int = ...,
        root: str = ...,
    ) -> None: ...
    @overload
    def __init__(
        self,
        scheme: Literal["hdfs_native"],
        /,
        *,
        root: str = ...,
        name_node: str = ...,
        enable_append: _bool = ...,
    ) -> None: ...
    @overload
    def __init__(
        self,
        scheme: Literal["http"],
        /,
        *,
        endpoint: str = ...,
        username: str = ...,
        password: str = ...,
        token: str = ...,
        root: str = ...,
    ) -> None: ...
    @overload
    def __init__(
        self,
        scheme: Literal["huggingface"],
        /,
        *,
        repo_type: str = ...,
        repo_id: str = ...,
        revision: str = ...,
        root: str = ...,
        token: str = ...,
    ) -> None: ...
    @overload
    def __init__(
        self,
        scheme: Literal["icloud"],
        /,
        *,
        root: str = ...,
        apple_id: str = ...,
        password: str = ...,
        trust_token: str = ...,
        ds_web_auth_token: str = ...,
        is_china_mainland: _bool = ...,
    ) -> None: ...
    @overload
    def __init__(
        self,
        scheme: Literal["ipfs"],
        /,
        *,
        endpoint: str = ...,
        root: str = ...,
    ) -> None: ...
    @overload
    def __init__(
        self,
        scheme: Literal["ipmfs"],
        /,
        *,
        root: str = ...,
        endpoint: str = ...,
    ) -> None: ...
    @overload
    def __init__(
        self,
        scheme: Literal["koofr"],
        /,
        *,
        endpoint: str,
        email: str,
        root: str = ...,
        password: str = ...,
    ) -> None: ...
    @overload
    def __init__(
        self,
        scheme: Literal["lakefs"],
        /,
        *,
        endpoint: str = ...,
        username: str = ...,
        password: str = ...,
        root: str = ...,
        repository: str = ...,
        branch: str = ...,
    ) -> None: ...
    @overload
    def __init__(
        self,
        scheme: Literal["memcached"],
        /,
        *,
        endpoint: str = ...,
        root: str = ...,
        username: str = ...,
        password: str = ...,
        default_ttl: _duration = ...,
    ) -> None: ...
    @overload
    def __init__(
        self,
        scheme: Literal["memory"],
        /,
        *,
        root: str = ...,
    ) -> None: ...
    @overload
    def __init__(
        self,
        scheme: Literal["mini_moka"],
        /,
        *,
        max_capacity: _int = ...,
        time_to_live: _duration = ...,
        time_to_idle: _duration = ...,
        root: str = ...,
    ) -> None: ...
    @overload
    def __init__(
        self,
        scheme: Literal["moka"],
        /,
        *,
        name: str = ...,
        max_capacity: _int = ...,
        time_to_live: _duration = ...,
        time_to_idle: _duration = ...,
        num_segments: _int = ...,
        root: str = ...,
    ) -> None: ...
    @overload
    def __init__(
        self,
        scheme: Literal["mongodb"],
        /,
        *,
        connection_string: str = ...,
        database: str = ...,
        collection: str = ...,
        root: str = ...,
        key_field: str = ...,
        value_field: str = ...,
    ) -> None: ...
    @overload
    def __init__(
        self,
        scheme: Literal["monoiofs"],
        /,
        *,
        root: str = ...,
    ) -> None: ...
    @overload
    def __init__(
        self,
        scheme: Literal["mysql"],
        /,
        *,
        connection_string: str = ...,
        table: str = ...,
        key_field: str = ...,
        value_field: str = ...,
        root: str = ...,
    ) -> None: ...
    @overload
    def __init__(
        self,
        scheme: Literal["nebula_graph"],
        /,
        *,
        host: str = ...,
        port: _int = ...,
        username: str = ...,
        password: str = ...,
        space: str = ...,
        tag: str = ...,
        key_field: str = ...,
        value_field: str = ...,
        root: str = ...,
    ) -> None: ...
    @overload
    def __init__(
        self,
        scheme: Literal["obs"],
        /,
        *,
        root: str = ...,
        endpoint: str = ...,
        access_key_id: str = ...,
        secret_access_key: str = ...,
        bucket: str = ...,
        enable_versioning: _bool = ...,
    ) -> None: ...
    @overload
    def __init__(
        self,
        scheme: Literal["onedrive"],
        /,
        *,
        root: str = ...,
        access_token: str = ...,
        refresh_token: str = ...,
        client_id: str = ...,
        client_secret: str = ...,
        enable_versioning: _bool = ...,
    ) -> None: ...
    @overload
    def __init__(
        self,
        scheme: Literal["opfs"],
        /,
    ) -> None: ...
    @overload
    def __init__(
        self,
        scheme: Literal["oss"],
        /,
        *,
        bucket: str,
        root: str = ...,
        endpoint: str = ...,
        presign_endpoint: str = ...,
        enable_versioning: _bool = ...,
        server_side_encryption: str = ...,
        server_side_encryption_key_id: str = ...,
        allow_anonymous: _bool = ...,
        access_key_id: str = ...,
        access_key_secret: str = ...,
        # deprecated: Please use `delete_max_size` instead of `batch_max_operations`
        batch_max_operations: _int = ...,
        delete_max_size: _int = ...,
        role_arn: str = ...,
        role_session_name: str = ...,
        oidc_provider_arn: str = ...,
        oidc_token_file: str = ...,
        sts_endpoint: str = ...,
    ) -> None: ...
    @overload
    def __init__(
        self,
        scheme: Literal["pcloud"],
        /,
        *,
        endpoint: str,
        root: str = ...,
        username: str = ...,
        password: str = ...,
    ) -> None: ...
    @overload
    def __init__(
        self,
        scheme: Literal["persy"],
        /,
        *,
        datafile: str = ...,
        segment: str = ...,
        index: str = ...,
    ) -> None: ...
    @overload
    def __init__(
        self,
        scheme: Literal["postgresql"],
        /,
        *,
        root: str = ...,
        connection_string: str = ...,
        table: str = ...,
        key_field: str = ...,
        value_field: str = ...,
    ) -> None: ...
    @overload
    def __init__(
        self,
        scheme: Literal["redb"],
        /,
        *,
        datadir: str = ...,
        root: str = ...,
        table: str = ...,
    ) -> None: ...
    @overload
    def __init__(
        self,
        scheme: Literal["redis"],
        /,
        *,
        db: _int,
        endpoint: str = ...,
        cluster_endpoints: str = ...,
        username: str = ...,
        password: str = ...,
        root: str = ...,
        default_ttl: _duration = ...,
    ) -> None: ...
    @overload
    def __init__(
        self,
        scheme: Literal["s3"],
        /,
        *,
        bucket: str,
        root: str = ...,
        enable_versioning: _bool = ...,
        endpoint: str = ...,
        region: str = ...,
        access_key_id: str = ...,
        secret_access_key: str = ...,
        session_token: str = ...,
        role_arn: str = ...,
        external_id: str = ...,
        role_session_name: str = ...,
        disable_config_load: _bool = ...,
        disable_ec2_metadata: _bool = ...,
        allow_anonymous: _bool = ...,
        server_side_encryption: str = ...,
        server_side_encryption_aws_kms_key_id: str = ...,
        server_side_encryption_customer_algorithm: str = ...,
        server_side_encryption_customer_key: str = ...,
        server_side_encryption_customer_key_md5: str = ...,
        default_storage_class: str = ...,
        enable_virtual_host_style: _bool = ...,
        # deprecated: Please use `delete_max_size` instead of `batch_max_operations`
        batch_max_operations: _int = ...,
        delete_max_size: _int = ...,
        disable_stat_with_override: _bool = ...,
        checksum_algorithm: str = ...,
        disable_write_with_if_match: _bool = ...,
        enable_write_with_append: _bool = ...,
        disable_list_objects_v2: _bool = ...,
    ) -> None: ...
    @overload
    def __init__(
        self,
        scheme: Literal["seafile"],
        /,
        *,
        repo_name: str,
        root: str = ...,
        endpoint: str = ...,
        username: str = ...,
        password: str = ...,
    ) -> None: ...
    @overload
    def __init__(
        self,
        scheme: Literal["sftp"],
        /,
        *,
        endpoint: str = ...,
        root: str = ...,
        user: str = ...,
        key: str = ...,
        known_hosts_strategy: str = ...,
        enable_copy: _bool = ...,
    ) -> None: ...
    @overload
    def __init__(
        self,
        scheme: Literal["sled"],
        /,
        *,
        datadir: str = ...,
        root: str = ...,
        tree: str = ...,
    ) -> None: ...
    @overload
    def __init__(
        self,
        scheme: Literal["sqlite"],
        /,
        *,
        connection_string: str = ...,
        table: str = ...,
        key_field: str = ...,
        value_field: str = ...,
        root: str = ...,
    ) -> None: ...
    @overload
    def __init__(
        self,
        scheme: Literal["surrealdb"],
        /,
        *,
        connection_string: str = ...,
        username: str = ...,
        password: str = ...,
        namespace: str = ...,
        database: str = ...,
        table: str = ...,
        key_field: str = ...,
        value_field: str = ...,
        root: str = ...,
    ) -> None: ...
    @overload
    def __init__(
        self,
        scheme: Literal["swift"],
        /,
        *,
        endpoint: str = ...,
        container: str = ...,
        root: str = ...,
        token: str = ...,
    ) -> None: ...
    @overload
    def __init__(
        self,
        scheme: Literal["upyun"],
        /,
        *,
        bucket: str,
        root: str = ...,
        operator: str = ...,
        password: str = ...,
    ) -> None: ...
    @overload
    def __init__(
        self,
        scheme: Literal["vercel_artifacts"],
        /,
        *,
        access_token: str = ...,
    ) -> None: ...
    @overload
    def __init__(
        self,
        scheme: Literal["vercel_blob"],
        /,
        *,
        root: str = ...,
        token: str = ...,
    ) -> None: ...
    @overload
    def __init__(
        self,
        scheme: Literal["webdav"],
        /,
        *,
        endpoint: str = ...,
        username: str = ...,
        password: str = ...,
        token: str = ...,
        root: str = ...,
        disable_copy: _bool = ...,
    ) -> None: ...
    @overload
    def __init__(
        self,
        scheme: Literal["webhdfs"],
        /,
        *,
        root: str = ...,
        endpoint: str = ...,
        user_name: str = ...,
        delegation: str = ...,
        disable_list_batch: _bool = ...,
        atomic_write_dir: str = ...,
    ) -> None: ...
    @overload
    def __init__(
        self,
        scheme: Literal["yandex_disk"],
        /,
        *,
        access_token: str,
        root: str = ...,
    ) -> None: ...
    @overload
    def __init__(self, scheme: str, /, **kwargs: str) -> None: ...
