/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.client.core.domain;

import org.apache.olingo.client.api.domain.ClientCollectionValue;
import org.apache.olingo.client.api.domain.ClientComplexValue;
import org.apache.olingo.client.api.domain.ClientEnumValue;
import org.apache.olingo.client.api.domain.ClientPrimitiveValue;
import org.apache.olingo.client.api.domain.ClientValuable;
import org.apache.olingo.client.api.domain.ClientValue;

public class ClientValuableImpl
implements ClientValuable {
    protected final ClientValue value;

    public ClientValuableImpl(ClientValue value) {
        this.value = value;
    }

    @Override
    public ClientValue getValue() {
        return this.value;
    }

    @Override
    public boolean hasNullValue() {
        return this.value == null;
    }

    @Override
    public boolean hasPrimitiveValue() {
        return this.value != null && this.value.isPrimitive();
    }

    @Override
    public ClientPrimitiveValue getPrimitiveValue() {
        return this.hasPrimitiveValue() ? this.value.asPrimitive() : null;
    }

    @Override
    public boolean hasCollectionValue() {
        return !this.hasNullValue() && this.value.isCollection();
    }

    @Override
    public ClientCollectionValue<ClientValue> getCollectionValue() {
        return this.hasCollectionValue() ? this.getValue().asCollection() : null;
    }

    @Override
    public boolean hasComplexValue() {
        return this.value != null && this.value.isComplex();
    }

    @Override
    public ClientComplexValue getComplexValue() {
        return this.hasComplexValue() ? this.getValue().asComplex() : null;
    }

    @Override
    public boolean hasEnumValue() {
        return !this.hasNullValue() && this.getValue().isEnum();
    }

    @Override
    public ClientEnumValue getEnumValue() {
        return this.hasEnumValue() ? this.getValue().asEnum() : null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClientValuableImpl that = (ClientValuableImpl)o;
        return !(this.value == null ? that.value != null : !this.value.equals(that.value));
    }

    public int hashCode() {
        return this.value != null ? this.value.hashCode() : 0;
    }

    public String toString() {
        return "ClientValuableImpl{value=" + this.value + '}';
    }
}

