/****************************************************************************
 * include/nuttx/crypto/tea.h
 * Tiny Encryption Algorithm
 *
 *   Copyright (C) 2016 Gregory Nutt. All rights reserved.
 *   Author: Gregory Nutt <gnutt@nuttx.org>
 *
 * https://en.wikipedia.org/wiki/Tiny_Encryption_Algorithm:  "Following is
 * an adaptation of the reference encryption and decryption routines in C,
 * released into the public domain by David Wheeler and Roger Needham."
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 * 3. Neither the name NuttX nor the names of its contributors may be
 *    used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 * FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
 * COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS
 * OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED
 * AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN
 * ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 ****************************************************************************/

#ifndef __INCLUDE_NUTTX_CRYPTO_TEA_H
#define __INCLUDE_NUTTX_CRYPTO_TEA_H

/****************************************************************************
 * Included Files
 ****************************************************************************/

#include <stdint.h>

/****************************************************************************
 * Public Function Prototypes
 ****************************************************************************/

/****************************************************************************
 * Name: tea_encrypt
 *
 * Input Parameters:
 *   value = 2 x 32-bit value (input/output)
 *   key   = 4 x 32-bit Cache key (input)
 *
 ****************************************************************************/

void tea_encrypt(FAR uint32_t *value, FAR const uint32_t *key);

/****************************************************************************
 * Name: tea_decrypt
 *
 * Input Parameters:
 *   value = 2 x 32-bit value (input/output)
 *   key   = 4 x 32-bit Cache key (input)
 *
 ****************************************************************************/

void tea_decrypt(FAR uint32_t *value, FAR const uint32_t *key);

#endif /* __INCLUDE_NUTTX_CRYPTO_TEA_H */
