/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller.status.history.questdb;

import io.questdb.cairo.TableWriter;
import java.time.Instant;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.nifi.controller.status.history.questdb.QuestDbWritingTemplate;

public class QuestDbEntityWritingTemplate<E>
extends QuestDbWritingTemplate<Pair<Instant, E>> {
    private final BiConsumer<E, TableWriter.Row> fillRow;

    public QuestDbEntityWritingTemplate(String tableName, BiConsumer<E, TableWriter.Row> fillRow) {
        super(tableName);
        this.fillRow = fillRow;
    }

    @Override
    protected void addRows(TableWriter tableWriter, Collection<Pair<Instant, E>> entries) {
        entries.forEach(statusEntry -> {
            long capturedAt = TimeUnit.MILLISECONDS.toMicros(((Instant)statusEntry.getLeft()).toEpochMilli());
            TableWriter.Row row = tableWriter.newRow(capturedAt);
            this.fillRow.accept(statusEntry.getRight(), row);
            row.append();
        });
    }
}

