/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.registry.security.util;

import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.Provider;
import java.security.Security;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.registry.security.util.KeystoreType;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeyStoreUtils {
    private static final Logger logger = LoggerFactory.getLogger(KeyStoreUtils.class);
    private static final String SUN_SECURITY_PROVIDER = "SUN";
    private static final Map<String, String> KEY_STORE_TYPE_PROVIDERS = new HashMap<String, String>();

    public static String getKeyStoreProvider(String keyStoreType) {
        String storeType = StringUtils.upperCase((String)keyStoreType);
        return KEY_STORE_TYPE_PROVIDERS.get(storeType);
    }

    public static KeyStore getKeyStore(String keyStoreType) throws KeyStoreException {
        String keyStoreProvider = KeyStoreUtils.getKeyStoreProvider(keyStoreType);
        if (StringUtils.isNotEmpty((CharSequence)keyStoreProvider)) {
            try {
                return KeyStore.getInstance(keyStoreType, keyStoreProvider);
            }
            catch (Exception e) {
                logger.error("Unable to load " + keyStoreProvider + " " + keyStoreType + " keystore.  This may cause issues getting trusted CA certificates as well as Certificate Chains for use in TLS.", (Throwable)e);
            }
        }
        return KeyStore.getInstance(keyStoreType);
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
        KEY_STORE_TYPE_PROVIDERS.put(KeystoreType.JKS.toString(), SUN_SECURITY_PROVIDER);
        KEY_STORE_TYPE_PROVIDERS.put(KeystoreType.PKCS12.toString(), "BC");
        KEY_STORE_TYPE_PROVIDERS.put(KeystoreType.BCFKS.toString(), "BC");
    }
}

