/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.registry.bucket;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotBlank;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.nifi.registry.authorization.Permissions;
import org.apache.nifi.registry.link.LinkableEntity;
import org.apache.nifi.registry.revision.entity.RevisableEntity;
import org.apache.nifi.registry.revision.entity.RevisionInfo;

@XmlRootElement
@ApiModel
public class Bucket
extends LinkableEntity
implements RevisableEntity {
    @NotBlank
    private String identifier;
    @NotBlank
    private String name;
    @Min(value=1L)
    private @Min(value=1L) long createdTimestamp;
    private String description;
    private Boolean allowBundleRedeploy;
    private Boolean allowPublicRead;
    private Permissions permissions;
    private RevisionInfo revision;

    @ApiModelProperty(value="An ID to uniquely identify this object.", readOnly=true)
    public String getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    @ApiModelProperty(value="The name of the bucket.", required=true)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @ApiModelProperty(value="The timestamp of when the bucket was first created. This is set by the server at creation time.", readOnly=true)
    public long getCreatedTimestamp() {
        return this.createdTimestamp;
    }

    public void setCreatedTimestamp(long createdTimestamp) {
        this.createdTimestamp = createdTimestamp;
    }

    @ApiModelProperty(value="A description of the bucket.")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @ApiModelProperty(value="Indicates if this bucket allows the same version of an extension bundle to be redeployed and thus overwrite the existing artifact. By default this is false.")
    public Boolean isAllowBundleRedeploy() {
        return this.allowBundleRedeploy;
    }

    public void setAllowBundleRedeploy(Boolean allowBundleRedeploy) {
        this.allowBundleRedeploy = allowBundleRedeploy;
    }

    @ApiModelProperty(value="Indicates if this bucket allows read access to unauthenticated anonymous users")
    public Boolean isAllowPublicRead() {
        return this.allowPublicRead;
    }

    public void setAllowPublicRead(Boolean allowPublicRead) {
        this.allowPublicRead = allowPublicRead;
    }

    @ApiModelProperty(value="The access that the current user has to this bucket.", readOnly=true)
    public Permissions getPermissions() {
        return this.permissions;
    }

    public void setPermissions(Permissions permissions) {
        this.permissions = permissions;
    }

    @ApiModelProperty(value="The revision of this entity used for optimistic-locking during updates.", readOnly=true)
    public RevisionInfo getRevision() {
        return this.revision;
    }

    public void setRevision(RevisionInfo revision) {
        this.revision = revision;
    }

    public int hashCode() {
        return Objects.hashCode(this.getIdentifier());
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Bucket other = (Bucket)obj;
        return Objects.equals(this.getIdentifier(), other.getIdentifier());
    }
}

