/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.core.dataStructures;

import jetbrains.exodus.core.dataStructures.ObjectCacheBase;
import jetbrains.exodus.core.dataStructures.hash.HashUtil;
import jetbrains.exodus.util.MathUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConcurrentObjectCache<K, V>
extends ObjectCacheBase<K, V> {
    static final int DEFAULT_NUMBER_OF_GENERATIONS = 3;
    private final int numberOfGenerations;
    private final int generationSize;
    private final int mask;
    private final CacheEntry<K, V>[] cache;

    public ConcurrentObjectCache() {
        this(8192);
    }

    public ConcurrentObjectCache(int size) {
        this(size, 3);
    }

    public ConcurrentObjectCache(int size, int numberOfGenerations) {
        super(size);
        this.numberOfGenerations = numberOfGenerations;
        this.generationSize = HashUtil.getFloorPrime(size / numberOfGenerations);
        this.mask = (1 << MathUtil.integerLogarithm(this.generationSize)) - 1;
        this.cache = new CacheEntry[numberOfGenerations * this.generationSize];
    }

    @Override
    public V tryKeyLocked(@NotNull K key) {
        return this.tryKey(key);
    }

    @Override
    public void clear() {
    }

    @Override
    public void lock() {
    }

    @Override
    public void unlock() {
    }

    @Override
    public V cacheObject(@NotNull K key, @NotNull V x) {
        int cacheIndex = HashUtil.indexFor(key.hashCode(), this.generationSize, this.mask) * this.numberOfGenerations;
        int i = 0;
        while (i < this.numberOfGenerations) {
            CacheEntry<K, V> entry = this.cache[cacheIndex];
            if (entry != null && ((CacheEntry)entry).key.equals(key)) {
                this.cache[cacheIndex] = new CacheEntry(key, x);
                return null;
            }
            ++i;
            ++cacheIndex;
        }
        this.cache[cacheIndex - 1] = new CacheEntry(key, x);
        return null;
    }

    @Override
    public V remove(@NotNull K key) {
        int cacheIndex = HashUtil.indexFor(key.hashCode(), this.generationSize, this.mask) * this.numberOfGenerations;
        int i = 0;
        while (i < this.numberOfGenerations) {
            CacheEntry<K, V> entry = this.cache[cacheIndex];
            if (entry != null && ((CacheEntry)entry).key.equals(key)) {
                Object result = ((CacheEntry)entry).value;
                ((CacheEntry)entry).value = null;
                return (V)result;
            }
            ++i;
            ++cacheIndex;
        }
        return null;
    }

    @Override
    public V tryKey(@NotNull K key) {
        this.incAttempts();
        int cacheIndex = HashUtil.indexFor(key.hashCode(), this.generationSize, this.mask) * this.numberOfGenerations;
        CacheEntry<K, V> entry = this.cache[cacheIndex];
        if (entry != null && ((CacheEntry)entry).key.equals(key)) {
            this.incHits();
            return (V)((CacheEntry)entry).value;
        }
        for (int i = 1; i < this.numberOfGenerations; ++i) {
            if ((entry = this.cache[++cacheIndex]) == null || !((CacheEntry)entry).key.equals(key)) continue;
            this.incHits();
            CacheEntry<K, V> temp = this.cache[cacheIndex - 1];
            this.cache[cacheIndex - 1] = entry;
            this.cache[cacheIndex] = temp;
            return (V)((CacheEntry)entry).value;
        }
        return null;
    }

    @Override
    public V getObject(@NotNull K key) {
        int cacheIndex = HashUtil.indexFor(key.hashCode(), this.generationSize, this.mask) * this.numberOfGenerations;
        int i = 0;
        while (i < this.numberOfGenerations) {
            CacheEntry<K, V> entry = this.cache[cacheIndex];
            if (entry != null && ((CacheEntry)entry).key.equals(key)) {
                return (V)((CacheEntry)entry).value;
            }
            ++i;
            ++cacheIndex;
        }
        return null;
    }

    @Override
    public int count() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ObjectCacheBase.CriticalSection newCriticalSection() {
        return TRIVIAL_CRITICAL_SECTION;
    }

    private static class CacheEntry<K, V> {
        @NotNull
        private final K key;
        @Nullable
        private V value;

        private CacheEntry(@NotNull K key, @Nullable V value) {
            this.key = key;
            this.value = value;
        }
    }
}

