/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.registry.variable;

import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import org.apache.nifi.registry.ComponentVariableRegistry;
import org.apache.nifi.registry.VariableDescriptor;
import org.apache.nifi.registry.VariableRegistry;

public class StandardComponentVariableRegistry
implements ComponentVariableRegistry {
    private volatile VariableRegistry parent;

    public StandardComponentVariableRegistry(VariableRegistry parent) {
        this.parent = Objects.requireNonNull(parent);
    }

    public Map<VariableDescriptor, String> getVariableMap() {
        return Collections.emptyMap();
    }

    public VariableRegistry getParent() {
        return this.parent;
    }

    public void setParent(VariableRegistry parentRegistry) {
        this.parent = parentRegistry;
    }

    public VariableDescriptor getVariableKey(String name) {
        if (name == null) {
            return null;
        }
        VariableDescriptor spec = new VariableDescriptor(name);
        for (Map.Entry<VariableDescriptor, String> entry : this.getVariableMap().entrySet()) {
            if (!entry.getKey().equals((Object)spec)) continue;
            return entry.getKey();
        }
        return null;
    }

    public String getVariableValue(String name) {
        if (name == null) {
            return null;
        }
        VariableDescriptor descriptor = new VariableDescriptor(name);
        String value = this.getVariableMap().get(descriptor);
        if (value != null) {
            return value;
        }
        return this.parent.getVariableValue(descriptor);
    }

    public String getVariableValue(VariableDescriptor descriptor) {
        if (descriptor == null) {
            return null;
        }
        String value = this.getVariableMap().get(descriptor);
        if (value != null) {
            return value;
        }
        return this.parent.getVariableValue(descriptor);
    }
}

