/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.tasks;

import io.questdb.cairo.CairoEngine;
import io.questdb.mp.RingQueue;
import io.questdb.mp.Sequence;
import io.questdb.std.Os;
import io.questdb.std.datetime.microtime.MicrosecondClock;

public final class TelemetryTask {
    public long created;
    public short event;
    public CharSequence id;
    public short origin;

    public static void doStoreTelemetry(CairoEngine engine, short event, short origin) {
        Sequence telemetryPubSeq = engine.getTelemetryPubSequence();
        if (null != telemetryPubSeq) {
            MicrosecondClock clock = engine.getConfiguration().getMicrosecondClock();
            RingQueue<TelemetryTask> telemetryQueue = engine.getTelemetryQueue();
            TelemetryTask.store(telemetryQueue, telemetryPubSeq, event, origin, clock);
        }
    }

    public static void store(RingQueue<TelemetryTask> telemetryQueue, Sequence telemetryPubSeq, short event, short origin, MicrosecondClock clock) {
        long cursor = telemetryPubSeq.next();
        while (cursor == -2L) {
            Os.pause();
            cursor = telemetryPubSeq.next();
        }
        if (cursor > -1L) {
            TelemetryTask row = telemetryQueue.get(cursor);
            row.created = clock.getTicks();
            row.event = event;
            row.origin = origin;
            telemetryPubSeq.done(cursor);
        }
    }

    @FunctionalInterface
    public static interface TelemetryMethod {
        public void store(short var1, short var2);
    }
}

