/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.std.str;

import io.questdb.std.Files;
import io.questdb.std.Unsafe;
import io.questdb.std.str.AbstractCharSink;
import io.questdb.std.str.CharSink;
import java.io.Closeable;

public final class StdoutSink
extends AbstractCharSink
implements Closeable {
    public static final StdoutSink INSTANCE = new StdoutSink();
    private final int bufferCapacity = 1024;
    private final long buffer = Unsafe.malloc(1024L, 1);
    private final long limit = this.buffer + 1024L;
    private long ptr = this.buffer;
    private final int stdout = Files.getStdOutFd();

    @Override
    public void close() {
        this.free();
    }

    @Override
    public void flush() {
        int len = (int)(this.ptr - this.buffer);
        if (len > 0) {
            Files.append(this.stdout, this.buffer, len);
            this.ptr = this.buffer;
        }
    }

    @Override
    public CharSink put(CharSequence cs) {
        if (cs != null) {
            int len = cs.length();
            for (int i = 0; i < len; ++i) {
                this.put(cs.charAt(i));
            }
        }
        return this;
    }

    @Override
    public CharSink put(char c) {
        if (this.ptr == this.limit) {
            this.flush();
        }
        Unsafe.getUnsafe().putByte(this.ptr++, (byte)c);
        return this;
    }

    private void free() {
        Unsafe.free(this.buffer, 1024L, 1);
    }
}

