/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.std;

public class IntPriorityQueue {
    private int[] buffer;
    private int limit;

    public IntPriorityQueue() {
        this(8);
    }

    private IntPriorityQueue(int size) {
        this.buffer = new int[size];
        this.limit = 0;
    }

    public void clear() {
        this.limit = 0;
    }

    public boolean notEmpty() {
        return this.limit > 0;
    }

    public int pop() {
        int v = this.buffer[0];
        if (--this.limit > 0) {
            System.arraycopy(this.buffer, 1, this.buffer, 0, this.limit);
        }
        return v;
    }

    public void push(int value) {
        int p = this.binSearch(value);
        if (p < this.limit) {
            System.arraycopy(this.buffer, p, this.buffer, p + 1, this.limit - p);
        }
        if (p >= this.buffer.length) {
            this.resize();
        }
        this.buffer[p] = value;
        ++this.limit;
    }

    private int binSearch(int v) {
        if (this.limit < 65) {
            return this.scanSearch(v);
        }
        return this.binSearch0(v);
    }

    private int binSearch0(int v) {
        int low = 0;
        int high = this.limit;
        while (low < high) {
            if (high - low < 65) {
                return this.scanSearch(v);
            }
            int mid = low + high - 1 >>> 1;
            int midVal = this.buffer[mid];
            if (midVal < v) {
                low = mid + 1;
                continue;
            }
            if (midVal > v) {
                high = mid;
                continue;
            }
            while (++mid < high && this.buffer[mid] == v) {
            }
            return mid;
        }
        return low;
    }

    private void resize() {
        int[] tmp = new int[this.buffer.length * 2];
        System.arraycopy(this.buffer, 0, tmp, 0, this.buffer.length);
        this.buffer = tmp;
    }

    private int scanSearch(int v) {
        for (int i = 0; i < this.limit; ++i) {
            if (this.buffer[i] <= v) continue;
            return i;
        }
        return this.limit;
    }
}

