/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.std;

import io.questdb.std.Misc;
import io.questdb.std.Mutable;
import io.questdb.std.Sinkable;
import io.questdb.std.str.CharSink;
import io.questdb.std.str.StringSink;
import java.util.Arrays;

public class IntList
implements Mutable,
Sinkable {
    private static final int DEFAULT_ARRAY_SIZE = 16;
    private static final int NO_ENTRY_VALUE = -1;
    private int[] buffer;
    private int pos = 0;

    public IntList() {
        this(16);
    }

    public IntList(int capacity) {
        this.buffer = new int[Math.max(capacity, 16)];
    }

    public void add(int value) {
        this.ensureCapacity0(this.pos + 1);
        this.buffer[this.pos++] = value;
    }

    public void addAll(IntList that) {
        int p = this.pos;
        int s = that.size();
        this.ensureCapacity(p + s);
        System.arraycopy(that.buffer, 0, this.buffer, p, s);
    }

    public void arrayCopy(int srcPos, int dstPos, int length) {
        System.arraycopy(this.buffer, srcPos, this.buffer, dstPos, length);
    }

    public int binarySearchUniqueList(int v) {
        int low = 0;
        int high = this.pos - 1;
        while (high - low > 65) {
            int mid = (low + high) / 2;
            int midVal = this.buffer[mid];
            if (midVal < v) {
                low = mid + 1;
                continue;
            }
            if (midVal > v) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return this.scanSearch(v, low, high + 1);
    }

    @Override
    public void clear() {
        this.pos = 0;
    }

    public void clear(int capacity) {
        this.ensureCapacity(capacity);
        this.pos = 0;
        Arrays.fill(this.buffer, -1);
    }

    public boolean contains(int value) {
        return this.indexOf(value, 0, this.pos) > -1;
    }

    public void ensureCapacity(int capacity) {
        this.ensureCapacity0(capacity);
        this.pos = capacity;
    }

    public boolean equals(Object that) {
        return this == that || that instanceof IntList && this.equals((IntList)that);
    }

    public void extendAndSet(int index, int value) {
        this.ensureCapacity0(index + 1);
        if (index >= this.pos) {
            this.pos = index + 1;
        }
        this.buffer[index] = value;
    }

    public int get(int index) {
        return this.getQuick(index);
    }

    public int getLast() {
        if (this.pos > 0) {
            return this.buffer[this.pos - 1];
        }
        return -1;
    }

    public int getQuick(int index) {
        assert (index < this.pos);
        return this.buffer[index];
    }

    public int hashCode() {
        int hashCode = 1;
        int n = this.pos;
        for (int i = 0; i < n; ++i) {
            int v = this.getQuick(i);
            hashCode = 31 * hashCode + (v == -1 ? 0 : v);
        }
        return hashCode;
    }

    public void increment(int index) {
        this.buffer[index] = this.buffer[index] + 1;
    }

    public int postIncrement(int index) {
        int prev = this.buffer[index];
        this.buffer[index] = prev + 1;
        return prev;
    }

    public void increment(int index, int delta) {
        assert (delta > -1);
        this.buffer[index] = this.buffer[index] + delta;
    }

    public int indexOf(int v, int low, int high) {
        assert (high <= this.pos);
        for (int i = low; i < high; ++i) {
            int f = this.buffer[i];
            if (f != v) continue;
            return i;
        }
        return -1;
    }

    public void insert(int index, int element) {
        this.ensureCapacity(++this.pos);
        System.arraycopy(this.buffer, index, this.buffer, index + 1, this.pos - index - 1);
        this.buffer[index] = element;
    }

    public void remove(int key) {
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            if (key != this.getQuick(i)) continue;
            this.removeIndex(i);
            return;
        }
    }

    public void removeIndex(int index) {
        if (this.pos < 1 || index >= this.pos) {
            return;
        }
        int move = this.pos - index - 1;
        if (move > 0) {
            System.arraycopy(this.buffer, index + 1, this.buffer, index, move);
        }
        int index1 = --this.pos;
        this.buffer[index1] = -1;
    }

    public void set(int index, int element) {
        if (index < this.pos) {
            this.buffer[index] = element;
            return;
        }
        throw new ArrayIndexOutOfBoundsException(index);
    }

    public void setAll(int capacity, int value) {
        this.ensureCapacity0(capacity);
        this.pos = capacity;
        Arrays.fill(this.buffer, 0, this.pos, value);
    }

    public void setPos(int capacity) {
        this.ensureCapacity(capacity);
        this.pos = capacity;
    }

    public void setQuick(int index, int value) {
        assert (index < this.pos);
        this.buffer[index] = value;
    }

    public int size() {
        return this.pos;
    }

    @Override
    public void toSink(CharSink sink) {
        sink.put('[');
        int k = this.size();
        for (int i = 0; i < k; ++i) {
            if (i > 0) {
                sink.put(',');
            }
            sink.put(this.get(i));
        }
        sink.put(']');
    }

    public void toSink(CharSink sink, int exceptValue) {
        sink.put('[');
        boolean pastFirst = false;
        int k = this.size();
        for (int i = 0; i < k; ++i) {
            int val;
            if (pastFirst) {
                sink.put(',');
            }
            if ((val = this.get(i)) == exceptValue) continue;
            sink.put(val);
            pastFirst = true;
        }
        sink.put(']');
    }

    public String toString() {
        StringSink b = Misc.getThreadLocalBuilder();
        this.toSink(b);
        return ((Object)b).toString();
    }

    public void zero(int value) {
        Arrays.fill(this.buffer, 0, this.pos, value);
    }

    private void ensureCapacity0(int capacity) {
        int l = this.buffer.length;
        if (capacity > l) {
            int newCap = Math.max(l << 1, capacity);
            int[] buf = new int[newCap];
            System.arraycopy(this.buffer, 0, buf, 0, l);
            this.buffer = buf;
        }
    }

    private boolean equals(IntList that) {
        if (this.pos != that.pos) {
            return false;
        }
        int n = this.pos;
        for (int i = 0; i < n; ++i) {
            if (this.getQuick(i) == that.getQuick(i)) continue;
            return false;
        }
        return true;
    }

    private int scanSearch(int v, int low, int high) {
        for (int i = low; i < high; ++i) {
            int f = this.buffer[i];
            if (f == v) {
                return i;
            }
            if (f <= v) continue;
            return -(i + 1);
        }
        return -(high + 1);
    }
}

