/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.join;

import io.questdb.cairo.sql.Record;
import io.questdb.std.BinarySequence;
import io.questdb.std.Long256;
import io.questdb.std.str.CharSink;

public class JoinRecord
implements Record {
    private final int split;
    protected Record slave;
    private Record master;

    public JoinRecord(int split) {
        this.split = split;
    }

    @Override
    public BinarySequence getBin(int col) {
        if (col < this.split) {
            return this.master.getBin(col);
        }
        return this.slave.getBin(col - this.split);
    }

    @Override
    public long getBinLen(int col) {
        if (col < this.split) {
            return this.master.getBinLen(col);
        }
        return this.slave.getBinLen(col - this.split);
    }

    @Override
    public boolean getBool(int col) {
        if (col < this.split) {
            return this.master.getBool(col);
        }
        return this.slave.getBool(col - this.split);
    }

    @Override
    public byte getByte(int col) {
        if (col < this.split) {
            return this.master.getByte(col);
        }
        return this.slave.getByte(col - this.split);
    }

    @Override
    public char getChar(int col) {
        if (col < this.split) {
            return this.master.getChar(col);
        }
        return this.slave.getChar(col - this.split);
    }

    @Override
    public long getDate(int col) {
        if (col < this.split) {
            return this.master.getDate(col);
        }
        return this.slave.getDate(col - this.split);
    }

    @Override
    public double getDouble(int col) {
        if (col < this.split) {
            return this.master.getDouble(col);
        }
        return this.slave.getDouble(col - this.split);
    }

    @Override
    public float getFloat(int col) {
        if (col < this.split) {
            return this.master.getFloat(col);
        }
        return this.slave.getFloat(col - this.split);
    }

    @Override
    public byte getGeoByte(int col) {
        if (col < this.split) {
            return this.master.getGeoByte(col);
        }
        return this.slave.getGeoByte(col - this.split);
    }

    @Override
    public int getGeoInt(int col) {
        if (col < this.split) {
            return this.master.getGeoInt(col);
        }
        return this.slave.getGeoInt(col - this.split);
    }

    @Override
    public long getGeoLong(int col) {
        if (col < this.split) {
            return this.master.getGeoLong(col);
        }
        return this.slave.getGeoLong(col - this.split);
    }

    @Override
    public short getGeoShort(int col) {
        if (col < this.split) {
            return this.master.getGeoShort(col);
        }
        return this.slave.getGeoShort(col - this.split);
    }

    @Override
    public int getInt(int col) {
        if (col < this.split) {
            return this.master.getInt(col);
        }
        return this.slave.getInt(col - this.split);
    }

    @Override
    public long getLong(int col) {
        if (col < this.split) {
            return this.master.getLong(col);
        }
        return this.slave.getLong(col - this.split);
    }

    @Override
    public long getLong128Hi(int col) {
        if (col < this.split) {
            return this.master.getLong128Hi(col);
        }
        return this.slave.getLong128Hi(col - this.split);
    }

    @Override
    public long getLong128Lo(int col) {
        if (col < this.split) {
            return this.master.getLong128Lo(col);
        }
        return this.slave.getLong128Lo(col - this.split);
    }

    @Override
    public void getLong256(int col, CharSink sink) {
        if (col < this.split) {
            this.master.getLong256(col, sink);
        } else {
            this.slave.getLong256(col - this.split, sink);
        }
    }

    @Override
    public Long256 getLong256A(int col) {
        if (col < this.split) {
            return this.master.getLong256A(col);
        }
        return this.slave.getLong256A(col - this.split);
    }

    @Override
    public Long256 getLong256B(int col) {
        if (col < this.split) {
            return this.master.getLong256B(col);
        }
        return this.slave.getLong256B(col - this.split);
    }

    @Override
    public Record getRecord(int col) {
        if (col < this.split) {
            return this.master.getRecord(col);
        }
        return this.slave.getRecord(col - this.split);
    }

    @Override
    public long getRowId() {
        return this.master.getRowId();
    }

    @Override
    public short getShort(int col) {
        if (col < this.split) {
            return this.master.getShort(col);
        }
        return this.slave.getShort(col - this.split);
    }

    @Override
    public CharSequence getStr(int col) {
        if (col < this.split) {
            return this.master.getStr(col);
        }
        return this.slave.getStr(col - this.split);
    }

    @Override
    public void getStr(int col, CharSink sink) {
        if (col < this.split) {
            this.master.getStr(col, sink);
        } else {
            this.slave.getStr(col - this.split, sink);
        }
    }

    @Override
    public CharSequence getStrB(int col) {
        if (col < this.split) {
            return this.master.getStrB(col);
        }
        return this.slave.getStrB(col - this.split);
    }

    @Override
    public int getStrLen(int col) {
        if (col < this.split) {
            return this.master.getStrLen(col);
        }
        return this.slave.getStrLen(col - this.split);
    }

    @Override
    public CharSequence getSym(int col) {
        if (col < this.split) {
            return this.master.getSym(col);
        }
        return this.slave.getSym(col - this.split);
    }

    @Override
    public CharSequence getSymB(int col) {
        if (col < this.split) {
            return this.master.getSymB(col);
        }
        return this.slave.getSymB(col - this.split);
    }

    @Override
    public long getTimestamp(int col) {
        if (col < this.split) {
            return this.master.getTimestamp(col);
        }
        return this.slave.getTimestamp(col - this.split);
    }

    @Override
    public long getUpdateRowId() {
        return this.master.getUpdateRowId();
    }

    void of(Record master, Record slave) {
        this.master = master;
        this.slave = slave;
    }
}

