/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.rnd;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.SymbolTableSource;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.StrFunction;
import io.questdb.griffin.engine.functions.rnd.RndStrFunction;
import io.questdb.std.IntList;
import io.questdb.std.ObjList;
import io.questdb.std.Rnd;

public class RndStrFunctionFactory
implements FunctionFactory {
    @Override
    public String getSignature() {
        return "rnd_str(iii)";
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) throws SqlException {
        int lo = args.getQuick(0).getInt(null);
        int hi = args.getQuick(1).getInt(null);
        int nullRate = args.getQuick(2).getInt(null);
        if (nullRate < 0) {
            throw SqlException.position(argPositions.getQuick(2)).put("rate must be positive");
        }
        if (lo < hi && lo > 0) {
            return new RndStrFunction(lo, hi, nullRate + 1);
        }
        if (lo == hi) {
            return new FixedFunction(lo, nullRate + 1);
        }
        throw SqlException.position(position).put("invalid range");
    }

    private static class FixedFunction
    extends StrFunction
    implements Function {
        private final int len;
        private final int nullRate;
        private Rnd rnd;

        public FixedFunction(int len, int nullRate) {
            this.len = len;
            this.nullRate = nullRate;
        }

        @Override
        public CharSequence getStr(Record rec) {
            if (this.rnd.nextInt() % this.nullRate == 1) {
                return null;
            }
            return this.rnd.nextChars(this.len);
        }

        @Override
        public CharSequence getStrB(Record rec) {
            return this.getStr(rec);
        }

        @Override
        public void init(SymbolTableSource symbolTableSource, SqlExecutionContext executionContext) {
            this.rnd = executionContext.getRandom();
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.val("rnd_str(").val(this.len).val(',').val(this.len).val(',').val(this.nullRate - 1).val(')');
        }
    }
}

