/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.date;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.SqlKeywords;
import io.questdb.griffin.engine.functions.IntFunction;
import io.questdb.griffin.engine.functions.LongFunction;
import io.questdb.griffin.engine.functions.UnaryFunction;
import io.questdb.griffin.engine.functions.date.DayOfMonthFunctionFactory;
import io.questdb.griffin.engine.functions.date.HourOfDayFunctionFactory;
import io.questdb.griffin.engine.functions.date.MinuteOfHourFunctionFactory;
import io.questdb.griffin.engine.functions.date.MonthOfYearFunctionFactory;
import io.questdb.griffin.engine.functions.date.SecondOfMinuteFunctionFactory;
import io.questdb.griffin.engine.functions.date.YearFunctionFactory;
import io.questdb.std.IntList;
import io.questdb.std.ObjList;
import io.questdb.std.datetime.microtime.Timestamps;

public class ExtractFromTimestampFunctionFactory
implements FunctionFactory {
    @Override
    public String getSignature() {
        return "extract(sN)";
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) throws SqlException {
        CharSequence part = args.getQuick(0).getStr(null);
        Function arg = args.getQuick(1);
        if (SqlKeywords.isCenturyKeyword(part)) {
            return new CenturyFunction(arg);
        }
        if (SqlKeywords.isDayKeyword(part)) {
            return new DayOfMonthFunctionFactory.DayOfMonthFunction(arg);
        }
        if (SqlKeywords.isDecadeKeyword(part)) {
            return new DecadeFunction(arg);
        }
        if (SqlKeywords.isDowKeyword(part)) {
            return new DowFunction(arg);
        }
        if (SqlKeywords.isDoyKeyword(part)) {
            return new DoyFunction(arg);
        }
        if (SqlKeywords.isEpochKeyword(part)) {
            return new EpochFunction(arg);
        }
        if (SqlKeywords.isHourKeyword(part)) {
            return new HourOfDayFunctionFactory.HourOfDayFunction(arg);
        }
        if (SqlKeywords.isIsoDowKeyword(part)) {
            return new IsoDowFunction(arg);
        }
        if (SqlKeywords.isIsoYearKeyword(part)) {
            return new IsoYearFunction(arg);
        }
        if (SqlKeywords.isMicrosecondsKeyword(part)) {
            return new MicrosecondsFunction(arg);
        }
        if (SqlKeywords.isMillenniumKeyword(part)) {
            return new MillenniumFunction(arg);
        }
        if (SqlKeywords.isMillisecondsKeyword(part)) {
            return new MillisecondsFunction(arg);
        }
        if (SqlKeywords.isMinuteKeyword(part)) {
            return new MinuteOfHourFunctionFactory.MinuteFunction(arg);
        }
        if (SqlKeywords.isMonthKeyword(part)) {
            return new MonthOfYearFunctionFactory.MonthOfYearFunction(arg);
        }
        if (SqlKeywords.isQuarterKeyword(part)) {
            return new QuarterFunction(arg);
        }
        if (SqlKeywords.isSecondKeyword(part)) {
            return new SecondOfMinuteFunctionFactory.SecondOfMinuteFunc(arg);
        }
        if (SqlKeywords.isWeekKeyword(part)) {
            return new WeekFunction(arg);
        }
        if (SqlKeywords.isYearKeyword(part)) {
            return new YearFunctionFactory.YearFunction(arg);
        }
        throw SqlException.position(argPositions.getQuick(0)).put("unsupported part '").put(part).put('\'');
    }

    static final class WeekFunction
    extends IntExtractFunction {
        public WeekFunction(Function arg) {
            super(arg);
        }

        @Override
        public int getInt(Record rec) {
            long value = this.arg.getTimestamp(rec);
            if (value != Long.MIN_VALUE) {
                return Timestamps.getWeek(value);
            }
            return Integer.MIN_VALUE;
        }
    }

    static final class QuarterFunction
    extends IntExtractFunction {
        public QuarterFunction(Function arg) {
            super(arg);
        }

        @Override
        public int getInt(Record rec) {
            long value = this.arg.getTimestamp(rec);
            if (value != Long.MIN_VALUE) {
                return Timestamps.getQuarter(value);
            }
            return Integer.MIN_VALUE;
        }
    }

    static final class MillisecondsFunction
    extends LongExtractFunction {
        public MillisecondsFunction(Function arg) {
            super(arg);
        }

        @Override
        public long getLong(Record rec) {
            long value = this.arg.getTimestamp(rec);
            if (value != Long.MIN_VALUE) {
                return Timestamps.getMillisOfMinute(value);
            }
            return Long.MIN_VALUE;
        }
    }

    static final class MillenniumFunction
    extends IntExtractFunction {
        public MillenniumFunction(Function arg) {
            super(arg);
        }

        @Override
        public int getInt(Record rec) {
            long value = this.arg.getTimestamp(rec);
            if (value != Long.MIN_VALUE) {
                return Timestamps.getMillennium(value);
            }
            return Integer.MIN_VALUE;
        }
    }

    static final class MicrosecondsFunction
    extends LongExtractFunction {
        public MicrosecondsFunction(Function arg) {
            super(arg);
        }

        @Override
        public long getLong(Record rec) {
            long value = this.arg.getTimestamp(rec);
            if (value != Long.MIN_VALUE) {
                return Timestamps.getMicrosOfMinute(value);
            }
            return Long.MIN_VALUE;
        }
    }

    static abstract class LongExtractFunction
    extends LongFunction
    implements UnaryFunction {
        protected final Function arg;

        LongExtractFunction(Function arg) {
            this.arg = arg;
        }

        @Override
        public Function getArg() {
            return this.arg;
        }

        @Override
        public String getName() {
            return "extract";
        }
    }

    static final class IsoYearFunction
    extends IntExtractFunction {
        public IsoYearFunction(Function arg) {
            super(arg);
        }

        @Override
        public int getInt(Record rec) {
            long value = this.arg.getTimestamp(rec);
            if (value != Long.MIN_VALUE) {
                return Timestamps.getIsoYear(value);
            }
            return Integer.MIN_VALUE;
        }
    }

    static final class IsoDowFunction
    extends IntExtractFunction {
        public IsoDowFunction(Function arg) {
            super(arg);
        }

        @Override
        public int getInt(Record rec) {
            long value = this.arg.getTimestamp(rec);
            if (value != Long.MIN_VALUE) {
                return Timestamps.getDayOfWeek(value);
            }
            return Integer.MIN_VALUE;
        }
    }

    static abstract class IntExtractFunction
    extends IntFunction
    implements UnaryFunction {
        protected final Function arg;

        IntExtractFunction(Function arg) {
            this.arg = arg;
        }

        @Override
        public Function getArg() {
            return this.arg;
        }

        @Override
        public String getName() {
            return "extract";
        }
    }

    static final class EpochFunction
    extends LongExtractFunction {
        public EpochFunction(Function arg) {
            super(arg);
        }

        @Override
        public long getLong(Record rec) {
            long value = this.arg.getTimestamp(rec);
            if (value != Long.MIN_VALUE) {
                return value / 1000000L;
            }
            return Long.MIN_VALUE;
        }
    }

    static final class DoyFunction
    extends IntExtractFunction {
        public DoyFunction(Function arg) {
            super(arg);
        }

        @Override
        public int getInt(Record rec) {
            long value = this.arg.getTimestamp(rec);
            if (value != Long.MIN_VALUE) {
                return Timestamps.getDoy(value);
            }
            return Integer.MIN_VALUE;
        }
    }

    static final class DowFunction
    extends IntExtractFunction {
        public DowFunction(Function arg) {
            super(arg);
        }

        @Override
        public int getInt(Record rec) {
            long value = this.arg.getTimestamp(rec);
            if (value != Long.MIN_VALUE) {
                return Timestamps.getDow(value);
            }
            return Integer.MIN_VALUE;
        }
    }

    static final class DecadeFunction
    extends IntExtractFunction {
        public DecadeFunction(Function arg) {
            super(arg);
        }

        @Override
        public int getInt(Record rec) {
            long value = this.arg.getTimestamp(rec);
            if (value != Long.MIN_VALUE) {
                return Timestamps.getDecade(value);
            }
            return Integer.MIN_VALUE;
        }
    }

    static final class CenturyFunction
    extends IntExtractFunction {
        public CenturyFunction(Function arg) {
            super(arg);
        }

        @Override
        public int getInt(Record rec) {
            long value = this.arg.getTimestamp(rec);
            if (value != Long.MIN_VALUE) {
                return Timestamps.getCentury(value);
            }
            return Integer.MIN_VALUE;
        }
    }
}

