/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cutlass.line.udp;

import io.questdb.cairo.CairoEngine;
import io.questdb.cutlass.line.udp.AbstractLineProtoUdpReceiver;
import io.questdb.cutlass.line.udp.LineUdpReceiverConfiguration;
import io.questdb.mp.WorkerPool;
import io.questdb.std.Unsafe;

public class LineUdpReceiver
extends AbstractLineProtoUdpReceiver {
    private final int bufLen;
    private long buf;

    public LineUdpReceiver(LineUdpReceiverConfiguration configuration, CairoEngine engine, WorkerPool workerPool) {
        super(configuration, engine, workerPool);
        this.bufLen = configuration.getMsgBufferSize();
        this.buf = Unsafe.malloc(this.bufLen, 46);
        this.start();
    }

    @Override
    public void close() {
        super.close();
        if (this.buf != 0L) {
            Unsafe.free(this.buf, this.bufLen, 46);
            this.buf = 0L;
        }
    }

    @Override
    protected boolean runSerially() {
        int count;
        boolean ran = false;
        while ((count = this.nf.recv(this.fd, this.buf, this.bufLen)) > 0) {
            this.lexer.parse(this.buf, this.buf + (long)count);
            this.lexer.parseLast();
            ++this.totalCount;
            if (this.totalCount > (long)this.commitRate) {
                this.totalCount = 0L;
                this.parser.commitAll(this.commitMode);
            }
            if (ran) continue;
            ran = true;
        }
        this.parser.commitAll(this.commitMode);
        return ran;
    }
}

