/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo.sql;

import io.questdb.cairo.CairoException;
import io.questdb.cairo.sql.SqlExecutionCircuitBreaker;
import io.questdb.cairo.sql.SqlExecutionCircuitBreakerConfiguration;
import io.questdb.network.NetworkFacade;
import io.questdb.std.Unsafe;
import io.questdb.std.datetime.millitime.MillisecondClock;
import java.io.Closeable;

public class NetworkSqlExecutionCircuitBreaker
implements SqlExecutionCircuitBreaker,
Closeable {
    private final int bufferSize;
    private final MillisecondClock clock;
    private final SqlExecutionCircuitBreakerConfiguration configuration;
    private final long defaultMaxTime;
    private final int memoryTag;
    private final NetworkFacade nf;
    private final int throttle;
    private long buffer;
    private int fd = -1;
    private long powerUpTime = Long.MAX_VALUE;
    private int testCount;
    private long timeout;

    public NetworkSqlExecutionCircuitBreaker(SqlExecutionCircuitBreakerConfiguration configuration, int memoryTag) {
        this.configuration = configuration;
        this.nf = configuration.getNetworkFacade();
        this.throttle = configuration.getCircuitBreakerThrottle();
        this.bufferSize = configuration.getBufferSize();
        this.memoryTag = memoryTag;
        this.buffer = Unsafe.malloc(this.bufferSize, this.memoryTag);
        this.clock = configuration.getClock();
        long timeout = configuration.getTimeout();
        this.timeout = timeout > 0L ? timeout : (timeout == Long.MIN_VALUE ? -1L : Long.MAX_VALUE);
        this.defaultMaxTime = this.timeout;
    }

    @Override
    public boolean checkIfTripped() {
        return this.checkIfTripped(this.powerUpTime, this.fd);
    }

    @Override
    public boolean checkIfTripped(long millis, int fd) {
        if (this.clock.getTicks() - this.timeout > millis) {
            return true;
        }
        return this.testConnection(fd);
    }

    @Override
    public void close() {
        this.buffer = Unsafe.free(this.buffer, this.bufferSize, this.memoryTag);
        this.fd = -1;
    }

    @Override
    public SqlExecutionCircuitBreakerConfiguration getConfiguration() {
        return this.configuration;
    }

    @Override
    public int getFd() {
        return this.fd;
    }

    @Override
    public boolean isTimerSet() {
        return this.powerUpTime < Long.MAX_VALUE;
    }

    public NetworkSqlExecutionCircuitBreaker of(int fd) {
        assert (this.buffer != 0L);
        this.testCount = 0;
        this.fd = fd;
        return this;
    }

    public void resetMaxTimeToDefault() {
        this.timeout = this.defaultMaxTime;
    }

    @Override
    public void resetTimer() {
        this.powerUpTime = this.clock.getTicks();
    }

    @Override
    public void setFd(int fd) {
        this.fd = fd;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    @Override
    public void statefulThrowExceptionIfTripped() {
        if (this.testCount < this.throttle) {
            ++this.testCount;
        } else {
            this.statefulThrowExceptionIfTrippedNoThrottle();
        }
    }

    @Override
    public void statefulThrowExceptionIfTrippedNoThrottle() {
        this.testCount = 0;
        this.testTimeout();
        if (this.testConnection(this.fd)) {
            throw CairoException.nonCritical().put("remote disconnected, query aborted [fd=").put(this.fd).put(']').setInterruption(true);
        }
    }

    @Override
    public void unsetTimer() {
        this.powerUpTime = Long.MAX_VALUE;
    }

    private void testTimeout() {
        if (this.clock.getTicks() - this.timeout > this.powerUpTime) {
            throw CairoException.nonCritical().put("timeout, query aborted [fd=").put(this.fd).put(']').setInterruption(true);
        }
    }

    protected boolean testConnection(int fd) {
        if (!this.configuration.checkConnection()) {
            return false;
        }
        return this.nf.testConnection(fd, this.buffer, this.bufferSize);
    }
}

