/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo;

import io.questdb.BuildInformation;
import io.questdb.BuildInformationHolder;
import io.questdb.DefaultTelemetryConfiguration;
import io.questdb.PropServerConfiguration;
import io.questdb.TelemetryConfiguration;
import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.SqlExecutionCircuitBreakerConfiguration;
import io.questdb.cutlass.text.DefaultTextConfiguration;
import io.questdb.cutlass.text.TextConfiguration;
import io.questdb.griffin.DefaultSqlExecutionCircuitBreakerConfiguration;
import io.questdb.std.Chars;
import io.questdb.std.Files;
import io.questdb.std.FilesFacade;
import io.questdb.std.FilesFacadeImpl;
import io.questdb.std.NanosecondClockImpl;
import io.questdb.std.Os;
import io.questdb.std.Rnd;
import io.questdb.std.datetime.DateFormat;
import io.questdb.std.datetime.DateLocale;
import io.questdb.std.datetime.microtime.MicrosecondClockImpl;
import io.questdb.std.datetime.millitime.DateFormatUtils;

public class DefaultCairoConfiguration
implements CairoConfiguration {
    private final BuildInformation buildInformation = new BuildInformationHolder();
    private final SqlExecutionCircuitBreakerConfiguration circuitBreakerConfiguration = new DefaultSqlExecutionCircuitBreakerConfiguration();
    private final CharSequence confRoot;
    private final long databaseIdHi;
    private final long databaseIdLo;
    private final CharSequence root;
    private final CharSequence snapshotRoot;
    private final DefaultTelemetryConfiguration telemetryConfiguration = new DefaultTelemetryConfiguration();
    private final TextConfiguration textConfiguration;

    public DefaultCairoConfiguration(CharSequence root) {
        this.root = Chars.toString(root);
        this.confRoot = PropServerConfiguration.rootSubdir(root, "conf");
        this.textConfiguration = new DefaultTextConfiguration(Chars.toString(this.confRoot));
        this.snapshotRoot = PropServerConfiguration.rootSubdir(root, "snapshot");
        Rnd rnd = new Rnd(NanosecondClockImpl.INSTANCE.getTicks(), MicrosecondClockImpl.INSTANCE.getTicks());
        this.databaseIdLo = rnd.nextLong();
        this.databaseIdHi = rnd.nextLong();
    }

    @Override
    public boolean attachPartitionCopy() {
        return false;
    }

    @Override
    public boolean enableTestFactories() {
        return true;
    }

    @Override
    public boolean getAllowTableRegistrySharedWrite() {
        return false;
    }

    @Override
    public int getAnalyticColumnPoolCapacity() {
        return 64;
    }

    @Override
    public String getAttachPartitionSuffix() {
        return ".attachable";
    }

    @Override
    public DateFormat getBackupDirTimestampFormat() {
        return null;
    }

    @Override
    public int getBackupMkDirMode() {
        return 509;
    }

    @Override
    public CharSequence getBackupRoot() {
        return null;
    }

    @Override
    public CharSequence getBackupTempDirName() {
        return "tmp";
    }

    @Override
    public int getBinaryEncodingMaxLength() {
        return 32768;
    }

    @Override
    public int getBindVariablePoolSize() {
        return 8;
    }

    @Override
    public BuildInformation getBuildInformation() {
        return this.buildInformation;
    }

    @Override
    public SqlExecutionCircuitBreakerConfiguration getCircuitBreakerConfiguration() {
        return this.circuitBreakerConfiguration;
    }

    @Override
    public int getColumnCastModelPoolCapacity() {
        return 32;
    }

    @Override
    public int getColumnIndexerQueueCapacity() {
        return 1024;
    }

    @Override
    public int getColumnPurgeQueueCapacity() {
        return 64;
    }

    @Override
    public long getColumnPurgeRetryDelay() {
        return 10000L;
    }

    @Override
    public long getColumnPurgeRetryDelayLimit() {
        return 60000000L;
    }

    @Override
    public double getColumnPurgeRetryDelayMultiplier() {
        return 2.0;
    }

    @Override
    public int getColumnPurgeTaskPoolCapacity() {
        return this.getColumnPurgeQueueCapacity();
    }

    @Override
    public int getCommitMode() {
        return 2;
    }

    @Override
    public CharSequence getConfRoot() {
        return this.confRoot;
    }

    @Override
    public int getCopyPoolCapacity() {
        return 16;
    }

    @Override
    public int getCreateAsSelectRetryCount() {
        return 5;
    }

    @Override
    public int getCreateTableModelPoolCapacity() {
        return 32;
    }

    @Override
    public long getDataAppendPageSize() {
        return 0x200000L;
    }

    @Override
    public long getDataIndexKeyAppendPageSize() {
        return Files.PAGE_SIZE;
    }

    @Override
    public long getDataIndexValueAppendPageSize() {
        return Files.ceilPageSize(0x100000L);
    }

    @Override
    public long getDatabaseIdHi() {
        return this.databaseIdHi;
    }

    @Override
    public long getDatabaseIdLo() {
        return this.databaseIdLo;
    }

    @Override
    public CharSequence getDbDirectory() {
        return "db";
    }

    @Override
    public DateLocale getDefaultDateLocale() {
        return DateFormatUtils.enLocale;
    }

    @Override
    public CharSequence getDefaultMapType() {
        return "fast";
    }

    @Override
    public boolean getDefaultSymbolCacheFlag() {
        return true;
    }

    @Override
    public int getDefaultSymbolCapacity() {
        return 128;
    }

    @Override
    public int getDoubleToStrCastScale() {
        return 19;
    }

    @Override
    public int getExplainPoolCapacity() {
        return 32;
    }

    @Override
    public int getFileOperationRetryCount() {
        return 30;
    }

    @Override
    public FilesFacade getFilesFacade() {
        return FilesFacadeImpl.INSTANCE;
    }

    @Override
    public int getFloatToStrCastScale() {
        return 4;
    }

    @Override
    public int getGroupByMapCapacity() {
        return 1024;
    }

    @Override
    public int getGroupByPoolCapacity() {
        return 1024;
    }

    @Override
    public long getIdleCheckInterval() {
        return 100L;
    }

    @Override
    public long getInactiveReaderTTL() {
        return -10000L;
    }

    @Override
    public long getInactiveWalWriterTTL() {
        return 60000L;
    }

    @Override
    public long getInactiveWriterTTL() {
        return -10000L;
    }

    @Override
    public int getIndexValueBlockSize() {
        return 256;
    }

    @Override
    public int getInsertPoolCapacity() {
        return 8;
    }

    @Override
    public int getLatestByQueueCapacity() {
        return 32;
    }

    @Override
    public int getMaxCrashFiles() {
        return 1;
    }

    @Override
    public int getMaxFileNameLength() {
        return 127;
    }

    @Override
    public int getMaxSwapFileCount() {
        return 30;
    }

    @Override
    public int getMaxSymbolNotEqualsCount() {
        return 100;
    }

    @Override
    public int getMaxUncommittedRows() {
        return 1000;
    }

    @Override
    public int getMetadataPoolCapacity() {
        return this.getSqlModelPoolCapacity();
    }

    @Override
    public long getMiscAppendPageSize() {
        return this.getFilesFacade().getPageSize();
    }

    @Override
    public int getMkDirMode() {
        return 509;
    }

    @Override
    public int getO3CallbackQueueCapacity() {
        return 1024;
    }

    @Override
    public int getO3ColumnMemorySize() {
        return 0x800000;
    }

    @Override
    public int getO3CopyQueueCapacity() {
        return 1024;
    }

    @Override
    public long getO3MaxLag() {
        return 300000000L;
    }

    @Override
    public long getO3MinLag() {
        return 1000000L;
    }

    @Override
    public int getO3OpenColumnQueueCapacity() {
        return 1024;
    }

    @Override
    public int getO3PartitionQueueCapacity() {
        return 1024;
    }

    @Override
    public int getO3PurgeDiscoveryQueueCapacity() {
        return 1024;
    }

    @Override
    public int getPageFrameReduceColumnListCapacity() {
        return 16;
    }

    @Override
    public int getPageFrameReduceQueueCapacity() {
        return 32;
    }

    @Override
    public int getPageFrameReduceRowIdListCapacity() {
        return 32;
    }

    @Override
    public int getPageFrameReduceShardCount() {
        return 4;
    }

    @Override
    public int getPageFrameReduceTaskPoolCapacity() {
        return 4;
    }

    @Override
    public int getParallelIndexThreshold() {
        return 100000;
    }

    @Override
    public int getPartitionPurgeListCapacity() {
        return 64;
    }

    @Override
    public int getQueryCacheEventQueueCapacity() {
        return 4;
    }

    @Override
    public int getReaderPoolMaxSegments() {
        return 5;
    }

    @Override
    public int getRenameTableModelPoolCapacity() {
        return 8;
    }

    @Override
    public int getRndFunctionMemoryMaxPages() {
        return 128;
    }

    @Override
    public int getRndFunctionMemoryPageSize() {
        return 8192;
    }

    @Override
    public CharSequence getRoot() {
        return this.root;
    }

    @Override
    public int getSampleByIndexSearchPageSize() {
        return 0;
    }

    @Override
    public boolean getSimulateCrashEnabled() {
        return false;
    }

    @Override
    public CharSequence getSnapshotInstanceId() {
        return "";
    }

    @Override
    public CharSequence getSnapshotRoot() {
        return this.snapshotRoot;
    }

    @Override
    public long getSpinLockTimeout() {
        return 5000L;
    }

    @Override
    public int getSqlAnalyticRowIdMaxPages() {
        return Integer.MAX_VALUE;
    }

    @Override
    public int getSqlAnalyticRowIdPageSize() {
        return 1024;
    }

    @Override
    public int getSqlAnalyticStoreMaxPages() {
        return Integer.MAX_VALUE;
    }

    @Override
    public int getSqlAnalyticStorePageSize() {
        return 0x100000;
    }

    @Override
    public int getSqlAnalyticTreeKeyMaxPages() {
        return Integer.MAX_VALUE;
    }

    @Override
    public int getSqlAnalyticTreeKeyPageSize() {
        return 4096;
    }

    @Override
    public int getSqlCharacterStoreCapacity() {
        return 64;
    }

    @Override
    public int getSqlCharacterStoreSequencePoolCapacity() {
        return 64;
    }

    @Override
    public int getSqlColumnPoolCapacity() {
        return 4096;
    }

    @Override
    public double getSqlCompactMapLoadFactor() {
        return 0.8;
    }

    @Override
    public int getSqlCopyBufferSize() {
        return 0x100000;
    }

    @Override
    public CharSequence getSqlCopyInputRoot() {
        return null;
    }

    @Override
    public CharSequence getSqlCopyInputWorkRoot() {
        return null;
    }

    @Override
    public int getSqlCopyLogRetentionDays() {
        return 3;
    }

    @Override
    public long getSqlCopyMaxIndexChunkSize() {
        return 0x100000L;
    }

    @Override
    public int getSqlCopyQueueCapacity() {
        return 32;
    }

    @Override
    public int getSqlDistinctTimestampKeyCapacity() {
        return 256;
    }

    @Override
    public double getSqlDistinctTimestampLoadFactor() {
        return 0.5;
    }

    @Override
    public int getSqlExpressionPoolCapacity() {
        return 8192;
    }

    @Override
    public double getSqlFastMapLoadFactor() {
        return 0.7;
    }

    @Override
    public int getSqlHashJoinLightValueMaxPages() {
        return 1024;
    }

    @Override
    public int getSqlHashJoinLightValuePageSize() {
        return 0x100000;
    }

    @Override
    public int getSqlHashJoinValueMaxPages() {
        return 1024;
    }

    @Override
    public int getSqlHashJoinValuePageSize() {
        return 0x1000000;
    }

    @Override
    public int getSqlJitBindVarsMemoryMaxPages() {
        return 8;
    }

    @Override
    public int getSqlJitBindVarsMemoryPageSize() {
        return 4096;
    }

    @Override
    public int getSqlJitIRMemoryMaxPages() {
        return 8;
    }

    @Override
    public int getSqlJitIRMemoryPageSize() {
        return 8192;
    }

    @Override
    public int getSqlJitMode() {
        return 0;
    }

    @Override
    public int getSqlJitPageAddressCacheThreshold() {
        return 0x100000;
    }

    @Override
    public int getSqlJitRowsThreshold() {
        return 0x100000;
    }

    @Override
    public int getSqlJoinContextPoolCapacity() {
        return 64;
    }

    @Override
    public int getSqlJoinMetadataMaxResizes() {
        return 10;
    }

    @Override
    public int getSqlJoinMetadataPageSize() {
        return 16384;
    }

    @Override
    public long getSqlLatestByRowCount() {
        return 1000L;
    }

    @Override
    public int getSqlLexerPoolCapacity() {
        return 2048;
    }

    @Override
    public int getSqlMapKeyCapacity() {
        return 128;
    }

    @Override
    public int getSqlMapMaxPages() {
        return 1024;
    }

    @Override
    public int getSqlMapMaxResizes() {
        return 64;
    }

    @Override
    public int getSqlMapPageSize() {
        return 0x1000000;
    }

    @Override
    public int getSqlMaxNegativeLimit() {
        return 10000;
    }

    @Override
    public int getSqlModelPoolCapacity() {
        return 1024;
    }

    @Override
    public int getSqlPageFrameMaxRows() {
        return 1000000;
    }

    @Override
    public int getSqlPageFrameMinRows() {
        return 1000;
    }

    @Override
    public int getSqlSmallMapKeyCapacity() {
        return 64;
    }

    @Override
    public int getSqlSmallMapPageSize() {
        return 4096;
    }

    @Override
    public int getSqlSortKeyMaxPages() {
        return 128;
    }

    @Override
    public long getSqlSortKeyPageSize() {
        return 0x400000L;
    }

    @Override
    public int getSqlSortLightValueMaxPages() {
        return 1024;
    }

    @Override
    public long getSqlSortLightValuePageSize() {
        return 0x800000L;
    }

    @Override
    public int getSqlSortValueMaxPages() {
        return 1024;
    }

    @Override
    public int getSqlSortValuePageSize() {
        return 0x1000000;
    }

    @Override
    public int getStrFunctionMaxBufferLength() {
        return 0x100000;
    }

    @Override
    public CharSequence getSystemTableNamePrefix() {
        return "__sys";
    }

    @Override
    public long getTableRegistryAutoReloadFrequency() {
        return 500L;
    }

    @Override
    public TelemetryConfiguration getTelemetryConfiguration() {
        return this.telemetryConfiguration;
    }

    @Override
    public TextConfiguration getTextConfiguration() {
        return this.textConfiguration;
    }

    @Override
    public int getTxnScoreboardEntryCount() {
        return 8192;
    }

    @Override
    public int getVectorAggregateQueueCapacity() {
        return 1024;
    }

    @Override
    public boolean getWalEnabledDefault() {
        return false;
    }

    @Override
    public long getWalPurgeInterval() {
        return 30000L;
    }

    @Override
    public int getWalRecreateDistressedSequencerAttempts() {
        return 3;
    }

    @Override
    public long getWalSegmentRolloverRowCount() {
        return 200000L;
    }

    @Override
    public int getWalTxnNotificationQueueCapacity() {
        return 4096;
    }

    @Override
    public int getWithClauseModelPoolCapacity() {
        return 128;
    }

    @Override
    public long getWorkStealTimeoutNanos() {
        return 10000L;
    }

    @Override
    public long getWriterAsyncCommandBusyWaitTimeout() {
        return 500L;
    }

    @Override
    public long getWriterAsyncCommandMaxTimeout() {
        return 30000L;
    }

    @Override
    public int getWriterCommandQueueCapacity() {
        return 4;
    }

    @Override
    public long getWriterCommandQueueSlotSize() {
        return 1024L;
    }

    @Override
    public long getWriterFileOpenOpts() {
        return Os.type != 3 ? 64L : 0L;
    }

    @Override
    public int getWriterTickRowsCountMod() {
        return 1023;
    }

    @Override
    public boolean isIOURingEnabled() {
        return true;
    }

    @Override
    public boolean isO3QuickSortEnabled() {
        return false;
    }

    @Override
    public boolean isParallelIndexingEnabled() {
        return true;
    }

    @Override
    public boolean isReadOnlyInstance() {
        return false;
    }

    @Override
    public boolean isSnapshotRecoveryEnabled() {
        return true;
    }

    @Override
    public boolean isSqlJitDebugEnabled() {
        return false;
    }

    @Override
    public boolean isSqlParallelFilterEnabled() {
        return true;
    }

    @Override
    public boolean isSqlParallelFilterPreTouchEnabled() {
        return true;
    }

    @Override
    public boolean isWalSupported() {
        return false;
    }

    @Override
    public boolean mangleTableDirNames() {
        return false;
    }
}

