/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.CairoEngine;
import io.questdb.cairo.ColumnPurgeOperator;
import io.questdb.cairo.TableToken;
import io.questdb.cairo.TableWriter;
import io.questdb.cairo.security.AllowAllCairoSecurityContext;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.cairo.sql.RecordCursorFactory;
import io.questdb.griffin.CompiledQuery;
import io.questdb.griffin.FunctionFactoryCache;
import io.questdb.griffin.SqlCompiler;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContextImpl;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.mp.RingQueue;
import io.questdb.mp.Sequence;
import io.questdb.mp.SynchronizedJob;
import io.questdb.std.CharSequenceObjHashMap;
import io.questdb.std.Chars;
import io.questdb.std.LongList;
import io.questdb.std.Misc;
import io.questdb.std.Mutable;
import io.questdb.std.Os;
import io.questdb.std.Rows;
import io.questdb.std.WeakMutableObjectPool;
import io.questdb.std.datetime.microtime.MicrosecondClock;
import io.questdb.tasks.ColumnPurgeTask;
import java.io.Closeable;
import java.util.PriorityQueue;
import org.jetbrains.annotations.Nullable;

public class ColumnPurgeJob
extends SynchronizedJob
implements Closeable {
    private static final int COLUMN_NAME_COLUMN = 2;
    private static final int COLUMN_TYPE_COLUMN = 5;
    private static final int COLUMN_VERSION_COLUMN = 8;
    private static final Log LOG = LogFactory.getLog(ColumnPurgeJob.class);
    private static final int MAX_ERRORS = 11;
    private static final int PARTITION_BY_COLUMN = 6;
    private static final int PARTITION_NAME_COLUMN = 10;
    private static final int PARTITION_TIMESTAMP_COLUMN = 9;
    private static final int TABLE_ID_COLUMN = 3;
    private static final int TABLE_NAME_COLUMN = 1;
    private static final int TABLE_TRUNCATE_VERSION = 4;
    private static final int UPDATE_TXN_COLUMN = 7;
    private final MicrosecondClock clock;
    private final RingQueue<ColumnPurgeTask> inQueue;
    private final Sequence inSubSequence;
    private final long retryDelay;
    private final long retryDelayLimit;
    private final double retryDelayMultiplier;
    private final PriorityQueue<ColumnPurgeRetryTask> retryQueue;
    private final TableToken tableToken;
    private ColumnPurgeOperator columnPurgeOperator;
    private int inErrorCount;
    private SqlCompiler sqlCompiler;
    private SqlExecutionContextImpl sqlExecutionContext;
    private WeakMutableObjectPool<ColumnPurgeRetryTask> taskPool;
    private TableWriter writer;

    public ColumnPurgeJob(CairoEngine engine, @Nullable FunctionFactoryCache functionFactoryCache) throws SqlException {
        CairoConfiguration configuration = engine.getConfiguration();
        this.clock = configuration.getMicrosecondClock();
        this.inQueue = engine.getMessageBus().getColumnPurgeQueue();
        this.inSubSequence = engine.getMessageBus().getColumnPurgeSubSeq();
        String tableName = configuration.getSystemTableNamePrefix() + "column_versions_purge_log";
        this.taskPool = new WeakMutableObjectPool<ColumnPurgeRetryTask>(ColumnPurgeRetryTask::new, configuration.getColumnPurgeTaskPoolCapacity());
        this.retryQueue = new PriorityQueue(configuration.getColumnPurgeQueueCapacity(), ColumnPurgeJob::compareRetryTasks);
        this.retryDelayLimit = configuration.getColumnPurgeRetryDelayLimit();
        this.retryDelay = configuration.getColumnPurgeRetryDelay();
        this.retryDelayMultiplier = configuration.getColumnPurgeRetryDelayMultiplier();
        this.sqlCompiler = new SqlCompiler(engine, functionFactoryCache, null);
        this.sqlExecutionContext = new SqlExecutionContextImpl(engine, 1);
        this.sqlExecutionContext.with(AllowAllCairoSecurityContext.INSTANCE, null, null);
        this.sqlCompiler.compile("CREATE TABLE IF NOT EXISTS \"" + tableName + "\" (ts timestamp, table_name symbol, column_name symbol, table_id int, truncate_version long, columnType int, table_partition_by int, updated_txn long, column_version long, partition_timestamp timestamp, partition_name_txn long,completed timestamp) timestamp(ts) partition by MONTH", this.sqlExecutionContext);
        this.tableToken = engine.getTableToken(tableName);
        this.writer = engine.getWriter(AllowAllCairoSecurityContext.INSTANCE, this.tableToken, "QuestDB system");
        this.columnPurgeOperator = new ColumnPurgeOperator(configuration, this.writer, "completed");
        this.processTableRecords(engine);
    }

    @Override
    public void close() {
        this.writer = Misc.free(this.writer);
        this.sqlCompiler = Misc.free(this.sqlCompiler);
        this.sqlExecutionContext = Misc.free(this.sqlExecutionContext);
        this.columnPurgeOperator = Misc.free(this.columnPurgeOperator);
        this.taskPool = Misc.free(this.taskPool);
    }

    public String getLogTableName() {
        return this.tableToken.getTableName();
    }

    public int getOutstandingPurgeTasks() {
        return this.retryQueue.size();
    }

    private static int compareRetryTasks(ColumnPurgeRetryTask task1, ColumnPurgeRetryTask task2) {
        return Long.compare(task1.nextRunTimestamp, task2.nextRunTimestamp);
    }

    private void calculateNextTimestamp(ColumnPurgeRetryTask task, long currentTime) {
        task.retryDelay = Math.min(this.retryDelayLimit, (long)((double)task.retryDelay * this.retryDelayMultiplier));
        task.nextRunTimestamp = currentTime + task.retryDelay;
    }

    private void commit() {
        try {
            if (this.writer != null) {
                this.writer.commit();
            }
        }
        catch (Throwable th) {
            LOG.error().$("error saving to column version house keeping log, cannot commit").$(", releasing writer and stop updating log [table=").$(this.tableToken).$(", error=").$(th).I$();
            this.writer = Misc.free(this.writer);
        }
    }

    private String internStrObj(CharSequenceObjHashMap<String> stringIntern, CharSequence sym) {
        String val = stringIntern.get(sym);
        if (val != null) {
            return val;
        }
        val = Chars.toString(sym);
        stringIntern.put(val, val);
        return val;
    }

    private boolean processInQueue() {
        boolean useful = false;
        long microTime = this.clock.getTicks();
        while (true) {
            long cursor;
            if ((cursor = this.inSubSequence.next()) < -1L) {
                Os.pause();
                continue;
            }
            if (cursor < 0L) break;
            ColumnPurgeTask queueTask = this.inQueue.get(cursor);
            ColumnPurgeRetryTask purgeTaskRun = (ColumnPurgeRetryTask)this.taskPool.pop();
            purgeTaskRun.copyFrom(queueTask, this.retryDelay, microTime + this.retryDelay);
            ++microTime;
            purgeTaskRun.timestamp = purgeTaskRun.timestamp;
            this.inSubSequence.done(cursor);
            this.saveToStorage(purgeTaskRun);
            this.retryQueue.add(purgeTaskRun);
            useful = true;
        }
        if (useful) {
            this.commit();
        }
        return useful;
    }

    private void processTableRecords(CairoEngine engine) {
        try {
            CompiledQuery reloadQuery = this.sqlCompiler.compile("SELECT * FROM \"" + this.tableToken.getTableName() + "\" WHERE completed = null", this.sqlExecutionContext);
            long microTime = this.clock.getTicks();
            try (RecordCursorFactory recordCursorFactory = reloadQuery.getRecordCursorFactory();){
                assert (recordCursorFactory.supportsUpdateRowId(this.tableToken));
                int count = 0;
                try (RecordCursor records = recordCursorFactory.getCursor(this.sqlExecutionContext);){
                    Record rec = records.getRecord();
                    long lastTs = 0L;
                    ColumnPurgeRetryTask taskRun = null;
                    CharSequenceObjHashMap<String> stringIntern = new CharSequenceObjHashMap<String>();
                    while (records.hasNext()) {
                        ++count;
                        long ts = rec.getTimestamp(0);
                        if (ts != lastTs || taskRun == null) {
                            if (taskRun != null) {
                                this.columnPurgeOperator.purgeExclusive(taskRun);
                            } else {
                                taskRun = (ColumnPurgeRetryTask)this.taskPool.pop();
                            }
                            lastTs = ts;
                            String tableName = this.internStrObj(stringIntern, rec.getSym(1));
                            String columnName = this.internStrObj(stringIntern, rec.getSym(2));
                            int tableId = rec.getInt(3);
                            long truncateVersion = rec.getLong(4);
                            int columnType = rec.getInt(5);
                            int partitionBY = rec.getInt(6);
                            long updateTxn = rec.getLong(7);
                            TableToken token = engine.getTableTokenByDirName(tableName, tableId);
                            if (token == null) {
                                LOG.debug().$("table deleted, skipping [tableDir=").utf8(tableName).I$();
                                continue;
                            }
                            taskRun.of(token, columnName, tableId, truncateVersion, columnType, partitionBY, updateTxn, this.retryDelay, microTime);
                        }
                        long columnVersion = rec.getLong(8);
                        long partitionTs = rec.getLong(9);
                        long partitionNameTxn = rec.getLong(10);
                        taskRun.appendColumnInfo(columnVersion, partitionTs, partitionNameTxn, rec.getUpdateRowId());
                    }
                    if (taskRun != null) {
                        this.columnPurgeOperator.purgeExclusive(taskRun);
                        this.taskPool.push(taskRun);
                    }
                }
                if (count > 0) {
                    LOG.info().$("cleaned up rewritten column files [cleanCount=").$(count).I$();
                }
            }
            if (this.writer != null) {
                try {
                    this.writer.truncate();
                }
                catch (Throwable th) {
                    LOG.error().$("failed to truncate column version purge log table").$(th).$();
                }
            }
        }
        catch (SqlException e) {
            LOG.error().$("failed to reload column version purge tasks").$(e).$();
        }
    }

    private boolean purge() {
        boolean useful = false;
        long now = this.clock.getTicks() + 1L;
        while (this.retryQueue.size() > 0) {
            ColumnPurgeRetryTask nextTask = this.retryQueue.peek();
            if (nextTask.nextRunTimestamp < now) {
                this.retryQueue.poll();
                useful = true;
                if (!this.columnPurgeOperator.purge(nextTask)) {
                    this.calculateNextTimestamp(nextTask, now);
                    this.retryQueue.add(nextTask);
                    continue;
                }
                this.taskPool.push(nextTask);
                continue;
            }
            return useful;
        }
        return useful;
    }

    private void saveToStorage(ColumnPurgeRetryTask cleanTask) {
        if (this.writer != null) {
            try {
                LongList updatedColumnInfo = cleanTask.getUpdatedColumnInfo();
                int n = updatedColumnInfo.size();
                for (int i = 0; i < n; i += 4) {
                    TableWriter.Row row = this.writer.newRow(cleanTask.timestamp);
                    row.putSym(1, cleanTask.getTableName().getDirName());
                    row.putSym(2, cleanTask.getColumnName());
                    row.putInt(3, cleanTask.getTableId());
                    row.putLong(4, cleanTask.getTruncateVersion());
                    row.putInt(5, cleanTask.getColumnType());
                    row.putInt(6, cleanTask.getPartitionBy());
                    row.putLong(7, cleanTask.getUpdateTxn());
                    row.putLong(8, updatedColumnInfo.getQuick(i + 0));
                    row.putTimestamp(9, updatedColumnInfo.getQuick(i + 1));
                    row.putLong(10, updatedColumnInfo.getQuick(i + 2));
                    row.append();
                    updatedColumnInfo.setQuick(i + 3, Rows.toRowID(this.writer.getPartitionCount() - 1, this.writer.getTransientRowCount() - 1L));
                }
            }
            catch (Throwable th) {
                LOG.error().$("error saving to column version house keeping log, unable to insert").$(", releasing writer and stop updating log [table=").$(this.tableToken).$(", error=").$(th).I$();
                this.writer = Misc.free(this.writer);
            }
        }
    }

    @Override
    protected boolean runSerially() {
        if (this.inErrorCount >= 11) {
            return false;
        }
        try {
            boolean useful = this.processInQueue();
            boolean cleanupUseful = this.purge();
            if (cleanupUseful) {
                LOG.debug().$("cleaned column version, outstanding tasks: ").$(this.retryQueue.size()).$();
            }
            this.inErrorCount = 0;
            return cleanupUseful || useful;
        }
        catch (Throwable th) {
            LOG.error().$("failed to clean up column versions").$(th).$();
            ++this.inErrorCount;
            if (this.inErrorCount == 11) {
                if (this.retryQueue.size() > 0) {
                    LOG.error().$("clean up column versions reached maximum error count and will be recycled. Some column version may be left behind.").$(th).$();
                    this.retryQueue.clear();
                    this.inErrorCount = 0;
                } else {
                    LOG.error().$("clean up column versions reached maximum error count and will be DISABLED. Restart QuestDB to re-enable the job.").$(th).$();
                    this.close();
                }
            }
            return false;
        }
    }

    static class ColumnPurgeRetryTask
    extends ColumnPurgeTask
    implements Mutable {
        public long nextRunTimestamp;
        public long retryDelay;
        public long timestamp;

        ColumnPurgeRetryTask() {
        }

        public void copyFrom(ColumnPurgeTask inTask, long retryDelay, long nextRunTimestamp) {
            this.retryDelay = retryDelay;
            this.nextRunTimestamp = nextRunTimestamp;
            super.copyFrom(inTask);
        }

        public void of(TableToken tableName, CharSequence columnName, int tableId, long truncateVersion, int columnType, int partitionBy, long updateTxn, long retryDelay, long microTime) {
            super.of(tableName, columnName, tableId, truncateVersion, columnType, partitionBy, updateTxn);
            this.retryDelay = retryDelay;
            this.nextRunTimestamp = microTime;
        }
    }
}

