/*
 * Decompiled with CFR 0.152.
 */
package com.azure.security.keyvault.keys.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.annotation.UnexpectedResponseExceptionTypes;
import com.azure.core.exception.HttpResponseException;
import com.azure.core.exception.ResourceModifiedException;
import com.azure.core.exception.ResourceNotFoundException;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.Context;
import com.azure.core.util.serializer.JacksonAdapter;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.security.keyvault.keys.implementation.models.SecretKey;
import com.azure.security.keyvault.keys.implementation.models.SecretRequestAttributes;
import com.azure.security.keyvault.keys.implementation.models.SecretRequestParameters;
import java.util.Map;
import reactor.core.publisher.Mono;

public final class SecretMinClientImpl {
    private final SecretMinClientService service;
    private final String apiVersion;
    private final HttpPipeline httpPipeline;
    private final SerializerAdapter serializerAdapter;

    public String getApiVersion() {
        return this.apiVersion;
    }

    public HttpPipeline getHttpPipeline() {
        return this.httpPipeline;
    }

    public SerializerAdapter getSerializerAdapter() {
        return this.serializerAdapter;
    }

    public SecretMinClientImpl(HttpPipeline httpPipeline, String apiVersion) {
        this.httpPipeline = httpPipeline;
        this.serializerAdapter = JacksonAdapter.createDefaultSerializerAdapter();
        this.apiVersion = apiVersion;
        this.service = (SecretMinClientService)RestProxy.create(SecretMinClientService.class, (HttpPipeline)this.httpPipeline, (SerializerAdapter)this.getSerializerAdapter());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<SecretKey>> getSecretWithResponseAsync(String vaultBaseUrl, String secretName, String secretVersion, Context context) {
        String accept = "application/json";
        return this.service.getSecret(vaultBaseUrl, secretName, secretVersion, this.getApiVersion(), "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<SecretKey> getSecretWithResponse(String vaultBaseUrl, String secretName, String secretVersion, Context context) {
        String accept = "application/json";
        return this.service.getSecretSync(vaultBaseUrl, secretName, secretVersion, this.getApiVersion(), "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<SecretKey> setSecretWithResponse(String vaultBaseUrl, String secretName, String value, Map<String, String> tags, String contentType, SecretRequestAttributes secretAttributes, Context context) {
        String accept = "application/json";
        SecretRequestParameters parameters = new SecretRequestParameters();
        parameters.setValue(value);
        parameters.setTags(tags);
        parameters.setContentType(contentType);
        parameters.setSecretAttributes(secretAttributes);
        return this.service.setSecretSync(vaultBaseUrl, secretName, this.getApiVersion(), parameters, "application/json", contentType, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<SecretKey>> setSecretWithResponseAsync(String vaultBaseUrl, String secretName, String value, Map<String, String> tags, String contentType, SecretRequestAttributes secretAttributes, Context context) {
        String accept = "application/json";
        SecretRequestParameters parameters = new SecretRequestParameters();
        parameters.setValue(value);
        parameters.setTags(tags);
        parameters.setContentType(contentType);
        parameters.setSecretAttributes(secretAttributes);
        return this.service.setSecret(vaultBaseUrl, secretName, this.getApiVersion(), parameters, "application/json", contentType, context);
    }

    @Host(value="{vaultBaseUrl}")
    @ServiceInterface(name="SecretMinClient")
    public static interface SecretMinClientService {
        @Get(value="secrets/{secret-name}/{secret-version}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(code={404}, value=ResourceNotFoundException.class), @UnexpectedResponseExceptionType(code={403}, value=ResourceModifiedException.class), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<SecretKey>> getSecret(@HostParam(value="vaultBaseUrl") String var1, @PathParam(value="secret-name") String var2, @PathParam(value="secret-version") String var3, @QueryParam(value="api-version") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Get(value="secrets/{secret-name}/{secret-version}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(code={404}, value=ResourceNotFoundException.class), @UnexpectedResponseExceptionType(code={403}, value=ResourceModifiedException.class), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<SecretKey> getSecretSync(@HostParam(value="vaultBaseUrl") String var1, @PathParam(value="secret-name") String var2, @PathParam(value="secret-version") String var3, @QueryParam(value="api-version") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Put(value="secrets/{secret-name}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(code={400}, value=ResourceModifiedException.class), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<SecretKey>> setSecret(@HostParam(value="vaultBaseUrl") String var1, @PathParam(value="secret-name") String var2, @QueryParam(value="api-version") String var3, @BodyParam(value="application/json") SecretRequestParameters var4, @HeaderParam(value="Accept") String var5, @HeaderParam(value="Content-Type") String var6, Context var7);

        @Put(value="secrets/{secret-name}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(code={400}, value=ResourceModifiedException.class), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<SecretKey> setSecretSync(@HostParam(value="vaultBaseUrl") String var1, @PathParam(value="secret-name") String var2, @QueryParam(value="api-version") String var3, @BodyParam(value="application/json") SecretRequestParameters var4, @HeaderParam(value="Accept") String var5, @HeaderParam(value="Content-Type") String var6, Context var7);
    }
}

