/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.kafkamigrator;

import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.nifi.toolkit.kafkamigrator.MigratorConfiguration;
import org.apache.nifi.toolkit.kafkamigrator.service.KafkaFlowMigrationService;
import org.apache.nifi.toolkit.kafkamigrator.service.KafkaTemplateMigrationService;
import org.apache.nifi.xml.processing.parsers.StandardDocumentProvider;
import org.apache.nifi.xml.processing.transform.StandardTransformProvider;
import org.w3c.dom.Document;

public class KafkaMigratorMain {
    private static void printUsage() {
        System.out.println("This application replaces Kafka processors from version 0.8, 0.9, 0.10 and 0.11 to version 2.0 processors in a flow.xml.gz file.");
        System.out.println("\n");
        System.out.println("Usage: kafka-migrator.sh -i <path to input flow.xml.gz> -o <path to output flow.xml.gz> -t <use transaction true or false>\noptional: -k <comma separated kafka brokers in <host>:<port> format. Required for version 0.8 processors only>");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        if (KafkaMigratorMain.showingUsageNeeded(args)) {
            KafkaMigratorMain.printUsage();
            return;
        }
        String input = "";
        if (args[0].equalsIgnoreCase("-i")) {
            input = args[1];
        }
        String output = "";
        if (args[2].equalsIgnoreCase("-o")) {
            output = args[3];
        }
        if (input.equalsIgnoreCase(output)) {
            System.out.println("Input and output files should be different.");
            return;
        }
        String transaction = "";
        if (args[4].equalsIgnoreCase("-t")) {
            transaction = args[5];
        }
        if (!transaction.equalsIgnoreCase("true") && !transaction.equalsIgnoreCase("false")) {
            System.out.println("Transaction argument should be either true or false.");
            return;
        }
        String kafkaBrokers = "";
        if (args.length == 8) {
            if (args[6].equalsIgnoreCase("-k") && args[7].matches(".+:\\d+")) {
                kafkaBrokers = args[7];
            } else {
                System.out.println("Kafka Brokers must be in a <host>:<port> format, can be separated by comma. For example: hostname:1234, host:5678");
                return;
            }
        }
        MigratorConfiguration.MigratorConfigurationBuilder configurationBuilder = new MigratorConfiguration.MigratorConfigurationBuilder();
        configurationBuilder.setKafkaBrokers(kafkaBrokers).setTransaction(Boolean.parseBoolean(transaction));
        InputStream fileStream = Files.newInputStream(Paths.get(input, new String[0]), new OpenOption[0]);
        OutputStream outputStream = Files.newOutputStream(Paths.get(output, new String[0]), new OpenOption[0]);
        GZIPInputStream gzipStream = new GZIPInputStream(fileStream);
        GZIPOutputStream gzipOutStream = new GZIPOutputStream(outputStream);
        System.out.println("Using flow=" + input);
        try {
            StandardDocumentProvider documentProvider = new StandardDocumentProvider();
            Document document = documentProvider.parse((InputStream)gzipStream);
            KafkaFlowMigrationService flowMigrationService = new KafkaFlowMigrationService();
            KafkaTemplateMigrationService templateMigrationService = new KafkaTemplateMigrationService();
            System.out.println("Replacing processors.");
            flowMigrationService.replaceKafkaProcessors(document, configurationBuilder);
            templateMigrationService.replaceKafkaProcessors(document, configurationBuilder);
            StreamResult streamResult = new StreamResult(gzipOutStream);
            StandardTransformProvider transformProvider = new StandardTransformProvider();
            transformProvider.setIndent(true);
            transformProvider.transform((Source)new DOMSource(document), (Result)streamResult);
            System.out.println("Replacing completed.");
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("Exception occurred while attempting to parse flow.xml.gz.  Cause: " + e.getCause());
        }
        finally {
            ((OutputStream)gzipOutStream).close();
            outputStream.close();
            ((InputStream)gzipStream).close();
            fileStream.close();
        }
    }

    private static boolean showingUsageNeeded(String[] args) {
        return args.length < 6 || args[0].equalsIgnoreCase("-h") || args[0].equalsIgnoreCase("--help");
    }
}

