/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.cli.impl.result.nifi;

import java.io.PrintStream;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.nifi.toolkit.cli.api.ResultType;
import org.apache.nifi.toolkit.cli.impl.result.AbstractWritableResult;
import org.apache.nifi.toolkit.cli.impl.result.writer.DynamicTableWriter;
import org.apache.nifi.toolkit.cli.impl.result.writer.Table;
import org.apache.nifi.web.api.dto.VariableDTO;
import org.apache.nifi.web.api.dto.VariableRegistryDTO;
import org.apache.nifi.web.api.entity.VariableRegistryEntity;

public class VariableRegistryResult
extends AbstractWritableResult<VariableRegistryEntity> {
    final VariableRegistryEntity variableRegistryEntity;

    public VariableRegistryResult(ResultType resultType, VariableRegistryEntity variableRegistryEntity) {
        super(resultType);
        this.variableRegistryEntity = Objects.requireNonNull(variableRegistryEntity);
    }

    @Override
    public VariableRegistryEntity getResult() {
        return this.variableRegistryEntity;
    }

    @Override
    protected void writeSimpleResult(PrintStream output) {
        VariableRegistryDTO variableRegistryDTO = this.variableRegistryEntity.getVariableRegistry();
        if (variableRegistryDTO == null || variableRegistryDTO.getVariables() == null) {
            return;
        }
        List variables = variableRegistryDTO.getVariables().stream().map(v -> v.getVariable()).collect(Collectors.toList());
        Collections.sort(variables, Comparator.comparing(VariableDTO::getName));
        Table table = new Table.Builder().column("#", 3, 3, false).column("Name", 5, 40, false).column("Value", 5, 40, false).build();
        for (int i = 0; i < variables.size(); ++i) {
            VariableDTO var = (VariableDTO)variables.get(i);
            table.addRow(String.valueOf(i + 1), var.getName(), var.getValue());
        }
        DynamicTableWriter tableWriter = new DynamicTableWriter();
        tableWriter.write(table, output);
    }
}

