/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.cli.impl.command.nifi.pg;

import java.io.IOException;
import java.util.Properties;
import org.apache.commons.cli.MissingOptionException;
import org.apache.nifi.toolkit.cli.api.Context;
import org.apache.nifi.toolkit.cli.impl.client.nifi.FlowClient;
import org.apache.nifi.toolkit.cli.impl.client.nifi.NiFiClient;
import org.apache.nifi.toolkit.cli.impl.client.nifi.NiFiClientException;
import org.apache.nifi.toolkit.cli.impl.command.CommandOption;
import org.apache.nifi.toolkit.cli.impl.command.nifi.AbstractNiFiCommand;
import org.apache.nifi.toolkit.cli.impl.result.VoidResult;
import org.apache.nifi.web.api.entity.ScheduleComponentsEntity;

public class PGStop
extends AbstractNiFiCommand<VoidResult> {
    public PGStop() {
        super("pg-stop", VoidResult.class);
    }

    @Override
    public String getDescription() {
        return "Stops the given process group which stops any running components in the given group.";
    }

    @Override
    protected void doInitialize(Context context) {
        this.addOption(CommandOption.PG_ID.createOption());
    }

    @Override
    public VoidResult doExecute(NiFiClient client, Properties properties) throws NiFiClientException, IOException, MissingOptionException {
        String pgId = this.getRequiredArg(properties, CommandOption.PG_ID);
        ScheduleComponentsEntity entity = new ScheduleComponentsEntity();
        entity.setId(pgId);
        entity.setState("STOPPED");
        FlowClient flowClient = client.getFlowClient();
        ScheduleComponentsEntity resultEntity = flowClient.scheduleProcessGroupComponents(pgId, entity);
        return VoidResult.getInstance();
    }
}

