/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.cli.impl.command.nifi.pg;

import java.io.IOException;
import java.util.Properties;
import org.apache.commons.cli.MissingOptionException;
import org.apache.nifi.toolkit.cli.api.CommandException;
import org.apache.nifi.toolkit.cli.api.Context;
import org.apache.nifi.toolkit.cli.impl.client.nifi.FlowClient;
import org.apache.nifi.toolkit.cli.impl.client.nifi.NiFiClient;
import org.apache.nifi.toolkit.cli.impl.client.nifi.NiFiClientException;
import org.apache.nifi.toolkit.cli.impl.command.CommandOption;
import org.apache.nifi.toolkit.cli.impl.command.nifi.AbstractNiFiCommand;
import org.apache.nifi.toolkit.cli.impl.command.nifi.pg.cs.ControllerServiceStateCounts;
import org.apache.nifi.toolkit.cli.impl.command.nifi.pg.cs.ControllerServiceUtil;
import org.apache.nifi.toolkit.cli.impl.result.VoidResult;
import org.apache.nifi.web.api.dto.ControllerServiceDTO;
import org.apache.nifi.web.api.entity.ActivateControllerServicesEntity;
import org.apache.nifi.web.api.entity.BulletinEntity;
import org.apache.nifi.web.api.entity.ControllerServiceEntity;
import org.apache.nifi.web.api.entity.ControllerServicesEntity;

public class PGEnableControllerServices
extends AbstractNiFiCommand<VoidResult> {
    public static final int MAX_ATTEMPTS = 180;
    public static final int MAX_ENABLING_ITERATIONS = 20;
    public static final long ENABLING_DELAY_MS = 2000L;

    public PGEnableControllerServices() {
        super("pg-enable-services", VoidResult.class);
    }

    @Override
    public String getDescription() {
        return "Attempts to enable all controller services in the given PG. In stand-alone mode this command will not produce all of the output seen in interactive mode unless the --verbose argument is specified.";
    }

    @Override
    protected void doInitialize(Context context) {
        this.addOption(CommandOption.PG_ID.createOption());
    }

    @Override
    public VoidResult doExecute(NiFiClient client, Properties properties) throws NiFiClientException, IOException, MissingOptionException, CommandException {
        String pgId = this.getRequiredArg(properties, CommandOption.PG_ID);
        FlowClient flowClient = client.getFlowClient();
        if (this.shouldPrint(properties)) {
            this.println();
        }
        int count = 0;
        int prevNumEnabled = -1;
        int enablingIterations = 1;
        while (count < 180) {
            ControllerServiceStateCounts states = this.getControllerServiceStates(flowClient, pgId);
            if (states.getEnabling() > 0) {
                if (enablingIterations < 20) {
                    if (this.shouldPrint(properties)) {
                        this.println("Currently " + states.getEnabling() + " services are enabling, waiting to finish before proceeding (" + enablingIterations + " of " + 20 + ")");
                    }
                    try {
                        Thread.sleep(2000L);
                    }
                    catch (InterruptedException e) {
                        Thread.interrupted();
                    }
                    ++enablingIterations;
                    continue;
                }
                if (this.shouldPrint(properties)) {
                    this.printServicesStillEnabling(flowClient, pgId);
                }
                throw new CommandException("One or more services are stuck enabling, run command with -verbose to obtain more details");
            }
            enablingIterations = 1;
            if (states.getEnabled() == prevNumEnabled && states.getEnabling() == 0) {
                if (this.shouldPrint(properties)) {
                    this.println();
                    this.println("Finished with " + states.getEnabled() + " enabled services and " + states.getDisabled() + " disabled services");
                }
                if (states.getDisabled() > 0 || states.getDisabling() > 0) {
                    if (this.shouldPrint(properties)) {
                        this.printServicesNotEnabled(flowClient, pgId);
                        this.println();
                    }
                    throw new CommandException("One or more services could not be enabled, run command with -verbose to obtain more details");
                }
                if (!this.shouldPrint(properties)) break;
                this.println();
                break;
            }
            prevNumEnabled = states.getEnabled();
            if (this.shouldPrint(properties)) {
                this.println("Currently " + states.getEnabled() + " enabled services and " + states.getDisabled() + " disabled services, attempting to enable services...");
            }
            ActivateControllerServicesEntity enableEntity = new ActivateControllerServicesEntity();
            enableEntity.setId(pgId);
            enableEntity.setState("ENABLED");
            flowClient.activateControllerServices(enableEntity);
            ++count;
        }
        return VoidResult.getInstance();
    }

    private boolean shouldPrint(Properties properties) {
        return this.isInteractive() || this.isVerbose(properties);
    }

    private ControllerServiceStateCounts getControllerServiceStates(FlowClient flowClient, String pgId) throws NiFiClientException, IOException {
        return ControllerServiceUtil.getControllerServiceStates(flowClient, pgId);
    }

    private void printServicesStillEnabling(FlowClient flowClient, String pgId) throws NiFiClientException, IOException {
        ControllerServicesEntity servicesEntity = flowClient.getControllerServices(pgId);
        if (servicesEntity == null || servicesEntity.getControllerServices() == null) {
            return;
        }
        this.println();
        this.println("One or more services appear to be stuck enabling: ");
        for (ControllerServiceEntity serviceEntity : servicesEntity.getControllerServices()) {
            if (!"ENABLING".equals(serviceEntity.getComponent().getState())) continue;
            this.println();
            this.println("Service: " + serviceEntity.getId() + " - " + serviceEntity.getComponent().getName());
            if (serviceEntity.getBulletins() == null) continue;
            this.println();
            this.println("Reasons: ");
            for (BulletinEntity bulletinEntity : serviceEntity.getBulletins()) {
                this.println("- " + bulletinEntity.getBulletin().getMessage());
            }
        }
    }

    private void printServicesNotEnabled(FlowClient flowClient, String pgId) throws NiFiClientException, IOException {
        ControllerServicesEntity servicesEntity = flowClient.getControllerServices(pgId);
        if (servicesEntity == null || servicesEntity.getControllerServices() == null) {
            return;
        }
        this.println();
        this.println("The following services could not be enabled: ");
        for (ControllerServiceEntity serviceEntity : servicesEntity.getControllerServices()) {
            if ("ENABLED".equals(serviceEntity.getComponent().getState())) continue;
            this.println();
            this.println("Service: " + serviceEntity.getId() + " - " + serviceEntity.getComponent().getName());
            ControllerServiceDTO serviceDTO = serviceEntity.getComponent();
            if (serviceDTO.getValidationErrors() == null) continue;
            this.println();
            this.println("Validation Errors: ");
            for (String validationError : serviceDTO.getValidationErrors()) {
                this.println("- " + validationError);
            }
        }
    }
}

