/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.cli.impl.command.nifi.nodes;

import java.io.IOException;
import java.util.Properties;
import org.apache.commons.cli.MissingOptionException;
import org.apache.nifi.toolkit.cli.api.Context;
import org.apache.nifi.toolkit.cli.impl.client.nifi.ControllerClient;
import org.apache.nifi.toolkit.cli.impl.client.nifi.NiFiClient;
import org.apache.nifi.toolkit.cli.impl.client.nifi.NiFiClientException;
import org.apache.nifi.toolkit.cli.impl.command.CommandOption;
import org.apache.nifi.toolkit.cli.impl.command.nifi.AbstractNiFiCommand;
import org.apache.nifi.toolkit.cli.impl.result.OkResult;

public class DeleteNode
extends AbstractNiFiCommand<OkResult> {
    public DeleteNode() {
        super("delete-node", OkResult.class);
    }

    @Override
    public String getDescription() {
        return "Deletes a node from the NiFi cluster.";
    }

    @Override
    protected void doInitialize(Context context) {
        this.addOption(CommandOption.NIFI_NODE_ID.createOption());
    }

    @Override
    public OkResult doExecute(NiFiClient client, Properties properties) throws NiFiClientException, IOException, MissingOptionException {
        String nodeId = this.getRequiredArg(properties, CommandOption.NIFI_NODE_ID);
        ControllerClient controllerClient = client.getControllerClient();
        controllerClient.deleteNode(nodeId);
        return new OkResult(this.getContext().isInteractive());
    }
}

