/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.kerberos.authentication;

import java.io.UnsupportedEncodingException;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Arrays;
import java.util.Collection;
import javax.security.auth.Subject;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.MessageProp;
import org.springframework.security.authentication.AbstractAuthenticationToken;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.crypto.codec.Base64;
import org.springframework.security.kerberos.authentication.KerberosTicketValidation;

public class KerberosServiceRequestToken
extends AbstractAuthenticationToken {
    private static final long serialVersionUID = 395488921064775014L;
    private final byte[] token;
    private final Object principal;
    private final transient KerberosTicketValidation ticketValidation;

    public KerberosServiceRequestToken(Object principal, KerberosTicketValidation ticketValidation, Collection<? extends GrantedAuthority> authorities, byte[] token) {
        super(authorities);
        this.token = token;
        this.principal = principal;
        this.ticketValidation = ticketValidation;
        super.setAuthenticated(true);
    }

    public KerberosServiceRequestToken(byte[] token) {
        super(null);
        this.token = token;
        this.ticketValidation = null;
        this.principal = null;
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + Arrays.hashCode(this.token);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        KerberosServiceRequestToken other = (KerberosServiceRequestToken)((Object)obj);
        return Arrays.equals(this.token, other.token);
    }

    public Object getCredentials() {
        return null;
    }

    public Object getPrincipal() {
        return this.principal;
    }

    public byte[] getToken() {
        return this.token;
    }

    public KerberosTicketValidation getTicketValidation() {
        return this.ticketValidation;
    }

    public boolean hasResponseToken() {
        return this.ticketValidation != null && this.ticketValidation.responseToken() != null;
    }

    public String getEncodedResponseToken() {
        if (!this.hasResponseToken()) {
            throw new IllegalStateException("Unauthenticated or no response token");
        }
        try {
            return new String(Base64.encode((byte[])this.ticketValidation.responseToken()), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("Unable to encode response token", e);
        }
    }

    public byte[] decrypt(final byte[] data, final int offset, final int length) throws PrivilegedActionException {
        return Subject.doAs(this.getTicketValidation().subject(), new PrivilegedExceptionAction<byte[]>(){

            @Override
            public byte[] run() throws Exception {
                GSSContext context = KerberosServiceRequestToken.this.getTicketValidation().getGssContext();
                return context.unwrap(data, offset, length, new MessageProp(true));
            }
        });
    }

    public byte[] decrypt(byte[] data) throws PrivilegedActionException {
        return this.decrypt(data, 0, data.length);
    }

    public byte[] encrypt(final byte[] data, final int offset, final int length) throws PrivilegedActionException {
        return Subject.doAs(this.getTicketValidation().subject(), new PrivilegedExceptionAction<byte[]>(){

            @Override
            public byte[] run() throws Exception {
                GSSContext context = KerberosServiceRequestToken.this.getTicketValidation().getGssContext();
                return context.wrap(data, offset, length, new MessageProp(true));
            }
        });
    }

    public byte[] encrypt(byte[] data) throws PrivilegedActionException {
        return this.encrypt(data, 0, data.length);
    }
}

