/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.tree.patricia;

import java.util.Arrays;
import jetbrains.exodus.ArrayByteIterable;
import jetbrains.exodus.ByteIterable;
import jetbrains.exodus.CompoundByteIterable;
import jetbrains.exodus.log.CompressedUnsignedLongByteIterable;
import jetbrains.exodus.log.Log;
import jetbrains.exodus.log.SingleByteIterable;
import jetbrains.exodus.tree.ITree;
import jetbrains.exodus.tree.ITreeCursor;
import jetbrains.exodus.tree.ITreeMutable;
import jetbrains.exodus.tree.LongIterator;
import jetbrains.exodus.tree.patricia.EscapingByteIterable;
import jetbrains.exodus.tree.patricia.PatriciaCursorDecorator;
import jetbrains.exodus.tree.patricia.PatriciaTree;
import jetbrains.exodus.tree.patricia.PatriciaTreeDecorator;
import jetbrains.exodus.tree.patricia.PatriciaTreeEmpty;
import jetbrains.exodus.tree.patricia.PatriciaTreeWithDuplicatesMutable;
import jetbrains.exodus.tree.patricia.UnEscapingByteIterable;
import jetbrains.exodus.util.ByteIterableUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PatriciaTreeWithDuplicates
extends PatriciaTreeDecorator {
    public PatriciaTreeWithDuplicates(@NotNull Log log, long rootAddress, int structureId) {
        this(log, rootAddress, structureId, false);
    }

    public PatriciaTreeWithDuplicates(@NotNull Log log, long rootAddress, int structureId, boolean empty) {
        super(empty ? new PatriciaTreeEmpty(log, structureId, false) : new PatriciaTree(log, rootAddress, structureId));
    }

    protected PatriciaTreeWithDuplicates(@NotNull ITree treeNoDuplicates) {
        super(treeNoDuplicates);
    }

    @Override
    @Nullable
    public ByteIterable get(@NotNull ByteIterable key) {
        try (ITreeCursor cursor = this.treeNoDuplicates.openCursor();){
            ByteIterable value = cursor.getSearchKeyRange(PatriciaTreeWithDuplicates.getEscapedKeyWithSeparator(key));
            if (value != null && value != ByteIterable.EMPTY) {
                int keyLength = CompressedUnsignedLongByteIterable.getInt(value);
                if (key.getLength() == keyLength) {
                    UnEscapingByteIterable noDupKey = new UnEscapingByteIterable(cursor.getKey());
                    byte[] noDupKeyBytes = noDupKey.getBytesUnsafe();
                    if (ByteIterableUtil.compare((byte[])key.getBytesUnsafe(), (int)keyLength, (byte[])noDupKeyBytes, (int)keyLength) == 0) {
                        ArrayByteIterable arrayByteIterable = new ArrayByteIterable(Arrays.copyOfRange(noDupKeyBytes, keyLength + 1, noDupKey.getLength()));
                        return arrayByteIterable;
                    }
                }
            }
            ByteIterable byteIterable = null;
            return byteIterable;
        }
    }

    @Override
    public boolean hasPair(@NotNull ByteIterable key, @NotNull ByteIterable value) {
        return this.treeNoDuplicates.hasKey(PatriciaTreeWithDuplicates.getEscapedKeyValue(key, value));
    }

    @Override
    @NotNull
    public ITreeMutable getMutableCopy() {
        return new PatriciaTreeWithDuplicatesMutable(this.treeNoDuplicates.getMutableCopy());
    }

    @Override
    public ITreeCursor openCursor() {
        return new PatriciaCursorDecorator(this.treeNoDuplicates.openCursor());
    }

    @Override
    public LongIterator addressIterator() {
        return this.treeNoDuplicates.addressIterator();
    }

    protected static ByteIterable getEscapedKeyValue(@NotNull ByteIterable key, @NotNull ByteIterable value) {
        return new CompoundByteIterable(new ByteIterable[]{new EscapingByteIterable(key), SingleByteIterable.getIterable((byte)0), new EscapingByteIterable(value)});
    }

    protected static ByteIterable getEscapedKeyWithSeparator(@NotNull ByteIterable key) {
        return new CompoundByteIterable(new ByteIterable[]{new EscapingByteIterable(key), SingleByteIterable.getIterable((byte)0)});
    }
}

