/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.tree.patricia;

import java.util.Arrays;
import jetbrains.exodus.ArrayByteIterable;
import jetbrains.exodus.ByteIterable;
import jetbrains.exodus.log.CompressedUnsignedLongByteIterable;
import jetbrains.exodus.tree.ITree;
import jetbrains.exodus.tree.ITreeCursor;
import jetbrains.exodus.tree.patricia.EscapingByteIterable;
import jetbrains.exodus.tree.patricia.PatriciaTreeWithDuplicates;
import jetbrains.exodus.tree.patricia.UnEscapingByteIterable;
import jetbrains.exodus.util.ByteIterableUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PatriciaCursorDecorator
implements ITreeCursor {
    private static final int UNKNOWN = -1;
    ITreeCursor patriciaCursor;
    byte[] keyBytes;
    int keyLength;
    int valueLength;
    byte[] nextKeyBytes;
    int nextKeyLength = -1;
    int nextValueLength;
    byte[] prevKeyBytes;
    int prevKeyLength = -1;
    int prevValueLength;

    public PatriciaCursorDecorator(ITreeCursor patriciaCursor) {
        this.patriciaCursor = patriciaCursor;
    }

    @Override
    public boolean isMutable() {
        return this.patriciaCursor.isMutable();
    }

    @Override
    public ITree getTree() {
        return this.patriciaCursor.getTree();
    }

    public boolean getNext() {
        if (this.getNextLazy()) {
            this.advance();
            return true;
        }
        return false;
    }

    public boolean getNextDup() {
        if (this.keyBytes == null) {
            throw new IllegalStateException("Cursor is not yet initialized");
        }
        if (this.getNextLazy() && ByteIterableUtil.compare((byte[])this.keyBytes, (int)this.keyLength, (byte[])this.nextKeyBytes, (int)this.nextKeyLength) == 0) {
            this.advance();
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getNextNoDup() {
        block7: {
            ITreeCursor cursor;
            if (this.keyBytes == null) {
                return this.getNext();
            }
            if (this.getNextLazy() && ByteIterableUtil.compare((byte[])this.keyBytes, (int)this.keyLength, (byte[])this.nextKeyBytes, (int)this.nextKeyLength) != 0) {
                this.advance();
                return true;
            }
            try (ITreeCursor cursorToClose = cursor = this.patriciaCursor.getTree().openCursor();){
                if (cursor.getSearchKeyRange(PatriciaTreeWithDuplicates.getEscapedKeyValue(this.getKey(), this.getValue())) == null) break block7;
                while (cursor.getNext()) {
                    ByteIterable keyLengthIterable = cursor.getValue();
                    UnEscapingByteIterable noDupKey = new UnEscapingByteIterable(cursor.getKey());
                    int keyLength = CompressedUnsignedLongByteIterable.getInt(keyLengthIterable);
                    byte[] noDupKeyBytes = noDupKey.getBytesUnsafe();
                    if (ByteIterableUtil.compare((byte[])this.keyBytes, (int)this.keyLength, (byte[])noDupKeyBytes, (int)keyLength) == 0) continue;
                    this.keyBytes = noDupKey.getBytesUnsafe();
                    this.keyLength = keyLength;
                    this.valueLength = noDupKey.getLength() - keyLength - 1;
                    cursorToClose = this.patriciaCursor;
                    this.patriciaCursor = cursor;
                    this.nextKeyLength = -1;
                    this.prevKeyLength = -1;
                    boolean bl = true;
                    return bl;
                }
            }
        }
        return false;
    }

    public boolean getPrev() {
        if (this.getPrevLazy()) {
            this.retreat();
            return true;
        }
        return false;
    }

    public boolean getPrevDup() {
        if (this.keyBytes == null) {
            throw new IllegalStateException("Cursor is not yet initialized");
        }
        if (this.getPrevLazy() && ByteIterableUtil.compare((byte[])this.keyBytes, (int)this.keyLength, (byte[])this.prevKeyBytes, (int)this.prevKeyLength) == 0) {
            this.retreat();
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getPrevNoDup() {
        block7: {
            ITreeCursor cursor;
            if (this.keyBytes == null) {
                return this.getPrev();
            }
            if (this.getPrevLazy() && ByteIterableUtil.compare((byte[])this.keyBytes, (int)this.keyLength, (byte[])this.prevKeyBytes, (int)this.prevKeyLength) != 0) {
                this.advance();
                return true;
            }
            try (ITreeCursor cursorToClose = cursor = this.patriciaCursor.getTree().openCursor();){
                if (cursor.getSearchKeyRange(PatriciaTreeWithDuplicates.getEscapedKeyValue(this.getKey(), this.getValue())) == null) break block7;
                while (cursor.getPrev()) {
                    ByteIterable keyLengthIterable = cursor.getValue();
                    UnEscapingByteIterable noDupKey = new UnEscapingByteIterable(cursor.getKey());
                    int keyLength = CompressedUnsignedLongByteIterable.getInt(keyLengthIterable);
                    byte[] noDupKeyBytes = noDupKey.getBytesUnsafe();
                    if (ByteIterableUtil.compare((byte[])this.keyBytes, (int)this.keyLength, (byte[])noDupKeyBytes, (int)keyLength) == 0) continue;
                    this.keyBytes = noDupKey.getBytesUnsafe();
                    this.keyLength = keyLength;
                    this.valueLength = noDupKey.getLength() - keyLength - 1;
                    cursorToClose = this.patriciaCursor;
                    this.patriciaCursor = cursor;
                    this.prevKeyLength = -1;
                    this.nextKeyLength = -1;
                    boolean bl = true;
                    return bl;
                }
            }
        }
        return false;
    }

    public boolean getLast() {
        if (this.patriciaCursor.getLast()) {
            ByteIterable keyLengthIterable = this.patriciaCursor.getValue();
            UnEscapingByteIterable sourceKey = new UnEscapingByteIterable(this.patriciaCursor.getKey());
            this.keyBytes = sourceKey.getBytesUnsafe();
            this.keyLength = CompressedUnsignedLongByteIterable.getInt(keyLengthIterable);
            this.valueLength = sourceKey.getLength() - this.keyLength - 1;
            this.nextKeyLength = -1;
            this.prevKeyLength = -1;
            return true;
        }
        return false;
    }

    @NotNull
    public ByteIterable getKey() {
        return this.keyBytes == null ? ByteIterable.EMPTY : new ArrayByteIterable(this.keyBytes, this.keyLength);
    }

    @NotNull
    public ByteIterable getValue() {
        if (this.keyBytes == null) {
            return ByteIterable.EMPTY;
        }
        int offset = this.keyLength + 1;
        return new ArrayByteIterable(Arrays.copyOfRange(this.keyBytes, offset, offset + this.valueLength));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public ByteIterable getSearchKey(@NotNull ByteIterable key) {
        ITreeCursor cursor;
        try (ITreeCursor cursorToClose = cursor = this.patriciaCursor.getTree().openCursor();){
            ByteIterable keyLengthIterable = cursor.getSearchKeyRange((ByteIterable)new EscapingByteIterable(key));
            if (keyLengthIterable != null) {
                int keyLength = CompressedUnsignedLongByteIterable.getInt(keyLengthIterable);
                if (key.getLength() == keyLength) {
                    byte[] noDupKeyBytes;
                    UnEscapingByteIterable noDupKey = new UnEscapingByteIterable(cursor.getKey());
                    byte[] keyBytes = key.getBytesUnsafe();
                    if (ByteIterableUtil.compare((byte[])keyBytes, (int)keyLength, (byte[])(noDupKeyBytes = noDupKey.getBytesUnsafe()), (int)keyLength) == 0) {
                        this.keyBytes = noDupKeyBytes;
                        this.keyLength = keyLength;
                        this.valueLength = noDupKey.getLength() - keyLength - 1;
                        cursorToClose = this.patriciaCursor;
                        this.patriciaCursor = cursor;
                        this.nextKeyLength = -1;
                        this.prevKeyLength = -1;
                        ByteIterable byteIterable = this.getValue();
                        return byteIterable;
                    }
                }
            }
        }
        return null;
    }

    @Nullable
    public ByteIterable getSearchKeyRange(@NotNull ByteIterable key) {
        ByteIterable keyLengthIterable = this.patriciaCursor.getSearchKeyRange((ByteIterable)new EscapingByteIterable(key));
        if (keyLengthIterable == null) {
            return null;
        }
        UnEscapingByteIterable noDupKey = new UnEscapingByteIterable(this.patriciaCursor.getKey());
        this.keyBytes = noDupKey.getBytesUnsafe();
        this.keyLength = CompressedUnsignedLongByteIterable.getInt(keyLengthIterable);
        this.valueLength = noDupKey.getLength() - this.keyLength - 1;
        this.nextKeyLength = -1;
        this.prevKeyLength = -1;
        return this.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getSearchBoth(@NotNull ByteIterable key, @NotNull ByteIterable value) {
        ITreeCursor cursor;
        try (ITreeCursor cursorToClose = cursor = this.patriciaCursor.getTree().openCursor();){
            ByteIterable keyLengthIterable = cursor.getSearchKey(PatriciaTreeWithDuplicates.getEscapedKeyValue(key, value));
            if (keyLengthIterable == null) {
                boolean bl = false;
                return bl;
            }
            int keyLength = CompressedUnsignedLongByteIterable.getInt(keyLengthIterable);
            if (keyLength == key.getLength()) {
                this.keyBytes = new UnEscapingByteIterable(cursor.getKey()).getBytesUnsafe();
                this.keyLength = keyLength;
                this.valueLength = value.getLength();
                cursorToClose = this.patriciaCursor;
                this.patriciaCursor = cursor;
                this.nextKeyLength = -1;
                this.prevKeyLength = -1;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public ByteIterable getSearchBothRange(@NotNull ByteIterable key, @NotNull ByteIterable value) {
        ITreeCursor cursor;
        try (ITreeCursor cursorToClose = cursor = this.patriciaCursor.getTree().openCursor();){
            ByteIterable keyLengthIterable = cursor.getSearchKeyRange((ByteIterable)new EscapingByteIterable(key));
            if (keyLengthIterable != null) {
                int srcKeyLength = key.getLength();
                int valueLength = value.getLength();
                while (true) {
                    int keyLength;
                    if (srcKeyLength == (keyLength = CompressedUnsignedLongByteIterable.getInt(keyLengthIterable))) {
                        int noDupKeyLength;
                        int cmp;
                        byte[] noDupKeyBytes;
                        UnEscapingByteIterable noDupKey = new UnEscapingByteIterable(cursor.getKey());
                        byte[] srcKeyBytes = key.getBytesUnsafe();
                        if (ByteIterableUtil.compare((byte[])srcKeyBytes, (int)keyLength, (byte[])(noDupKeyBytes = noDupKey.getBytesUnsafe()), (int)keyLength) == 0 && (cmp = ByteIterableUtil.compare((byte[])noDupKeyBytes, (int)(noDupKeyLength = noDupKey.getLength() - keyLength - 1), (int)(keyLength + 1), (byte[])value.getBytesUnsafe(), (int)valueLength)) >= 0) {
                            this.keyBytes = noDupKeyBytes;
                            this.keyLength = keyLength;
                            this.valueLength = noDupKeyLength;
                            cursorToClose = this.patriciaCursor;
                            this.patriciaCursor = cursor;
                            this.nextKeyLength = -1;
                            this.prevKeyLength = -1;
                            ByteIterable byteIterable = this.getValue();
                            return byteIterable;
                        }
                    }
                    if (cursor.getNext()) {
                        keyLengthIterable = cursor.getValue();
                        continue;
                    }
                    break;
                }
            }
        }
        return null;
    }

    public int count() {
        int result = 0;
        try (ITreeCursor cursor = this.patriciaCursor.getTree().openCursor();){
            @Nullable ByteIterable value = cursor.getSearchKeyRange((ByteIterable)new EscapingByteIterable(this.getKey()));
            while (value != null) {
                if (this.keyLength != CompressedUnsignedLongByteIterable.getInt(value)) {
                    break;
                }
                UnEscapingByteIterable noDupKey = new UnEscapingByteIterable(cursor.getKey());
                if (ByteIterableUtil.compare((byte[])this.keyBytes, (int)this.keyLength, (byte[])noDupKey.getBytesUnsafe(), (int)this.keyLength) != 0) {
                    break;
                }
                ++result;
                value = cursor.getNext() ? cursor.getValue() : null;
            }
        }
        return result;
    }

    public void close() {
        this.patriciaCursor.close();
    }

    public boolean deleteCurrent() {
        return this.patriciaCursor.deleteCurrent();
    }

    private void advance() {
        this.prevKeyBytes = this.keyBytes;
        this.prevKeyLength = this.keyLength;
        this.prevValueLength = this.valueLength;
        this.keyBytes = this.nextKeyBytes;
        this.keyLength = this.nextKeyLength;
        this.valueLength = this.nextValueLength;
        this.nextKeyLength = -1;
    }

    private boolean getNextLazy() {
        if (this.nextKeyLength < 0) {
            if (this.patriciaCursor.getNext()) {
                ByteIterable keyLengthIterable = this.patriciaCursor.getValue();
                UnEscapingByteIterable noDupKey = new UnEscapingByteIterable(this.patriciaCursor.getKey());
                this.nextKeyBytes = noDupKey.getBytesUnsafe();
                this.nextKeyLength = CompressedUnsignedLongByteIterable.getInt(keyLengthIterable);
                this.nextValueLength = noDupKey.getLength() - this.nextKeyLength - 1;
                return true;
            }
            return false;
        }
        return this.nextKeyBytes != null;
    }

    private void retreat() {
        this.nextKeyBytes = this.keyBytes;
        this.nextKeyLength = this.keyLength;
        this.nextValueLength = this.valueLength;
        this.keyBytes = this.prevKeyBytes;
        this.keyLength = this.prevKeyLength;
        this.valueLength = this.prevValueLength;
        this.prevKeyLength = -1;
    }

    private boolean getPrevLazy() {
        if (this.prevKeyLength < 0) {
            if (this.patriciaCursor.getPrev()) {
                ByteIterable keyLengthIterable = this.patriciaCursor.getValue();
                UnEscapingByteIterable noDupKey = new UnEscapingByteIterable(this.patriciaCursor.getKey());
                this.prevKeyBytes = noDupKey.getBytesUnsafe();
                this.prevKeyLength = CompressedUnsignedLongByteIterable.getInt(keyLengthIterable);
                this.prevValueLength = noDupKey.getLength() - this.prevKeyLength - 1;
                return true;
            }
            return false;
        }
        return this.prevKeyBytes != null;
    }
}

