/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.tree.btree;

import java.io.PrintStream;
import jetbrains.exodus.ByteIterable;
import jetbrains.exodus.ByteIterator;
import jetbrains.exodus.log.ByteIterableWithAddress;
import jetbrains.exodus.log.CompressedUnsignedLongByteIterable;
import jetbrains.exodus.tree.Dumpable;
import jetbrains.exodus.tree.btree.BTreeBase;
import jetbrains.exodus.tree.btree.BTreeMutable;
import jetbrains.exodus.tree.btree.BTreeReclaimTraverser;
import jetbrains.exodus.tree.btree.BTreeTraverser;
import jetbrains.exodus.tree.btree.BasePage;
import jetbrains.exodus.tree.btree.BasePageImmutable;
import jetbrains.exodus.tree.btree.BasePageMutable;
import jetbrains.exodus.tree.btree.ILeafNode;
import jetbrains.exodus.tree.btree.InternalPageMutable;
import jetbrains.exodus.tree.btree.TreePos;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class InternalPage
extends BasePageImmutable {
    private byte childAddressLen;

    protected InternalPage(@NotNull BTreeBase tree, @NotNull ByteIterableWithAddress data) {
        super(tree, data);
    }

    protected InternalPage(@NotNull BTreeBase tree, @NotNull ByteIterableWithAddress data, int size) {
        super(tree, data, size);
    }

    @Override
    protected void loadAddressLengths(int length, ByteIterator it) {
        super.loadAddressLengths(length, it);
        it.skip((long)(this.size * this.keyAddressLen));
        this.childAddressLen = it.next();
        InternalPage.checkAddressLength(this.childAddressLen);
    }

    @Override
    @NotNull
    protected BasePageMutable getMutableCopy(BTreeMutable treeMutable) {
        return new InternalPageMutable(treeMutable, this);
    }

    @Override
    public long getChildAddress(int index) {
        int offset = this.size * this.keyAddressLen + index * this.childAddressLen + 1;
        return this.data.nextLong((int)(this.dataAddress - this.data.getDataAddress() + (long)offset), this.childAddressLen);
    }

    @Override
    @NotNull
    public BasePage getChild(int index) {
        return this.getTree().loadPage(this.getChildAddress(index));
    }

    @Override
    protected boolean isBottom() {
        return false;
    }

    @Override
    public ILeafNode get(@NotNull ByteIterable key) {
        return InternalPage.get(key, this);
    }

    @Override
    public ILeafNode find(@NotNull BTreeTraverser stack, int depth, @NotNull ByteIterable key, @Nullable ByteIterable value, boolean equalOrNext) {
        return InternalPage.find(stack, depth, key, value, equalOrNext, this);
    }

    @Override
    public boolean keyExists(@NotNull ByteIterable key) {
        return InternalPage.keyExists(key, this);
    }

    @Override
    public boolean exists(@NotNull ByteIterable key, @NotNull ByteIterable value) {
        return InternalPage.exists(key, value, this);
    }

    @Override
    public boolean childExists(@NotNull ByteIterable key, long pageAddress) {
        int index = InternalPage.binarySearchGuessUnsafe(this, key);
        return index >= 0 && (this.getChildAddress(index) == pageAddress || this.getChild(index).childExists(key, pageAddress));
    }

    static ILeafNode get(@NotNull ByteIterable key, BasePage page) {
        int index = page.binarySearch(key);
        return index < 0 ? page.getChild(Math.max(-index - 2, 0)).get(key) : page.getKey(index);
    }

    @Nullable
    static ILeafNode find(@NotNull BTreeTraverser stack, int depth, @NotNull ByteIterable key, @Nullable ByteIterable value, boolean equalOrNext, @NotNull BasePage page) {
        int index = InternalPage.binarySearchGuess(page, key);
        ILeafNode ln = page.getChild(index).find(stack, depth + 1, key, value, equalOrNext);
        if (ln == null && value == null && equalOrNext && index < page.getSize() - 1) {
            ln = page.getChild(++index).find(stack, depth + 1, key, value, equalOrNext);
        }
        if (ln != null) {
            stack.setAt(depth, new TreePos(page, index));
        }
        return ln;
    }

    static boolean keyExists(@NotNull ByteIterable key, BasePage page) {
        int index = page.binarySearch(key);
        return index >= 0 || page.getChild(Math.max(-index - 2, 0)).keyExists(key);
    }

    static boolean exists(@NotNull ByteIterable key, @NotNull ByteIterable value, BasePage page) {
        int index = page.binarySearch(key);
        return index < 0 ? page.getChild(Math.max(-index - 2, 0)).exists(key, value) : page.getKey(index).valueExists(value);
    }

    @Override
    protected long getBottomPagesCount() {
        long result = 0L;
        for (int i = 0; i < this.getSize(); ++i) {
            result += this.getChild(i).getBottomPagesCount();
        }
        return result;
    }

    public String toString() {
        return "Internal [" + this.size + "] @ " + (this.getDataAddress() - (long)CompressedUnsignedLongByteIterable.getIterable(this.size << 1).getLength() - 2L);
    }

    @Override
    public void dump(PrintStream out, int level, Dumpable.ToString renderer) {
        InternalPage.dump(out, level, renderer, this);
    }

    protected void reclaim(ByteIterable keyIterable, @NotNull BTreeReclaimTraverser context) {
        block9: {
            block7: {
                int index;
                block8: {
                    if (context.currentNode.getDataAddress() == this.getDataAddress()) break block7;
                    if (context.canMoveUp()) {
                        block6: {
                            do {
                                context.popAndMutate();
                                if (context.currentNode.getDataAddress() == this.getDataAddress()) {
                                    InternalPage.doReclaim(context);
                                    return;
                                }
                                context.moveRight();
                                index = context.getNextSibling(keyIterable);
                                if (index >= 0) break block6;
                            } while (context.canMoveUp());
                            context.moveTo(Math.max(-index - 2, 0));
                            break block8;
                        }
                        context.pushChild(index);
                    }
                }
                while (context.canMoveDown()) {
                    if (context.currentNode.getDataAddress() == this.getDataAddress()) {
                        InternalPage.doReclaim(context);
                        return;
                    }
                    index = context.getNextSibling(keyIterable);
                    if (index < 0) {
                        index = Math.max(-index - 2, 0);
                    }
                    context.pushChild(index);
                }
                break block9;
            }
            InternalPage.doReclaim(context);
        }
    }

    protected static int binarySearchGuess(@NotNull BasePage page, @NotNull ByteIterable key) {
        int index = InternalPage.binarySearchGuessUnsafe(page, key);
        if (index < 0) {
            index = 0;
        }
        return index;
    }

    protected static int binarySearchGuessUnsafe(@NotNull BasePage page, @NotNull ByteIterable key) {
        int index = page.binarySearch(key);
        if (index < 0) {
            index = -index - 2;
        }
        return index;
    }

    static void dump(PrintStream out, int level, Dumpable.ToString renderer, BasePage page) {
        InternalPage.indent(out, level);
        out.println(page);
        for (int i = 0; i < page.getSize(); ++i) {
            InternalPage.indent(out, level);
            out.print("+");
            page.getKey(i).dump(out, 0, renderer);
            page.getChild(i).dump(out, level + 3, renderer);
        }
    }
}

