/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.tls.service.client;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.KeyPair;
import java.security.cert.Certificate;
import org.apache.nifi.toolkit.tls.configuration.TlsClientConfig;
import org.apache.nifi.toolkit.tls.manager.TlsClientManager;
import org.apache.nifi.toolkit.tls.manager.writer.JsonConfigurationWriter;
import org.apache.nifi.toolkit.tls.util.OutputStreamFactory;
import org.apache.nifi.toolkit.tls.util.TlsHelper;
import org.apache.nifi.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TlsCertificateAuthorityClient {
    private final Logger logger = LoggerFactory.getLogger(TlsCertificateAuthorityClient.class);
    private final OutputStreamFactory outputStreamFactory;

    public TlsCertificateAuthorityClient() {
        this(FileOutputStream::new);
    }

    public TlsCertificateAuthorityClient(OutputStreamFactory outputStreamFactory) {
        this.outputStreamFactory = outputStreamFactory;
    }

    public void generateCertificateAndGetItSigned(TlsClientConfig tlsClientConfig, String certificateDirectory, String configJson, boolean differentKeyAndKeyStorePassword) throws Exception {
        TlsClientManager tlsClientManager;
        try {
            tlsClientManager = new TlsClientManager(tlsClientConfig);
        }
        catch (IOException e) {
            this.logger.error("Unable to open existing keystore, it can be reused by specifiying both configJson and useConfigJson");
            throw e;
        }
        tlsClientManager.setDifferentKeyAndKeyStorePassword(differentKeyAndKeyStorePassword);
        if (!StringUtils.isEmpty((String)certificateDirectory)) {
            tlsClientManager.setCertificateAuthorityDirectory(new File(certificateDirectory));
        }
        if (!StringUtils.isEmpty((String)configJson)) {
            tlsClientManager.addClientConfigurationWriter(new JsonConfigurationWriter<TlsClientConfig>(new ObjectMapper(), new File(configJson)));
        }
        if (tlsClientManager.getEntry("nifi-key") == null) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info("Requesting new certificate from " + tlsClientConfig.getCaHostname() + ":" + tlsClientConfig.getPort());
            }
            KeyPair keyPair = TlsHelper.generateKeyPair(tlsClientConfig.getKeyPairAlgorithm(), tlsClientConfig.getKeySize());
            Certificate[] certificates = tlsClientConfig.createCertificateSigningRequestPerformer().perform(keyPair);
            tlsClientManager.addPrivateKeyToKeyStore(keyPair, "nifi-key", certificates);
            tlsClientManager.setCertificateEntry("nifi-cert", certificates[certificates.length - 1]);
        } else if (this.logger.isInfoEnabled()) {
            this.logger.info("Already had entry for nifi-key not requesting new certificate.");
        }
        tlsClientManager.write(this.outputStreamFactory);
    }
}

