/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.tls.configuration;

import java.util.List;
import org.apache.nifi.util.StringUtils;

public class TlsConfig {
    public static final String DEFAULT_HOSTNAME = "localhost";
    public static final String DEFAULT_KEY_STORE_TYPE = "jks";
    public static final int DEFAULT_PORT = 9443;
    public static final int DEFAULT_DAYS = 825;
    public static final int DEFAULT_KEY_SIZE = 2048;
    public static final String DEFAULT_KEY_PAIR_ALGORITHM = "RSA";
    public static final String DEFAULT_SIGNING_ALGORITHM = "SHA256WITHRSA";
    public static final String DEFAULT_DN_PREFIX = "CN=";
    public static final String DEFAULT_DN_SUFFIX = ", OU=NIFI";
    private int days = 825;
    private int keySize = 2048;
    private String keyPairAlgorithm = "RSA";
    private String signingAlgorithm = "SHA256WITHRSA";
    private String dn;
    private String keyStore;
    private String keyStoreType = "jks";
    private String keyStorePassword;
    private String keyPassword;
    private String token;
    private String caHostname = "localhost";
    private int port = 9443;
    private String dnPrefix = "CN=";
    private String dnSuffix = ", OU=NIFI";
    private String additionalCACertificate = "";
    private List<String> domainAlternativeNames;

    public String calcDefaultDn(String hostname) {
        return this.dnPrefix + hostname + this.dnSuffix;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getKeyStore() {
        return this.keyStore;
    }

    public void setKeyStore(String keyStore) {
        this.keyStore = keyStore;
    }

    public String getKeyStoreType() {
        return this.keyStoreType;
    }

    public void setKeyStoreType(String keyStoreType) {
        this.keyStoreType = keyStoreType;
    }

    public String getKeyStorePassword() {
        return this.keyStorePassword;
    }

    public void setKeyStorePassword(String keyStorePassword) {
        this.keyStorePassword = keyStorePassword;
    }

    public String getKeyPassword() {
        return this.keyPassword;
    }

    public void setKeyPassword(String keyPassword) {
        this.keyPassword = keyPassword;
    }

    public String getToken() {
        return this.token;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public String getCaHostname() {
        return this.caHostname;
    }

    public void setCaHostname(String caHostname) {
        this.caHostname = caHostname;
    }

    public String getDn() {
        return this.dn;
    }

    public void setDn(String dn) {
        this.dn = dn;
    }

    public int getDays() {
        return this.days;
    }

    public void setDays(int days) {
        this.days = days;
    }

    public int getKeySize() {
        return this.keySize;
    }

    public void setKeySize(int keySize) {
        this.keySize = keySize;
    }

    public String getKeyPairAlgorithm() {
        return this.keyPairAlgorithm;
    }

    public void setKeyPairAlgorithm(String keyPairAlgorithm) {
        this.keyPairAlgorithm = keyPairAlgorithm;
    }

    public String getSigningAlgorithm() {
        return this.signingAlgorithm;
    }

    public void setSigningAlgorithm(String signingAlgorithm) {
        this.signingAlgorithm = signingAlgorithm;
    }

    public String getDnPrefix() {
        return this.dnPrefix;
    }

    public void setDnPrefix(String dnPrefix) {
        this.dnPrefix = dnPrefix;
    }

    public String getDnSuffix() {
        return this.dnSuffix;
    }

    public void setDnSuffix(String dnSuffix) {
        this.dnSuffix = dnSuffix;
    }

    public void initDefaults() {
        if (this.days == 0) {
            this.days = 825;
        }
        if (this.keySize == 0) {
            this.keySize = 2048;
        }
        if (StringUtils.isEmpty((String)this.keyPairAlgorithm)) {
            this.keyPairAlgorithm = DEFAULT_KEY_PAIR_ALGORITHM;
        }
        if (StringUtils.isEmpty((String)this.signingAlgorithm)) {
            this.signingAlgorithm = DEFAULT_SIGNING_ALGORITHM;
        }
        if (this.port == 0) {
            this.port = 9443;
        }
        if (StringUtils.isEmpty((String)this.keyStoreType)) {
            this.keyStoreType = DEFAULT_KEY_STORE_TYPE;
        }
        if (StringUtils.isEmpty((String)this.caHostname)) {
            this.caHostname = DEFAULT_HOSTNAME;
        }
        if (StringUtils.isEmpty((String)this.dn)) {
            this.dn = this.calcDefaultDn(this.caHostname);
        }
    }

    public List<String> getDomainAlternativeNames() {
        return this.domainAlternativeNames;
    }

    public void setDomainAlternativeNames(List<String> domainAlternativeNames) {
        this.domainAlternativeNames = domainAlternativeNames;
    }

    public String getAdditionalCACertificate() {
        return this.additionalCACertificate;
    }

    public void setAdditionalCACertificate(String additionalCACertificate) {
        this.additionalCACertificate = additionalCACertificate;
    }
}

