/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.properties;

import com.google.api.gax.rpc.ApiException;
import com.google.api.resourcenames.ResourceName;
import com.google.cloud.kms.v1.CryptoKey;
import com.google.cloud.kms.v1.CryptoKeyName;
import com.google.cloud.kms.v1.CryptoKeyVersion;
import com.google.cloud.kms.v1.DecryptResponse;
import com.google.cloud.kms.v1.EncryptResponse;
import com.google.cloud.kms.v1.KeyManagementServiceClient;
import com.google.protobuf.ByteString;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.properties.ClientBasedEncodedSensitivePropertyProvider;
import org.apache.nifi.properties.SensitivePropertyProtectionException;

public class GcpKmsSensitivePropertyProvider
extends ClientBasedEncodedSensitivePropertyProvider<KeyManagementServiceClient> {
    protected static final String PROJECT_PROPERTY = "gcp.kms.project";
    protected static final String LOCATION_PROPERTY = "gcp.kms.location";
    protected static final String KEYRING_PROPERTY = "gcp.kms.keyring";
    protected static final String KEY_PROPERTY = "gcp.kms.key";
    private static final String SCHEME_BASE_PATH = "gcp/kms";
    private CryptoKeyName cryptoKeyName;

    GcpKmsSensitivePropertyProvider(KeyManagementServiceClient keyManagementServiceClient, Properties properties) {
        super((Object)keyManagementServiceClient, properties);
    }

    public String getIdentifierKey() {
        return SCHEME_BASE_PATH;
    }

    public void cleanUp() {
        KeyManagementServiceClient keyManagementServiceClient = (KeyManagementServiceClient)this.getClient();
        if (keyManagementServiceClient == null) {
            this.logger.debug("GCP KMS Client not configured");
        } else {
            keyManagementServiceClient.close();
        }
    }

    protected void validate(KeyManagementServiceClient keyManagementServiceClient) {
        if (keyManagementServiceClient == null) {
            this.logger.debug("GCP KMS Client not configured");
        } else {
            String project = this.getProperties().getProperty(PROJECT_PROPERTY);
            String location = this.getProperties().getProperty(LOCATION_PROPERTY);
            String keyring = this.getProperties().getProperty(KEYRING_PROPERTY);
            String key = this.getProperties().getProperty(KEY_PROPERTY);
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{project, location, keyring, key})) {
                this.cryptoKeyName = CryptoKeyName.of((String)project, (String)location, (String)keyring, (String)key);
                try {
                    CryptoKey cryptoKey = keyManagementServiceClient.getCryptoKey(this.cryptoKeyName);
                    CryptoKeyVersion cryptoKeyVersion = cryptoKey.getPrimary();
                    if (CryptoKeyVersion.CryptoKeyVersionState.ENABLED != cryptoKeyVersion.getState()) {
                        throw new SensitivePropertyProtectionException(String.format("GCP KMS Crypto Key [%s] Disabled", this.cryptoKeyName));
                    }
                    this.logger.info("GCP KMS Crypto Key [{}] Validated", (Object)this.cryptoKeyName);
                }
                catch (ApiException e) {
                    throw new SensitivePropertyProtectionException(String.format("GCP KMS Crypto Key [%s] Validation Failed", this.cryptoKeyName), (Throwable)e);
                }
            } else {
                throw new SensitivePropertyProtectionException("GCP KMS Missing Required Properties");
            }
        }
    }

    protected byte[] getEncrypted(byte[] bytes) {
        EncryptResponse encryptResponse = ((KeyManagementServiceClient)this.getClient()).encrypt((ResourceName)this.cryptoKeyName, ByteString.copyFrom((byte[])bytes));
        return encryptResponse.getCiphertext().toByteArray();
    }

    protected byte[] getDecrypted(byte[] bytes) {
        DecryptResponse decryptResponse = ((KeyManagementServiceClient)this.getClient()).decrypt(this.cryptoKeyName, ByteString.copyFrom((byte[])bytes));
        return decryptResponse.getPlaintext().toByteArray();
    }
}

