/*
 * Decompiled with CFR 0.152.
 */
package v21.h2.command.ddl;

import v21.h2.command.ddl.AlterDomain;
import v21.h2.constraint.Constraint;
import v21.h2.constraint.ConstraintDomain;
import v21.h2.engine.SessionLocal;
import v21.h2.message.DbException;
import v21.h2.schema.Domain;
import v21.h2.schema.Schema;

public class AlterDomainDropConstraint
extends AlterDomain {
    private String constraintName;
    private final boolean ifConstraintExists;

    public AlterDomainDropConstraint(SessionLocal sessionLocal, Schema schema, boolean bl) {
        super(sessionLocal, schema);
        this.ifConstraintExists = bl;
    }

    public void setConstraintName(String string) {
        this.constraintName = string;
    }

    @Override
    long update(Schema schema, Domain domain) {
        Constraint constraint = schema.findConstraint(this.session, this.constraintName);
        if (constraint == null || constraint.getConstraintType() != Constraint.Type.DOMAIN || ((ConstraintDomain)constraint).getDomain() != domain) {
            if (!this.ifConstraintExists) {
                throw DbException.get(90057, this.constraintName);
            }
        } else {
            this.session.getDatabase().removeSchemaObject(this.session, constraint);
        }
        return 0L;
    }

    @Override
    public int getType() {
        return 93;
    }
}

