/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.io.socket.multicast;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetSocketAddress;
import java.net.MulticastSocket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.nifi.io.socket.multicast.MulticastConfiguration;
import org.apache.nifi.io.socket.multicast.MulticastUtils;
import org.apache.nifi.logging.NiFiLog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class MulticastListener {
    private static final int DEFAULT_SHUTDOWN_LISTENER_SECONDS = 5;
    private static final int DEFAULT_MAX_PACKET_SIZE_BYTES = 512;
    private static final Logger logger = new NiFiLog(LoggerFactory.getLogger(MulticastListener.class));
    private final int numThreads;
    private final InetSocketAddress multicastAddress;
    private final MulticastConfiguration configuration;
    private volatile ExecutorService executorService;
    private volatile MulticastSocket multicastSocket;
    private int shutdownListenerSeconds = 5;
    private int maxPacketSizeBytes = 512;

    public MulticastListener(int numThreads, InetSocketAddress multicastAddress, MulticastConfiguration configuration) {
        if (numThreads <= 0) {
            throw new IllegalArgumentException("Number of threads may not be less than or equal to zero.");
        }
        if (multicastAddress == null) {
            throw new IllegalArgumentException("Multicast address may not be null.");
        }
        if (!multicastAddress.getAddress().isMulticastAddress()) {
            throw new IllegalArgumentException("Multicast group must be a Class D address.");
        }
        if (configuration == null) {
            throw new IllegalArgumentException("Multicast configuration may not be null.");
        }
        this.numThreads = numThreads;
        this.multicastAddress = multicastAddress;
        this.configuration = configuration;
    }

    public abstract void dispatchRequest(MulticastSocket var1, DatagramPacket var2);

    public void start() throws IOException {
        if (this.isRunning()) {
            return;
        }
        this.multicastSocket = MulticastUtils.createMulticastSocket(this.multicastAddress.getPort(), this.configuration);
        this.multicastSocket.joinGroup(this.multicastAddress.getAddress());
        final ExecutorService runnableExecServiceRef = this.executorService = Executors.newFixedThreadPool(this.numThreads);
        final MulticastSocket runnableMulticastSocketRef = this.multicastSocket;
        new Thread(new Runnable(){

            @Override
            public void run() {
                while (!runnableExecServiceRef.isShutdown()) {
                    try {
                        byte[] buf = new byte[MulticastListener.this.maxPacketSizeBytes];
                        final DatagramPacket packet = new DatagramPacket(buf, MulticastListener.this.maxPacketSizeBytes);
                        runnableMulticastSocketRef.receive(packet);
                        runnableExecServiceRef.execute(new Runnable(){

                            @Override
                            public void run() {
                                MulticastListener.this.dispatchRequest(MulticastListener.this.multicastSocket, packet);
                            }
                        });
                    }
                    catch (SocketException | SocketTimeoutException buf) {
                    }
                    catch (Exception e) {
                        logger.warn("Cluster protocol receiver encountered exception: " + e, (Throwable)e);
                    }
                }
            }
        }).start();
    }

    public boolean isRunning() {
        return this.executorService != null && !this.executorService.isShutdown();
    }

    public void stop() throws IOException {
        if (!this.isRunning()) {
            return;
        }
        try {
            if (this.getShutdownListenerSeconds() <= 0) {
                this.executorService.shutdownNow();
            } else {
                this.executorService.shutdown();
            }
            this.executorService.awaitTermination(this.getShutdownListenerSeconds(), TimeUnit.SECONDS);
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
        finally {
            if (this.executorService.isTerminated()) {
                logger.info("Multicast Listener has been terminated successfully.");
            } else {
                logger.warn("Multicast Listener has not terminated properly.  There exists an uninterruptable thread that will take an indeterminate amount of time to stop.");
            }
        }
        if (!this.multicastSocket.isClosed()) {
            this.multicastSocket.leaveGroup(this.multicastAddress.getAddress());
            this.multicastSocket.close();
        }
    }

    public int getShutdownListenerSeconds() {
        return this.shutdownListenerSeconds;
    }

    public void setShutdownListenerSeconds(int shutdownListenerSeconds) {
        this.shutdownListenerSeconds = shutdownListenerSeconds;
    }

    public int getMaxPacketSizeBytes() {
        return this.maxPacketSizeBytes;
    }

    public void setMaxPacketSizeBytes(int maxPacketSizeBytes) {
        if (maxPacketSizeBytes <= 0) {
            throw new IllegalArgumentException("Max packet size must be greater than zero bytes.");
        }
        this.maxPacketSizeBytes = maxPacketSizeBytes;
    }

    public MulticastConfiguration getConfiguration() {
        return this.configuration;
    }

    public InetSocketAddress getMulticastAddress() {
        return this.multicastAddress;
    }

    public int getNumThreads() {
        return this.numThreads;
    }
}

