/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.security.util.crypto;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import org.apache.nifi.security.util.crypto.BcryptSecureHasher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeyDerivationBcryptSecureHasher
extends BcryptSecureHasher {
    private static final Logger LOGGER = LoggerFactory.getLogger(KeyDerivationBcryptSecureHasher.class);
    private static final String DIGEST_ALGORITHM = "SHA-512";
    private static final int HASH_START_INDEX = 29;
    private final int derivedKeyLength;
    private final boolean digestBcryptHash;

    public KeyDerivationBcryptSecureHasher(int derivedKeyLength) {
        this.derivedKeyLength = derivedKeyLength;
        this.digestBcryptHash = false;
    }

    public KeyDerivationBcryptSecureHasher(int derivedKeyLength, int cost, boolean digestBcryptHash) {
        super(cost);
        this.derivedKeyLength = derivedKeyLength;
        this.digestBcryptHash = digestBcryptHash;
    }

    @Override
    byte[] hash(byte[] input, byte[] rawSalt) {
        byte[] digest;
        byte[] costSaltBcryptHash = super.hash(input, rawSalt);
        MessageDigest messageDigest = this.getMessageDigest();
        if (this.digestBcryptHash) {
            LOGGER.warn("Using Legacy Key Derivation on bcrypt hash including cost and salt");
            digest = messageDigest.digest(costSaltBcryptHash);
        } else {
            byte[] hash = Arrays.copyOfRange(costSaltBcryptHash, 29, costSaltBcryptHash.length);
            digest = messageDigest.digest(hash);
        }
        return Arrays.copyOf(digest, this.derivedKeyLength);
    }

    private MessageDigest getMessageDigest() {
        try {
            return MessageDigest.getInstance(DIGEST_ALGORITHM);
        }
        catch (NoSuchAlgorithmException e) {
            throw new UnsupportedOperationException(DIGEST_ALGORITHM, e);
        }
    }
}

