/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller.state;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.net.ssl.SSLContext;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.PropertyValue;
import org.apache.nifi.components.state.StateProviderInitializationContext;
import org.apache.nifi.logging.ComponentLog;

public class StandardStateProviderInitializationContext
implements StateProviderInitializationContext {
    private final String id;
    private final Map<PropertyDescriptor, PropertyValue> properties;
    private final SSLContext sslContext;
    private final ComponentLog logger;

    public StandardStateProviderInitializationContext(String identifier, Map<PropertyDescriptor, PropertyValue> properties, SSLContext sslContext, ComponentLog logger) {
        this.id = identifier;
        this.properties = new HashMap<PropertyDescriptor, PropertyValue>(properties);
        this.sslContext = sslContext;
        this.logger = logger;
    }

    public Map<PropertyDescriptor, PropertyValue> getProperties() {
        return Collections.unmodifiableMap(this.properties);
    }

    public Map<String, String> getAllProperties() {
        LinkedHashMap<String, String> propValueMap = new LinkedHashMap<String, String>();
        for (Map.Entry<PropertyDescriptor, PropertyValue> entry : this.getProperties().entrySet()) {
            propValueMap.put(entry.getKey().getName(), entry.getValue().getValue());
        }
        return propValueMap;
    }

    public PropertyValue getProperty(PropertyDescriptor property) {
        return this.properties.get(property);
    }

    public String getIdentifier() {
        return this.id;
    }

    public SSLContext getSSLContext() {
        return this.sslContext;
    }

    public ComponentLog getLogger() {
        return this.logger;
    }
}

