/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller.repository.metrics;

import java.util.HashMap;
import java.util.Map;
import org.apache.nifi.controller.repository.FlowFileEvent;

public final class StandardFlowFileEvent
implements FlowFileEvent,
Cloneable {
    private int flowFilesIn;
    private int flowFilesOut;
    private int flowFilesRemoved;
    private long contentSizeIn;
    private long contentSizeOut;
    private long contentSizeRemoved;
    private long bytesRead;
    private long bytesWritten;
    private long processingNanos;
    private long cpuNanos;
    private long contentReadNanos;
    private long contentWriteNanos;
    private long sessionCommitNanos;
    private long gcMillis;
    private long aggregateLineageMillis;
    private int flowFilesReceived;
    private long bytesReceived;
    private int flowFilesSent;
    private long bytesSent;
    private int invocations;
    private Map<String, Long> counters;

    public int getFlowFilesIn() {
        return this.flowFilesIn;
    }

    public void setFlowFilesIn(int flowFilesIn) {
        this.flowFilesIn = flowFilesIn;
    }

    public int getFlowFilesOut() {
        return this.flowFilesOut;
    }

    public void setFlowFilesOut(int flowFilesOut) {
        this.flowFilesOut = flowFilesOut;
    }

    public long getContentSizeIn() {
        return this.contentSizeIn;
    }

    public void setContentSizeIn(long contentSizeIn) {
        this.contentSizeIn = contentSizeIn;
    }

    public long getContentSizeOut() {
        return this.contentSizeOut;
    }

    public void setContentSizeOut(long contentSizeOut) {
        this.contentSizeOut = contentSizeOut;
    }

    public long getContentSizeRemoved() {
        return this.contentSizeRemoved;
    }

    public void setContentSizeRemoved(long contentSizeRemoved) {
        this.contentSizeRemoved = contentSizeRemoved;
    }

    public int getFlowFilesRemoved() {
        return this.flowFilesRemoved;
    }

    public void setFlowFilesRemoved(int flowFilesRemoved) {
        this.flowFilesRemoved = flowFilesRemoved;
    }

    public long getBytesRead() {
        return this.bytesRead;
    }

    public void setBytesRead(long bytesRead) {
        this.bytesRead = bytesRead;
    }

    public long getBytesWritten() {
        return this.bytesWritten;
    }

    public void setBytesWritten(long bytesWritten) {
        this.bytesWritten = bytesWritten;
    }

    public long getProcessingNanoseconds() {
        return this.processingNanos;
    }

    public long getCpuNanoseconds() {
        return this.cpuNanos;
    }

    public void setCpuNanoseconds(long nanos) {
        this.cpuNanos = nanos;
    }

    public long getContentReadNanoseconds() {
        return this.contentReadNanos;
    }

    public void setContentReadNanoseconds(long nanos) {
        this.contentReadNanos = nanos;
    }

    public long getContentWriteNanoseconds() {
        return this.contentWriteNanos;
    }

    public void setContentWriteNanoseconds(long nanos) {
        this.contentWriteNanos = nanos;
    }

    public long getSessionCommitNanoseconds() {
        return this.sessionCommitNanos;
    }

    public void setSessionCommitNanos(long nanos) {
        this.sessionCommitNanos = nanos;
    }

    public long getGargeCollectionMillis() {
        return this.gcMillis;
    }

    public void setGarbageCollectionMillis(long gcMillis) {
        this.gcMillis = gcMillis;
    }

    public void setProcessingNanos(long processingNanos) {
        this.processingNanos = processingNanos;
    }

    public int getInvocations() {
        return this.invocations;
    }

    public void setInvocations(int invocations) {
        this.invocations = invocations;
    }

    public int getFlowFilesReceived() {
        return this.flowFilesReceived;
    }

    public void setFlowFilesReceived(int flowFilesReceived) {
        this.flowFilesReceived = flowFilesReceived;
    }

    public long getBytesReceived() {
        return this.bytesReceived;
    }

    public void setBytesReceived(long bytesReceived) {
        this.bytesReceived = bytesReceived;
    }

    public int getFlowFilesSent() {
        return this.flowFilesSent;
    }

    public void setFlowFilesSent(int flowFilesSent) {
        this.flowFilesSent = flowFilesSent;
    }

    public long getBytesSent() {
        return this.bytesSent;
    }

    public void setBytesSent(long bytesSent) {
        this.bytesSent = bytesSent;
    }

    public long getAverageLineageMillis() {
        int flowFileCount = this.flowFilesOut + this.flowFilesRemoved;
        return flowFileCount == 0 ? 0L : this.aggregateLineageMillis / (long)flowFileCount;
    }

    public void setAggregateLineageMillis(long lineageMilliseconds) {
        this.aggregateLineageMillis = lineageMilliseconds;
    }

    public long getAggregateLineageMillis() {
        return this.aggregateLineageMillis;
    }

    public Map<String, Long> getCounters() {
        return this.counters;
    }

    public void setCounters(Map<String, Long> counters) {
        this.counters = counters;
    }

    public void add(FlowFileEvent event) {
        this.flowFilesIn += event.getFlowFilesIn();
        this.flowFilesOut += event.getFlowFilesOut();
        this.flowFilesRemoved += event.getFlowFilesRemoved();
        this.contentSizeIn += event.getContentSizeIn();
        this.contentSizeOut += event.getContentSizeOut();
        this.contentSizeRemoved += event.getContentSizeRemoved();
        this.bytesRead += event.getBytesRead();
        this.bytesWritten += event.getBytesWritten();
        this.processingNanos += event.getProcessingNanoseconds();
        this.cpuNanos += event.getCpuNanoseconds();
        this.contentReadNanos += event.getContentReadNanoseconds();
        this.contentWriteNanos += event.getContentWriteNanoseconds();
        this.sessionCommitNanos += event.getSessionCommitNanoseconds();
        this.gcMillis += event.getGargeCollectionMillis();
        this.aggregateLineageMillis += event.getAggregateLineageMillis();
        this.flowFilesReceived += event.getFlowFilesReceived();
        this.bytesReceived += event.getBytesReceived();
        this.flowFilesSent += event.getFlowFilesSent();
        this.bytesSent += event.getBytesSent();
        this.invocations += event.getInvocations();
        Map eventCounters = event.getCounters();
        if (eventCounters != null) {
            if (this.counters == null) {
                this.counters = new HashMap<String, Long>();
            }
            eventCounters.forEach((k, v) -> this.counters.merge((String)k, (Long)v, Long::sum));
        }
    }
}

