/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.math;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.ScalarFunction;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.DoubleFunction;
import io.questdb.griffin.engine.functions.UnaryFunction;
import io.questdb.std.IntList;
import io.questdb.std.ObjList;

public class AsinDoubleFunctionFactory
implements FunctionFactory {
    public static final String SYMBOL = "asin";

    @Override
    public String getSignature() {
        return "asin(D)";
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) {
        return new AsinFunction(args.getQuick(0));
    }

    private static class AsinFunction
    extends DoubleFunction
    implements ScalarFunction,
    UnaryFunction {
        final Function x;

        public AsinFunction(Function x) {
            this.x = x;
        }

        @Override
        public Function getArg() {
            return this.x;
        }

        @Override
        public double getDouble(Record rec) {
            return StrictMath.asin(this.x.getDouble(rec));
        }

        @Override
        public String getName() {
            return AsinDoubleFunctionFactory.SYMBOL;
        }
    }
}

