/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo.sql;

import io.questdb.cairo.TableToken;
import io.questdb.std.FlyweightMessageContainer;
import io.questdb.std.ThreadLocal;
import io.questdb.std.str.StringSink;

public class TableReferenceOutOfDateException
extends RuntimeException
implements FlyweightMessageContainer {
    public static final int MAX_RETRY_ATTEMPS = 10;
    private static final String prefix = "cached query plan cannot be used because table schema has changed [table='";
    private static final ThreadLocal<TableReferenceOutOfDateException> tlException = new ThreadLocal<TableReferenceOutOfDateException>(TableReferenceOutOfDateException::new);
    private final StringSink message = (StringSink)new StringSink().put("cached query plan cannot be used because table schema has changed [table='");

    public static TableReferenceOutOfDateException of(CharSequence outdatedTableName) {
        TableReferenceOutOfDateException ex = tlException.get();
        assert ((ex = new TableReferenceOutOfDateException()) != null);
        ex.message.clear(prefix.length());
        ex.message.put(outdatedTableName).put("']");
        return ex;
    }

    public static TableReferenceOutOfDateException of(TableToken tableToken) {
        TableReferenceOutOfDateException ex = tlException.get();
        assert ((ex = new TableReferenceOutOfDateException()) != null);
        ex.message.clear(prefix.length());
        ex.message.put(tableToken).put("']");
        return ex;
    }

    public static TableReferenceOutOfDateException of(TableToken tableToken, int expectedTableId, int actualTableId, long expectedTableVersion, long actualTableVersion) {
        TableReferenceOutOfDateException ex = tlException.get();
        assert ((ex = new TableReferenceOutOfDateException()) != null);
        ex.message.clear(prefix.length());
        ex.message.put(tableToken).put("', expectedTableId=").put(expectedTableId).put(", actualTableId=").put(actualTableId).put(", expectedTableVersion=").put(expectedTableVersion).put(", actualTableVersion=").put(actualTableVersion).put(']');
        return ex;
    }

    @Override
    public CharSequence getFlyweightMessage() {
        return this.message;
    }

    @Override
    public String getMessage() {
        return this.message.toString();
    }
}

