/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.minifi.commons.schema;

import java.util.Map;
import java.util.TreeMap;
import org.apache.nifi.minifi.commons.schema.common.BaseSchemaWithIdAndName;
import org.apache.nifi.minifi.commons.schema.common.CommonPropertyKeys;

public class ControllerServiceSchema
extends BaseSchemaWithIdAndName {
    private Map<String, Object> properties = CommonPropertyKeys.DEFAULT_PROPERTIES;
    private String annotationData = "";
    private String serviceClass;

    public ControllerServiceSchema(Map map) {
        super(map, "Controller Service(id: {id}, name: {name})");
        String wrapperName = this.getWrapperName();
        this.serviceClass = this.getRequiredKeyAsType(map, "type", String.class, wrapperName);
        this.properties = this.getOptionalKeyAsType(map, "Properties", Map.class, wrapperName, CommonPropertyKeys.DEFAULT_PROPERTIES);
        this.annotationData = this.getOptionalKeyAsType(map, "annotation data", String.class, wrapperName, "");
    }

    @Override
    public Map<String, Object> toMap() {
        Map<String, Object> result = super.toMap();
        result.put("type", this.serviceClass);
        result.put("Properties", new TreeMap<String, Object>(this.properties));
        if (this.annotationData != null && !this.annotationData.isEmpty()) {
            result.put("annotation data", this.annotationData);
        }
        return result;
    }

    public String getAnnotationData() {
        return this.annotationData;
    }

    public String getServiceClass() {
        return this.serviceClass;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }
}

