/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.bugs;

import jpt.sun.source.tree.ExpressionTree;
import jpt.sun.source.tree.MethodInvocationTree;
import jpt.sun.source.tree.Tree;
import jpt.sun.source.util.TreePath;
import jpt30.lang.model.element.Element;
import jpt30.lang.model.element.ElementKind;
import jpt30.lang.model.element.ExecutableElement;
import jpt30.lang.model.element.TypeElement;
import jpt30.lang.model.element.VariableElement;
import jpt30.lang.model.type.ArrayType;
import jpt30.lang.model.type.TypeKind;
import jpt30.lang.model.type.TypeMirror;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.modules.java.hints.bugs.Bundle;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.Fix;
import org.netbeans.spi.java.hints.ErrorDescriptionFactory;
import org.netbeans.spi.java.hints.HintContext;

public class ConfusingVarargsParameter {
    private static final String[] EXCLUDE_CLASSES = new String[]{"java.text.MessageFormat", "java.io.PrintStream", "java.io.PrintWriter", "java.lang.String"};

    private static boolean isVarargsParameter(CompilationInfo ci, TreePath invPath) {
        if (invPath.getLeaf().getKind() != Tree.Kind.METHOD_INVOCATION) {
            return false;
        }
        MethodInvocationTree mit = (MethodInvocationTree)invPath.getLeaf();
        Element e = ci.getTrees().getElement(invPath);
        if (e == null || e.getKind() != ElementKind.METHOD) {
            return false;
        }
        ExecutableElement ee = (ExecutableElement)e;
        return ee.isVarArgs() && mit.getArguments().size() == ee.getParameters().size();
    }

    public static ErrorDescription primitiveArray(HintContext ctx) {
        TreePath invPath = ctx.getPath();
        CompilationInfo ci = ctx.getInfo();
        if (!ConfusingVarargsParameter.isVarargsParameter(ci, invPath)) {
            return null;
        }
        MethodInvocationTree mit = (MethodInvocationTree)invPath.getLeaf();
        ExpressionTree arg = mit.getArguments().get(mit.getArguments().size() - 1);
        if (arg.getKind() == Tree.Kind.NULL_LITERAL) {
            return null;
        }
        Element e = ci.getTrees().getElement(invPath);
        if (e != null) {
            TypeMirror tm;
            VariableElement var;
            TypeKind tk;
            if ((e.getKind() == ElementKind.CONSTRUCTOR || e.getKind() == ElementKind.METHOD) && (tk = (var = ((ExecutableElement)e).getParameters().get(mit.getArguments().size() - 1)).asType().getKind()) == TypeKind.ARRAY && (tm = ((ArrayType)var.asType()).getComponentType()).getKind().isPrimitive()) {
                return null;
            }
            Element ecl = e.getEnclosingElement();
            if (ecl != null && (ecl.getKind().isClass() || ecl.getKind().isInterface())) {
                TypeElement te = (TypeElement)ecl;
                String qn = te.getQualifiedName().toString();
                for (String s : EXCLUDE_CLASSES) {
                    if (!s.equals(qn)) continue;
                    return null;
                }
            }
        }
        return ErrorDescriptionFactory.forTree(ctx, mit.getArguments().get(mit.getArguments().size() - 1), Bundle.TEXT_ConfusingPrimitveArrayToVararg(), new Fix[0]);
    }
}

