/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans;

import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.lang.instrument.Instrumentation;
import java.lang.instrument.UnmodifiableClassException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.security.ProtectionDomain;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

final class NbInstrumentation
implements InvocationHandler {
    private static final Logger LOG = Logger.getLogger(NbInstrumentation.class.getName());
    private static final Object LOCK = new Object();
    private static volatile Collection<NbInstrumentation> ACTIVE;
    private final List<ClassFileTransformer> transformers = new CopyOnWriteArrayList<ClassFileTransformer>();
    private static final ThreadLocal<Boolean> IN;
    private final Instrumentation instrumentationProxy = (Instrumentation)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{Instrumentation.class}, (InvocationHandler)this);

    static NbInstrumentation registerAgent(ClassLoader l, String agentClassName) {
        try {
            return NbInstrumentation.registerImpl(agentClassName, l);
        }
        catch (Throwable ex) {
            LOG.log(Level.WARNING, "Cannot register " + agentClassName, ex);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void unregisterAgent(NbInstrumentation instr) {
        Object object = LOCK;
        synchronized (object) {
            if (ACTIVE != null) {
                Set clone = Collections.newSetFromMap(new WeakHashMap());
                clone.addAll(ACTIVE);
                clone.remove(instr);
                ACTIVE = clone;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static NbInstrumentation registerImpl(String agentClassName, ClassLoader l) throws ClassNotFoundException, IllegalArgumentException, NoSuchMethodException, SecurityException, IllegalAccessException, InvocationTargetException {
        NbInstrumentation inst = new NbInstrumentation();
        Object object = LOCK;
        synchronized (object) {
            if (ACTIVE == null) {
                ACTIVE = Collections.newSetFromMap(new WeakHashMap());
            } else {
                Set clone = Collections.newSetFromMap(new WeakHashMap());
                clone.addAll(ACTIVE);
                ACTIVE = clone;
            }
            ACTIVE.add(inst);
        }
        Class<?> agentClass = Class.forName(agentClassName, true, l);
        try {
            Method m = agentClass.getMethod("agentmain", String.class, Instrumentation.class);
            m.invoke(null, "", inst.getInstrumentationProxy());
        }
        catch (NoSuchMethodException ex) {
            Method m = agentClass.getMethod("agentmain", String.class);
            m.invoke(null, "");
        }
        return inst;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] patchByteCode(ClassLoader l, String className, ProtectionDomain pd, byte[] arr) throws IllegalClassFormatException {
        if (ACTIVE == null) {
            return arr;
        }
        if (Boolean.TRUE.equals(IN.get())) {
            return arr;
        }
        try {
            IN.set(Boolean.TRUE);
            for (NbInstrumentation inst : ACTIVE) {
                for (ClassFileTransformer t : inst.transformers) {
                    arr = t.transform(l, className, null, pd, arr);
                }
            }
        }
        finally {
            IN.set(null);
        }
        return arr;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        switch (method.getName()) {
            case "addTransformer": {
                return this.transformers.add((ClassFileTransformer)args[0]);
            }
            case "removeTransformer": {
                return this.transformers.remove(args[0]);
            }
            case "isRetransformClassesSupported": 
            case "isRedefineClassesSupported": 
            case "isModifiableClass": 
            case "isNativeMethodPrefixSupported": 
            case "isModifiableModule": {
                return false;
            }
            case "retransformClasses": 
            case "redefineClasses": {
                throw new UnmodifiableClassException();
            }
            case "getAllLoadedClasses": 
            case "getInitiatedClasses": {
                return new Class[0];
            }
            case "getObjectSize": {
                return 42;
            }
            case "appendToSystemClassLoaderSearch": 
            case "setNativeMethodPrefix": 
            case "redefineModule": {
                throw new UnsupportedOperationException();
            }
        }
        return null;
    }

    public Instrumentation getInstrumentationProxy() {
        return this.instrumentationProxy;
    }

    static {
        IN = new ThreadLocal();
    }
}

