<?xml version="1.0" encoding="UTF-8"?>
<!--
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to you under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
-->
<project xmlns="http://maven.apache.org/POM/4.0.0" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:schemaLocation="http://maven.apache.org/POM/4.0.0 http://maven.apache.org/maven-v4_0_0.xsd">

    <parent>
        <groupId>org.apache.myfaces.core</groupId>
        <artifactId>myfaces-core-project</artifactId>
        <version>4.0.0-RC5</version>
        <relativePath>../parent/pom.xml</relativePath>
    </parent>

    <modelVersion>4.0.0</modelVersion>

    <groupId>org.apache.myfaces.core</groupId>
    <artifactId>myfaces-impl</artifactId>
    <name>Apache MyFaces Core 4.0 - Impl</name>
    <description>
        The private implementation classes of the Apache MyFaces Core JSF-4.0 Implementation
    </description>
    <url>https://myfaces.apache.org/#/core40</url>

    <properties>
        <openwebbeans.version>2.0.19</openwebbeans.version>
    </properties>

    <build>

        <resources>
            <resource>
                <directory>src/main/resources</directory>
                <excludes>
                    <exclude>**/*.vm</exclude>
                </excludes>
            </resource>
        </resources>

        <plugins>

            <plugin>
                <artifactId>maven-source-plugin</artifactId>
                <executions>
                    <execution>
                        <id>attach-source</id>
                        <goals>
                            <goal>jar</goal>
                        </goals>
                    </execution>
                    <execution>
                        <id>attach-test-source</id>
                        <goals>
                            <goal>test-jar</goal>
                        </goals>
                    </execution>
                </executions>
            </plugin>

            <!-- license checker needs to exclude some kinds of files -->
            <plugin>
                <groupId>org.apache.rat</groupId>
                <artifactId>apache-rat-plugin</artifactId>
                <configuration>
                    <excludes>
                        <exclude>src/main/resources/META-INF/licenses/*-LICENSE.txt</exclude>
                        <exclude>src/main/resources/META-INF/licenses/*-LICENSE.TXT</exclude>
                        <exclude>src/main/resources/META-INF/services/**</exclude>
                        <!-- IDE Convenience  -->
                        <exclude>.vscode/**</exclude>

                        <!-- The xsd files are CDDL+GLP:
                          Category B: Reciprocal Licenses
                         "For small amounts of source that is directly consumed by the ASF product
                          at runtime in source form, and for which that source is unlikely to be
                          changed anyway (say, by virtue of being specified by a standard), this
                          action is sufficient. An example of this is the web-facesconfig_1_0.dtd,
                          whose inclusion is mandated by the JSR 127: JavaServer Faces specification."
                          http://www.apache.org/legal/3party.html
                        -->
                        <exclude>src/main/resources/org/apache/myfaces/resource/javaee_5.xsd</exclude>
                        <exclude>src/main/resources/org/apache/myfaces/resource/javaee_web_services_client_1_2.xsd</exclude>

                        <!-- This file probably needs a license, but I don't know if it's safe to put it in there -->
                        <exclude>src/test/resources/org/apache/myfaces/context/nestedScriptCDATA.xml</exclude>
                        <exclude>src/test/resources/META-INF/openwebbeans/openwebbeans.properties</exclude>
                    </excludes>
                </configuration>
            </plugin>

            <plugin>
                <groupId>org.apache.maven.plugins</groupId>
                <artifactId>maven-checkstyle-plugin</artifactId>
                <configuration>
                    <excludes>
                        org/apache/myfaces/push/WebsocketComponent.java,
                        org/apache/myfaces/push/WebsocketInit.java,
                        org/apache/myfaces/taglib/core/*,
                        org/apache/myfaces/taglib/html/*,
                        org/apache/myfaces/view/facelets/component/JsfElement.java,
                        org/apache/myfaces/webapp/WebConfigParamsLogger.java</excludes>
                </configuration>
            </plugin>

            <!-- myfaces-build-plugin - we generate a lot of stuff with this plugin (see executions) -->
            <plugin>
                <groupId>org.apache.myfaces.buildtools</groupId>
                <artifactId>myfaces-builder-plugin</artifactId>
                <executions>

                    <execution>
                        <id>makemyfacesmetadata</id>
                        <configuration>
                            <sourceDirectories>
                                <dir>${basedir}/src/main/java</dir>
                                <dir>${project.build.directory}/shared_sources</dir>
                            </sourceDirectories>
                        </configuration>
                        <goals>
                            <goal>build-metadata</goal>
                        </goals>
                    </execution>

                    <execution>
                        <id>makeWebConfigParamsLogger</id>
                        <configuration>
                            <templateFile>WebConfigParamsLogger.vm</templateFile>
                            <outputDirectory>${project.build.directory}/generated-sources/myfaces-builder-plugin</outputDirectory>
                            <xmlFile>org/apache/myfaces/webapp/WebConfigParamsLogger.java</xmlFile>
                            <modelIds>
                                <modelId>myfaces-api</modelId>
                                <modelId>myfaces-impl</modelId>
                            </modelIds>
                        </configuration>
                        <goals>
                            <goal>make-config</goal>
                        </goals>
                    </execution>

                    <execution>
                        <id>makefacesconfig</id>
                        <configuration>
                            <templateFile>faces-config20.vm</templateFile>
                            <xmlFile>META-INF/standard-faces-config.xml</xmlFile>
                            <xmlBaseFile>src/main/conf/META-INF/standard-faces-config-base.xml</xmlBaseFile>
                            <modelIds>
                                <modelId>myfaces-api</modelId>
                                <modelId>myfaces-impl</modelId>
                            </modelIds>
                        </configuration>
                        <goals>
                            <goal>make-config</goal>
                        </goals>
                    </execution>
                    <execution>
                        <id>makecomp</id>
                        <configuration>
                            <jsfVersion>20</jsfVersion>
                            <templateComponentName>componentClass20.vm</templateComponentName>
                        </configuration>
                        <goals>
                            <goal>make-components</goal>
                        </goals>
                    </execution>

                    <!--
                        To generate facelet taglib doc we need to create alternate facelets files
                        so taglibdoc goal can extract the required information and create html files.
                        We put this one here temporally but generate-assembly profile should trigger
                        this execution tasks too.
                    -->
                    <execution>
                        <id>make_core_facelet_tld</id>
                        <configuration>
                            <outputDirectory>${project.build.directory}/tlddoc-facelets</outputDirectory>
                            <xmlFile>myfaces_facelets_core.tld</xmlFile>
                            <templateFile>myfaces_facelet_core20.vm</templateFile>
                            <modelIds>
                                <modelId>myfaces-api</modelId>
                                <modelId>myfaces-impl</modelId>
                            </modelIds>
                            <params>
                                <shortname>f</shortname>
                                <uri>http://java.sun.com/jsf/core</uri>
                                <displayname>JSF Core Facelets Tag Library.</displayname>
                                <description>This tag library implements the standard JSF core tags for Facelets.</description>
                            </params>
                        </configuration>
                        <goals>
                            <goal>make-config</goal>
                        </goals>
                    </execution>

                    <execution>
                        <id>make_html_facelet_tld</id>
                        <configuration>
                            <outputDirectory>${project.build.directory}/tlddoc-facelets</outputDirectory>
                            <xmlFile>myfaces_facelets_html.tld</xmlFile>
                            <xmlBaseFile>src/main/conf/META-INF/myfaces_html-base.tld</xmlBaseFile>
                            <templateFile>myfaces_facelet_html20.vm</templateFile>
                            <modelIds>
                                <modelId>myfaces-api</modelId>
                                <modelId>myfaces-impl</modelId>
                            </modelIds>
                            <params>
                                <shortname>h</shortname>
                                <uri>http://java.sun.com/jsf/html</uri>
                                <displayname>JSF HTML Facelets Tag Library.</displayname>
                                <description>This tag library implements the standard JSF HTML tags for Facelets.</description>
                            </params>
                        </configuration>
                        <goals>
                            <goal>make-config</goal>
                        </goals>
                    </execution>

                    <execution>
                        <id>make_c_facelet_tld</id>
                        <configuration>
                            <outputDirectory>${project.build.directory}/tlddoc-facelets</outputDirectory>
                            <xmlFile>myfaces_facelets_c.tld</xmlFile>
                            <xmlBaseFile>src/main/conf/META-INF/myfaces_html-base.tld</xmlBaseFile>
                            <templateFile>myfaces_facelet_html20.vm</templateFile>
                            <modelIds>
                                <modelId>myfaces-api</modelId>
                                <modelId>myfaces-impl</modelId>
                            </modelIds>
                            <params>
                                <shortname>c</shortname>
                                <uri>http://java.sun.com/jsp/jstl/core</uri>
                                <displayname>JSTL core Facelets Tag Library.</displayname>
                                <description>JSTL core Facelets Tag Library.</description>
                            </params>
                        </configuration>
                        <goals>
                            <goal>make-config</goal>
                        </goals>
                    </execution>

                    <execution>
                        <id>make_ui_facelet_tld</id>
                        <configuration>
                            <outputDirectory>${project.build.directory}/tlddoc-facelets</outputDirectory>
                            <xmlFile>myfaces_facelets_ui.tld</xmlFile>
                            <xmlBaseFile>src/main/conf/META-INF/myfaces_ui-base.tld</xmlBaseFile>
                            <templateFile>myfaces_facelet_html20.vm</templateFile>
                            <modelIds>
                                <modelId>myfaces-api</modelId>
                                <modelId>myfaces-impl</modelId>
                            </modelIds>
                            <params>
                                <shortname>ui</shortname>
                                <uri>http://java.sun.com/jsf/facelets</uri>
                                <displayname>JSF UI Facelets Tag Library.</displayname>
                                <description>JSF UI Facelets Tag Library.</description>
                            </params>
                        </configuration>
                        <goals>
                            <goal>make-config</goal>
                        </goals>
                    </execution>

                    <execution>
                        <id>make_composite_facelet_tld</id>
                        <configuration>
                            <outputDirectory>${project.build.directory}/tlddoc-facelets</outputDirectory>
                            <xmlFile>myfaces_facelets_composite.tld</xmlFile>
                            <xmlBaseFile>src/main/conf/META-INF/myfaces_html-base.tld</xmlBaseFile>
                            <templateFile>myfaces_facelet_html20.vm</templateFile>
                            <modelIds>
                                <modelId>myfaces-api</modelId>
                                <modelId>myfaces-impl</modelId>
                            </modelIds>
                            <params>
                                <shortname>composite</shortname>
                                <uri>http://java.sun.com/jsf/composite</uri>
                                <displayname>JSF Composite Facelets Tag Library.</displayname>
                                <description>JSF Composite Facelets Tag Library.</description>
                            </params>
                        </configuration>
                        <goals>
                            <goal>make-config</goal>
                        </goals>
                    </execution>

                    <execution>
                        <id>make_fn_facelet_tld</id>
                        <configuration>
                            <outputDirectory>${project.build.directory}/tlddoc-facelets</outputDirectory>
                            <xmlFile>myfaces_facelet_fn.tld</xmlFile>
                            <templateFile>myfaces_facelet_html20.vm</templateFile>
                            <modelIds>
                                <modelId>myfaces-api</modelId>
                                <modelId>myfaces-impl</modelId>
                            </modelIds>
                            <params>
                                <shortname>fn</shortname>
                                <uri>http://java.sun.com/jsp/jstl/functions</uri>
                                <displayname>JSTL Facelets Function Library.</displayname>
                                <description>JSTL Facelets Function Library.</description>
                            </params>
                        </configuration>
                        <goals>
                            <goal>make-config</goal>
                        </goals>
                    </execution>

                    <!-- START XSD GENERATION -->

                    <execution>
                        <id>make_core_facelet_xsd</id>
                        <configuration>
                            <xmlFile>META-INF/schema/myfaces_facelets_core_2_1.xsd</xmlFile>
                            <templateFile>myfaces_facelet_core20_xsd.vm</templateFile>
                            <modelIds>
                                <modelId>myfaces-api</modelId>
                                <modelId>myfaces-impl</modelId>
                            </modelIds>
                            <params>
                                <shortname>f</shortname>
                                <uri>http://java.sun.com/jsf/core</uri>
                                <displayname>JSF Core Facelets Tag Library.</displayname>
                                <tlibversion>2.1</tlibversion>
                                <description>This tag library implements the standard JSF core tags for Facelets.</description>
                            </params>
                        </configuration>
                        <goals>
                            <goal>make-config</goal>
                        </goals>
                    </execution>

                    <execution>
                        <id>make_html_facelet_xsd</id>
                        <configuration>
                            <xmlFile>META-INF/schema/myfaces_facelets_html_2_1.xsd</xmlFile>
                            <templateFile>myfaces_facelet_html20_xsd.vm</templateFile>
                            <modelIds>
                                <modelId>myfaces-api</modelId>
                                <modelId>myfaces-impl</modelId>
                            </modelIds>
                            <params>
                                <shortname>h</shortname>
                                <uri>http://java.sun.com/jsf/html</uri>
                                <displayname>JSF HTML Facelets Tag Library.</displayname>
                                <description>This tag library implements the standard JSF HTML tags for Facelets.</description>
                            </params>
                        </configuration>
                        <goals>
                            <goal>make-config</goal>
                        </goals>
                    </execution>

                    <execution>
                        <id>make_c_facelet_xsd</id>
                        <configuration>
                            <xmlFile>META-INF/schema/myfaces_facelets_c_2_1.xsd</xmlFile>
                            <templateFile>myfaces_facelet_html20_xsd.vm</templateFile>
                            <modelIds>
                                <modelId>myfaces-api</modelId>
                                <modelId>myfaces-impl</modelId>
                            </modelIds>
                            <params>
                                <shortname>c</shortname>
                                <uri>http://java.sun.com/jsp/jstl/core</uri>
                                <displayname>JSTL core Facelets Tag Library.</displayname>
                                <description>JSTL core Facelets Tag Library.</description>
                            </params>
                        </configuration>
                        <goals>
                            <goal>make-config</goal>
                        </goals>
                    </execution>

                    <execution>
                        <id>make_ui_facelet_xsd</id>
                        <configuration>
                            <xmlFile>META-INF/schema/myfaces_facelets_ui_2_1.xsd</xmlFile>
                            <templateFile>myfaces_facelet_html20_xsd.vm</templateFile>
                            <modelIds>
                                <modelId>myfaces-api</modelId>
                                <modelId>myfaces-impl</modelId>
                            </modelIds>
                            <params>
                                <shortname>ui</shortname>
                                <uri>http://java.sun.com/jsf/facelets</uri>
                                <displayname>JSF UI Facelets Tag Library.</displayname>
                                <description>JSF UI Facelets Tag Library.</description>
                            </params>
                        </configuration>
                        <goals>
                            <goal>make-config</goal>
                        </goals>
                    </execution>

                    <execution>
                        <id>make_composite_facelet_xsd</id>
                        <configuration>
                            <xmlFile>META-INF/schema/myfaces_facelets_composite_2_1.xsd</xmlFile>
                            <templateFile>myfaces_facelet_html20_xsd.vm</templateFile>
                            <modelIds>
                                <modelId>myfaces-api</modelId>
                                <modelId>myfaces-impl</modelId>
                            </modelIds>
                            <params>
                                <shortname>composite</shortname>
                                <uri>http://java.sun.com/jsf/composite</uri>
                                <displayname>JSF Composite Facelets Tag Library.</displayname>
                                <description>JSF Composite Facelets Tag Library.</description>
                            </params>
                        </configuration>
                        <goals>
                            <goal>make-config</goal>
                        </goals>
                    </execution>

                    <execution>
                        <id>make_core_facelet_xsd22</id>
                        <configuration>
                            <xmlFile>META-INF/schema/myfaces_facelets_core_2_2.xsd</xmlFile>
                            <templateFile>myfaces_facelet_core20_xsd.vm</templateFile>
                            <modelIds>
                                <modelId>myfaces-api</modelId>
                                <modelId>myfaces-impl</modelId>
                            </modelIds>
                            <params>
                                <shortname>f</shortname>
                                <uri>http://xmlns.jcp.org/jsf/core</uri>
                                <displayname>JSF Core Facelets Tag Library.</displayname>
                                <tlibversion>2.2</tlibversion>
                                <description>This tag library implements the standard JSF core tags for Facelets.</description>
                            </params>
                        </configuration>
                        <goals>
                            <goal>make-config</goal>
                        </goals>
                    </execution>

                    <execution>
                        <id>make_html_facelet_xsd22</id>
                        <configuration>
                            <xmlFile>META-INF/schema/myfaces_facelets_html_2_2.xsd</xmlFile>
                            <templateFile>myfaces_facelet_html20_xsd.vm</templateFile>
                            <modelIds>
                                <modelId>myfaces-api</modelId>
                                <modelId>myfaces-impl</modelId>
                            </modelIds>
                            <params>
                                <shortname>h</shortname>
                                <uri>http://xmlns.jcp.org/jsf/html</uri>
                                <displayname>JSF HTML Facelets Tag Library.</displayname>
                                <description>This tag library implements the standard JSF HTML tags for Facelets.</description>
                            </params>
                        </configuration>
                        <goals>
                            <goal>make-config</goal>
                        </goals>
                    </execution>

                    <execution>
                        <id>make_c_facelet_xsd22</id>
                        <configuration>
                            <xmlFile>META-INF/schema/myfaces_facelets_c_2_2.xsd</xmlFile>
                            <templateFile>myfaces_facelet_html20_xsd.vm</templateFile>
                            <modelIds>
                                <modelId>myfaces-api</modelId>
                                <modelId>myfaces-impl</modelId>
                            </modelIds>
                            <params>
                                <shortname>c</shortname>
                                <uri>http://xmlns.jcp.org/jsp/jstl/core</uri>
                                <displayname>JSTL core Facelets Tag Library.</displayname>
                                <description>JSTL core Facelets Tag Library.</description>
                            </params>
                        </configuration>
                        <goals>
                            <goal>make-config</goal>
                        </goals>
                    </execution>

                    <execution>
                        <id>make_ui_facelet_xsd22</id>
                        <configuration>
                            <xmlFile>META-INF/schema/myfaces_facelets_ui_2_2.xsd</xmlFile>
                            <templateFile>myfaces_facelet_html20_xsd.vm</templateFile>
                            <modelIds>
                                <modelId>myfaces-api</modelId>
                                <modelId>myfaces-impl</modelId>
                            </modelIds>
                            <params>
                                <shortname>ui</shortname>
                                <uri>http://xmlns.jcp.org/jsf/facelets</uri>
                                <displayname>JSF UI Facelets Tag Library.</displayname>
                                <description>JSF UI Facelets Tag Library.</description>
                            </params>
                        </configuration>
                        <goals>
                            <goal>make-config</goal>
                        </goals>
                    </execution>

                    <execution>
                        <id>make_composite_facelet_xsd22</id>
                        <configuration>
                            <xmlFile>META-INF/schema/myfaces_facelets_composite_2_2.xsd</xmlFile>
                            <templateFile>myfaces_facelet_html20_xsd.vm</templateFile>
                            <modelIds>
                                <modelId>myfaces-api</modelId>
                                <modelId>myfaces-impl</modelId>
                            </modelIds>
                            <params>
                                <shortname>composite</shortname>
                                <uri>http://xmlns.jcp.org/jsf/composite</uri>
                                <displayname>JSF Composite Facelets Tag Library.</displayname>
                                <description>JSF Composite Facelets Tag Library.</description>
                            </params>
                        </configuration>
                        <goals>
                            <goal>make-config</goal>
                        </goals>
                    </execution>

                    <!-- END XSD GENERATION -->
                </executions>
            </plugin>



            <plugin>
                <artifactId>maven-jar-plugin</artifactId>
                <version>2.2</version>
                <configuration>
                    <archive>
                        <manifestFile>${project.build.outputDirectory}/META-INF/MANIFEST.MF</manifestFile>
                    </archive>
                </configuration>
                <!-- generate a -tests.jar too -->
                <executions>
                    <execution>
                        <goals>
                            <goal>test-jar</goal>
                        </goals>
                    </execution>
                </executions>

            </plugin>

            <!-- run test-cases -->
            <plugin>
                <artifactId>maven-surefire-plugin</artifactId>
                <configuration>
                    <trimStackTrace>false</trimStackTrace>
                    <excludes>
                        <exclude>**/DefaultViewHandlerSupportTest*</exclude>
                        <exclude>**/ApplicationImplTest*</exclude>
                        <exclude>**/FactoryFinderProviderTest*</exclude>
                    </excludes>
                    <systemProperties>
                        <!--
                        Java 9 introduce CLDR locales as defaults
                        some tests however fail because the local
                        checks follow the java conventions.
                        Setting it to provider should enable locale behavior
                        across all supported JDKs
                        -->
                        <property>
                            <name>java.locale.providers</name>
                            <value>COMPAT</value>
                        </property>
                    </systemProperties>
                    <argLine>-Djava.locale.providers=COMPAT</argLine>
                </configuration>

                <executions>
                    <execution>
                        <id>isolateCLTests</id>
                        <phase>test</phase>
                        <goals>
                            <goal>test</goal>
                        </goals>
                        <configuration>
                            <!-- <forkMode>always</forkMode> -->
                            <forkCount>1</forkCount>
                            <reuseForks>false</reuseForks>
                            <includes>
                                <include>**/FactoryFinderProviderTest*</include>
                            </includes>
                            <excludes>
                                <exclude>**/JspStateManagerImplTest*</exclude>
                                <exclude>**/DefaultViewHandlerSupportTest*</exclude>
                                <exclude>**/ApplicationImplTest*</exclude>
                            </excludes>
                        </configuration>
                    </execution>
                </executions>
            </plugin>

            <!-- create OSGI-ready manifest.mf -->
            <plugin>
                <groupId>org.apache.felix</groupId>
                <artifactId>maven-bundle-plugin</artifactId>
                <executions>
                    <execution>
                        <id>bundle-manifest</id>
                        <phase>process-classes</phase>
                        <goals>
                            <goal>manifest</goal>
                        </goals>
                        <configuration>
                            <instructions>
                                <Bundle-SymbolicName>org.apache.myfaces.core.impl</Bundle-SymbolicName>
                                <Bundle-Classpath>.</Bundle-Classpath>
                                <Build-Jdk>${java.version}</Build-Jdk>
                                <Implementation-Title>${project.name}</Implementation-Title>
                                <Implementation-Version>${project.version}</Implementation-Version>
                                <Implementation-Vendor>The Apache Software Foundation</Implementation-Vendor>
                                <Implementation-Vendor-Id>${project.groupId}</Implementation-Vendor-Id>
                                <Export-Package>
                                    *;version="${project.version}"
                                </Export-Package>
                                <Import-Package>
                                    !org.apache.myfaces.*,
                                    jakarta.annotation;version="[2.1.0, 3.0.0)",
                                    javax.crypto,
                                    javax.crypto.spec,
                                    jakarta.ejb;version="[4.0.0, 5.0.0)";resolution:=optional,
                                    jakarta.el;version="[5.0.0, 6.0.0)",
                                    javax.naming,
                                    jakarta.persistence;version="[3.1.0, 4.0.0)";resolution:=optional,
                                    javax.portlet;version="[1.0.0, 2.1)";resolution:=optional,
                                    jakarta.servlet;version="[6.0.0, 7.0.0)",
                                    jakarta.servlet.http;version="[6.0.0, 7.0.0)",
                                    jakarta.servlet.annotation;version="[6.0.0, 7.0.0)";resolution:=optional,
                                    javax.xml.parsers,
                                    org.apache;resolution:=optional,
                                    org.w3c.dom,
                                    org.xml.sax,
                                    org.xml.sax.helpers,
                                    org.apache.jasper.compiler;resolution:=optional,
                                    org.apache.jasper.el;resolution:=optional,
                                    org.apache.el;resolution:=optional,
                                    org.apache.tomcat;resolution:=optional,
                                    jakarta.faces.*;version="${project.version}",
                                    *
                                </Import-Package>
                            </instructions>
                        </configuration>
                    </execution>
                </executions>
            </plugin>

        </plugins>

    </build>


    <profiles>

        <!--
          - Whenever the full website is generated, the command
          -   mvn -Pgenerate-site -Pgenerate-tlddoc site
          - should be used. This will create the "tlddoc" directory containing
          - nicely-formatted versions of the docs in the jsp taglib file, ie
          - docs on all the available tags and their properties.
        -->
        <profile>
            <id>generate-site</id>
            <build>
                <plugins>

                    <!-- Generate content for custom tagdoc report -->
                    <plugin>
                        <groupId>org.apache.myfaces.buildtools</groupId>
                        <artifactId>myfaces-builder-plugin</artifactId>
                        <executions>

                            <execution>
                                <id>site-tagdoc-content</id>
                                <configuration>
                                    <modelIds>
                                        <modelId>myfaces-api</modelId>
                                        <modelId>myfaces-impl</modelId>
                                    </modelIds>
                                    <taglibs>
                                        <f>http://xmlns.jcp.org/jsf/core</f>
                                        <h>http://xmlns.jcp.org/jsf/html</h>
                                        <ui>http://xmlns.jcp.org/jsf/facelets</ui>
                                        <c>http://xmlns.jcp.org/jsp/jstl/core</c>
                                        <fn>http://xmlns.jcp.org/jsp/jstl/functions</fn>
                                    </taglibs>
                                </configuration>
                                <goals>
                                    <goal>tagdoc-content</goal>
                                </goals>
                            </execution>

                            <execution>
                                <id>site-web-config</id>
                                <configuration>
                                    <templateFile>xdoc-web-config.vm</templateFile>
                                    <outputDirectory>${project.build.directory}/generated-site/xdoc</outputDirectory>
                                    <xmlFile>webconfig.xml</xmlFile>
                                    <modelIds>
                                        <modelId>myfaces-api</modelId>
                                        <modelId>myfaces-impl</modelId>
                                    </modelIds>
                                </configuration>
                                <goals>
                                    <goal>make-config</goal>
                                </goals>
                            </execution>

                        </executions>
                    </plugin>

                    <!--
                        Unfortunately we can't execute the same report twice, so
                        we have to generate this files outside report generation.
                    -->
                    <plugin>
                        <groupId>net.sourceforge.maven-taglib</groupId>
                        <artifactId>maven-taglib-plugin</artifactId>
                        <version>2.4</version>
                        <executions>

                            <execution>
                                <id>tlddoc-facelets</id>
                                <phase>site</phase>
                                <goals>
                                    <goal>taglibdoc</goal>
                                </goals>
                                <inherited>false</inherited>
                                <configuration>
                                    <title>${project.name} Tag library documentation for Facelets</title>
                                    <srcDir>${basedir}/target/tlddoc-facelets</srcDir>
                                    <tldDocDir>${basedir}/target/site/tlddoc-facelets</tldDocDir>
                                </configuration>
                            </execution>

                            <execution>
                                <id>tlddoc-jsp</id>
                                <phase>site</phase>
                                <goals>
                                    <goal>taglibdoc</goal>
                                </goals>
                                <inherited>false</inherited>
                                <configuration>
                                    <taglib.src.dir>${basedir}/target/classes/META-INF</taglib.src.dir>
                                    <tldDocDir>${basedir}/target/site/tlddoc</tldDocDir>
                                </configuration>
                            </execution>

                        </executions>
                    </plugin>

                </plugins>
            </build>

            <reporting>
                <plugins>
                    <plugin>
                        <groupId>net.sourceforge.maven-taglib</groupId>
                        <artifactId>maven-taglib-plugin</artifactId>
                        <version>2.4</version>
                        <configuration>
                            <taglib.src.dir>${basedir}/target/classes/META-INF</taglib.src.dir>
                            <tldDocDir>${basedir}/target/site/tlddoc</tldDocDir>
                        </configuration>
                    </plugin>

                    <!-- trigger tagdoc-index report -->
                    <plugin>
                        <groupId>org.apache.myfaces.buildtools</groupId>
                        <artifactId>myfaces-builder-plugin</artifactId>
                        <reportSets>
                            <reportSet>
                                <configuration>
                                    <modelIds>
                                        <modelId>myfaces-api</modelId>
                                        <modelId>myfaces-impl</modelId>
                                    </modelIds>
                                    <taglibs>
                                        <f>http://xmlns.jcp.org/jsf/core</f>
                                        <h>http://xmlns.jcp.org/jsf/html</h>
                                        <ui>http://xmlns.jcp.org/jsf/facelets</ui>
                                        <c>http://xmlns.jcp.org/jsp/jstl/core</c>
                                        <fn>http://xmlns.jcp.org/jsp/jstl/functions</fn>
                                    </taglibs>
                                </configuration>
                                <reports>
                                    <report>tagdoc-index</report>
                                </reports>
                            </reportSet>
                        </reportSets>
                    </plugin>
                </plugins>
            </reporting>
        </profile>

        <!--
          - Whenever files are deployed to a snapshot or release repository,
          -   mvn -Pgenerate-assembly deploy
          - should be used. This will create additional artifacts that are
          - useful but too time-consuming to create when just doing a local
          - "mvn install" operation.
        -->
        <profile>
            <id>generate-assembly</id>
            <activation>
                <property>
                    <name>performRelease</name>
                    <value>true</value>
                </property>
            </activation>
            <build>
                <plugins>
                    <plugin>
                        <groupId>org.apache.maven.plugins</groupId>
                        <artifactId>maven-javadoc-plugin</artifactId>
                        <executions>
                            <execution>
                                <id>attach-javadoc</id>
                                <goals>
                                    <goal>jar</goal>
                                </goals>
                            </execution>
                        </executions>
                    </plugin>

                    <plugin>
                        <groupId>net.sourceforge.maven-taglib</groupId>
                        <artifactId>maven-taglib-plugin</artifactId>
                        <version>2.4</version>
                        <executions>
                            <execution>
                                <id>tlddoc-facelets</id>
                                <!--
                                    TODO: The phase value should be "site", but since we are not released yet
                                    and this documentation is used to implement jsf 2.0, we put this one
                                    on site so just doing mvn -Pgenerate-site install we can create this
                                    javadoc
                                -->
                                <phase>process-resources</phase>
                                <goals>
                                    <goal>taglibdoc</goal>
                                </goals>
                                <inherited>false</inherited>
                                <configuration>
                                    <title>${project.name} Tag library documentation for Facelets</title>
                                    <srcDir>${basedir}/target/tlddoc-facelets</srcDir>
                                    <tldDocDir>${basedir}/target/site/tlddoc-facelets</tldDocDir>
                                </configuration>
                            </execution>

                            <execution>
                                <id>tlddoc-jsp</id>
                                <phase>process-resources</phase>
                                <goals>
                                    <goal>taglibdoc</goal>
                                </goals>
                                <inherited>false</inherited>
                                <configuration>
                                    <taglib.src.dir>${basedir}/target/classes/META-INF</taglib.src.dir>
                                    <tldDocDir>${basedir}/target/site/tlddoc</tldDocDir>
                                </configuration>
                            </execution>

                            <execution>
                                <id>attach-tlddoc</id>
                                <goals>
                                    <goal>taglibdocjar</goal>
                                </goals>
                                <configuration>
                                    <tldDocDir>${basedir}/target/site/tlddoc</tldDocDir>
                                </configuration>
                            </execution>

                            <execution>
                                <id>attach-tlddoc-facelets</id>
                                <goals>
                                    <goal>taglibdocjar</goal>
                                </goals>
                                <configuration>
                                    <attach>false</attach>
                                    <tldDocDir>${basedir}/target/site/tlddoc-facelets</tldDocDir>
                                    <tlddocJar>${basedir}/target/${project.artifactId}-${project.version}-facelets-tlddoc.jar</tlddocJar>
                                </configuration>
                            </execution>

                        </executions>
                    </plugin>

                    <plugin>
                        <groupId>org.codehaus.mojo</groupId>
                        <artifactId>build-helper-maven-plugin</artifactId>
                        <executions>
                            <execution>
                                <id>attach-artifacts</id>
                                <phase>package</phase>
                                <goals>
                                    <goal>attach-artifact</goal>
                                </goals>
                                <configuration>
                                    <artifacts>
                                        <artifact>
                                            <file>${basedir}/target/${project.artifactId}-${project.version}-facelets-tlddoc.jar</file>
                                            <type>jar</type>
                                            <classifier>facelets-tlddoc</classifier>
                                        </artifact>
                                    </artifacts>
                                </configuration>
                            </execution>
                        </executions>
                    </plugin>

                </plugins>
            </build>
        </profile>

    </profiles>


    <dependencies>
        <dependency>
            <groupId>org.apache.myfaces.core</groupId>
            <artifactId>myfaces-api</artifactId>
            <version>${project.version}</version>
        </dependency>
        <dependency>
            <groupId>org.apache.myfaces.core</groupId>
            <artifactId>myfaces-test</artifactId>
            <version>${project.version}</version>
            <scope>test</scope>
        </dependency>

        <!-- Java EE APIs -->
        <dependency>
            <groupId>org.apache.tomcat</groupId>
            <artifactId>tomcat-servlet-api</artifactId>
        </dependency>
        <dependency>
            <groupId>org.apache.tomcat</groupId>
            <artifactId>tomcat-websocket-api</artifactId>
        </dependency>
        <dependency>
            <groupId>org.apache.tomcat</groupId>
            <artifactId>tomcat-el-api</artifactId>
        </dependency>
        
        <dependency>
            <groupId>jakarta.validation</groupId>
            <artifactId>jakarta.validation-api</artifactId>
            <optional>true</optional>
        </dependency>
        <dependency>
            <groupId>org.apache.geronimo.specs</groupId>
            <artifactId>geronimo-annotation_1.3_spec</artifactId>
            <classifier>jakarta</classifier>
        </dependency>
        <dependency>
            <groupId>jakarta.persistence</groupId>
            <artifactId>jakarta.persistence-api</artifactId>
            <version>3.0.0-RC2</version>
            <optional>true</optional> <!-- optional does not completely work in dependencyManagement (MNG-1630) -->
        </dependency>
        <dependency>
            <groupId>jakarta.ejb</groupId>
            <artifactId>jakarta.ejb-api</artifactId>
            <optional>true</optional> <!-- optional does not completely work in dependencyManagement (MNG-1630) -->
        </dependency>
        <dependency>
            <groupId>org.apache.geronimo.specs</groupId>
            <artifactId>geronimo-jcdi_2.0_spec</artifactId>
            <classifier>jakarta</classifier>
        </dependency>
        <dependency>
            <groupId>org.apache.geronimo.specs</groupId>
            <artifactId>geronimo-atinject_1.0_spec</artifactId>
            <classifier>jakarta</classifier>
        </dependency>

        <!-- builder-annotations like @JSFWebConfigParam -->
        <dependency>
            <groupId>org.apache.myfaces.buildtools</groupId>
            <artifactId>myfaces-builder-annotations</artifactId>
        </dependency>

        <!-- tomcat 7 support (InjectionProvider) -->
        <dependency>
            <groupId>org.apache.tomcat</groupId>
            <artifactId>tomcat-catalina</artifactId>
        </dependency>

        <dependency>
            <groupId>org.junit.jupiter</groupId>
            <artifactId>junit-jupiter-api</artifactId>
        </dependency>

        <!-- easymock -->
        <dependency>
            <groupId>org.easymock</groupId>
            <artifactId>easymock</artifactId>
        </dependency>
        <dependency>
            <groupId>org.easymock</groupId>
            <artifactId>easymockclassextension</artifactId>
        </dependency>

        <dependency>
            <groupId>org.mockito</groupId>
            <artifactId>mockito-core</artifactId>
        </dependency>


        <!-- We need a real EL implementation for test ui:param tag,
        because myfaces-test MockExpressionFactory is not designed to
        handle VariableMapper stuff (see IncludeParamTestCase).-->
        <dependency>
            <groupId>org.apache.tomcat</groupId>
            <artifactId>tomcat-jasper-el</artifactId>
            <version>10.0.27</version>
            <scope>test</scope>
        </dependency>

        <!-- Openwebbeans for CDI Test -->
        <dependency>
            <groupId>org.apache.geronimo.specs</groupId>
            <artifactId>geronimo-interceptor_1.2_spec</artifactId>
            <version>1.2</version>
            <scope>test</scope>
            <classifier>jakarta</classifier>
        </dependency>
       <dependency>
            <groupId>org.apache.openwebbeans</groupId>
            <artifactId>openwebbeans-impl</artifactId>
            <version>${openwebbeans.version}</version>
            <scope>test</scope>
            <classifier>jakarta</classifier>
            <exclusions>
                <exclusion>
                    <groupId>org.apache.openwebbeans</groupId>
                    <artifactId>*</artifactId>
                </exclusion>
                <exclusion>
                    <groupId>org.apache.geronimo.specs</groupId>
                    <artifactId>*</artifactId>
                </exclusion>
            </exclusions>
        </dependency>
        <dependency>
            <groupId>org.apache.openwebbeans</groupId>
            <artifactId>openwebbeans-web</artifactId>
            <version>${openwebbeans.version}</version>
            <scope>test</scope>
            <classifier>jakarta</classifier>
            <exclusions>
                <exclusion>
                    <groupId>org.apache.openwebbeans</groupId>
                    <artifactId>*</artifactId>
                </exclusion>
                <exclusion>
                    <groupId>org.apache.geronimo.specs</groupId>
                    <artifactId>*</artifactId>
                </exclusion>
            </exclusions>
        </dependency>
        <dependency>
            <groupId>org.apache.openwebbeans</groupId>
            <artifactId>openwebbeans-spi</artifactId>
            <version>${openwebbeans.version}</version>
            <scope>test</scope>
            <classifier>jakarta</classifier>
            <exclusions>
                <exclusion>
                    <groupId>org.apache.openwebbeans</groupId>
                    <artifactId>*</artifactId>
                </exclusion>
                <exclusion>
                    <groupId>org.apache.geronimo.specs</groupId>
                    <artifactId>*</artifactId>
                </exclusion>
            </exclusions>
        </dependency>
        <dependency>
            <groupId>org.apache.openwebbeans</groupId>
            <artifactId>openwebbeans-resource</artifactId>
            <version>${openwebbeans.version}</version>
            <scope>test</scope>
            <classifier>jakarta</classifier>
            <exclusions>
                <exclusion>
                    <groupId>org.apache.openwebbeans</groupId>
                    <artifactId>*</artifactId>
                </exclusion>
                <exclusion>
                    <groupId>org.apache.geronimo.specs</groupId>
                    <artifactId>*</artifactId>
                </exclusion>
            </exclusions>
        </dependency>
        <dependency>
            <groupId>org.apache.openwebbeans</groupId>
            <artifactId>openwebbeans-el22</artifactId>
            <version>${openwebbeans.version}</version>
            <scope>test</scope>
            <classifier>jakarta</classifier>
            <exclusions>
                <exclusion>
                    <groupId>org.apache.openwebbeans</groupId>
                    <artifactId>*</artifactId>
                </exclusion>
                <exclusion>
                    <groupId>org.apache.geronimo.specs</groupId>
                    <artifactId>*</artifactId>
                </exclusion>
            </exclusions>
        </dependency>

        <dependency>
            <groupId>org.apache.bval</groupId>
            <artifactId>bval-jsr</artifactId>
            <version>2.0.4</version>
            <scope>test</scope>
            <classifier>jakarta</classifier>
        </dependency>
        <dependency>
            <groupId>jakarta.xml.bind</groupId>
            <artifactId>jakarta.xml.bind-api</artifactId>
            <version>4.0.0</version>
            <scope>test</scope>
        </dependency>

    </dependencies>


    <reporting>
        <plugins>
            <plugin>
                <artifactId>maven-changelog-plugin</artifactId>
                <reportSets>
                    <reportSet>
                        <id>dual-report</id>
                        <configuration>
                            <type>range</type>
                            <range>30</range>
                        </configuration>
                        <reports>
                            <report>changelog</report>
                            <report>file-activity</report>
                            <report>dev-activity</report>
                        </reports>
                    </reportSet>
                </reportSets>
            </plugin>

            <plugin>
                <artifactId>maven-jxr-plugin</artifactId>
            </plugin>

            <plugin>
                <artifactId>maven-surefire-report-plugin</artifactId>
            </plugin>

            <plugin>
                <groupId>org.codehaus.mojo</groupId>
                <artifactId>taglist-maven-plugin</artifactId>
            </plugin>

        </plugins>
    </reporting>

</project>
