/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.config.xmlHttp;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Writer;
import javax.servlet.ServletOutputStream;

final class XmlOutput {
    private boolean _strip = true;
    private int _searchIndex = 0;
    private final PrintWriter _baseWriter;
    private final PrintStream _baseStream;
    private static final String _XML_STR = "<?xml ";

    XmlOutput(PrintWriter writer) {
        this._baseWriter = writer;
        this._baseStream = null;
    }

    public XmlOutput(OutputStream out) {
        this._baseWriter = null;
        this._baseStream = new PrintStream(out);
    }

    public ServletOutputStream getOutputStream() {
        assert (this._baseStream != null);
        return new ServletOutputStream(){

            public void write(int b) throws IOException {
                byte[] bs = new byte[]{(byte)b};
                this.write(bs);
            }

            public void close() throws IOException {
                XmlOutput.this._baseStream.close();
            }

            public void flush() throws IOException {
                XmlOutput.this._baseStream.flush();
            }

            public void write(byte[] b, int off, int len) throws IOException {
                if (XmlOutput.this._strip) {
                    XmlOutput.this._filter(null, b, off, len);
                    return;
                }
                XmlOutput.this._baseStream.write(b, off, len);
            }
        };
    }

    public PrintWriter getWriter() {
        assert (this._baseWriter != null);
        Writer writer = new Writer(){

            @Override
            public void close() throws IOException {
                XmlOutput.this._baseWriter.close();
            }

            @Override
            public void flush() throws IOException {
                XmlOutput.this._baseWriter.flush();
            }

            @Override
            public void write(char[] cbuf, int off, int len) throws IOException {
                if (XmlOutput.this._strip) {
                    XmlOutput.this._filter(cbuf, null, off, len);
                    return;
                }
                XmlOutput.this._baseWriter.write(cbuf, off, len);
            }
        };
        return new PrintWriter(writer);
    }

    private void _filter(char[] cbuf, byte[] b, int off, int len) throws IOException {
        int sz = off + len;
        for (int i = off; i < sz; ++i) {
            char ch = this._charAt(cbuf, b, i);
            if (ch == _XML_STR.charAt(this._searchIndex)) {
                ++this._searchIndex;
                if (this._searchIndex < _XML_STR.length()) continue;
                this._strip = false;
                this._write(_XML_STR);
                len = sz - i - 1;
                if (len <= 0) break;
                this._write(cbuf, b, i + 1, len);
                break;
            }
            if (this._searchIndex <= 0) continue;
            this._searchIndex = 0;
            --i;
        }
    }

    private char _charAt(char[] cbuf, byte[] b, int index) {
        return b != null ? (char)b[index] : cbuf[index];
    }

    private void _write(char[] cbuf, byte[] b, int off, int len) throws IOException {
        if (b != null) {
            this._baseStream.write(b, off, len);
        } else {
            this._baseWriter.write(cbuf, off, len);
        }
    }

    private void _write(String s) throws IOException {
        if (this._baseStream != null) {
            this._baseStream.print(s);
        } else {
            this._baseWriter.write(s);
        }
    }
}

