/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidad.component;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.UIComponent;
import javax.faces.component.UIPanel;
import javax.faces.context.FacesContext;
import org.apache.myfaces.trinidad.bean.FacesBean;
import org.apache.myfaces.trinidad.component.UIXCollection;
import org.apache.myfaces.trinidad.component.UIXShowDetail;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;

final class StampState
implements Externalizable {
    private static final TrinidadLogger _LOG = TrinidadLogger.createTrinidadLogger(StampState.class);
    private Map<DualKey, Object> _rows = Collections.emptyMap();
    private static final Object[] _EMPTY_ARRAY = new Object[0];
    private static final long serialVersionUID = 1L;

    public void clear(Object skipCurrencyObj) {
        if (!this._rows.isEmpty()) {
            Iterator<DualKey> iter = this._rows.keySet().iterator();
            while (iter.hasNext()) {
                DualKey dk = iter.next();
                if (StampState._eq(dk._key1, skipCurrencyObj)) continue;
                iter.remove();
            }
        }
    }

    public void put(Object currencyObj, String key, Object value) {
        Map comparant = Collections.emptyMap();
        if (this._rows == comparant) {
            if (value == null) {
                return;
            }
            this._rows = new HashMap<DualKey, Object>(109);
        }
        DualKey dk = new DualKey(currencyObj, key);
        if (value == null) {
            this._rows.remove(dk);
        } else {
            this._rows.put(dk, value);
        }
    }

    public int size() {
        return this._rows.size();
    }

    public Object get(Object currencyObj, String key) {
        DualKey dk = new DualKey(currencyObj, key);
        return this._rows.get(dk);
    }

    public static Object saveStampState(FacesContext context, UIComponent stamp) {
        RowState state = StampState._createState(stamp);
        return state;
    }

    public static void restoreStampState(FacesContext context, UIComponent stamp, Object stampState) {
        if (stampState != null) {
            RowState state = (RowState)stampState;
            state.restoreRowState(stamp);
        }
    }

    public static Object saveChildStampState(FacesContext context, UIComponent stamp, UIXCollection table) {
        int childCount = stamp.getChildCount();
        if (childCount == 0) {
            return null;
        }
        HashMap<String, Object> childStateMap = null;
        List children = stamp.getChildren();
        for (int i = 0; i < childCount; ++i) {
            UIComponent child = (UIComponent)children.get(i);
            Object childState = table.saveStampState(context, child);
            if (childState == null) continue;
            if (childStateMap == null) {
                childStateMap = new HashMap<String, Object>(childCount);
            }
            childStateMap.put(child.getId(), childState);
        }
        return childStateMap;
    }

    public static void restoreChildStampState(FacesContext context, UIComponent stamp, UIXCollection table, Object stampState) {
        if (stampState == null || !(stampState instanceof Map)) {
            return;
        }
        List kids = stamp.getChildren();
        Map state = (Map)stampState;
        for (UIComponent kid : kids) {
            Object childState = state.get(kid.getId());
            if (childState == null) continue;
            table.restoreStampState(context, kid, childState);
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this._rows.size());
        if (this._rows.isEmpty()) {
            return;
        }
        HashMap<DualKey, Object> map = new HashMap<DualKey, Object>(this._rows.size());
        map.putAll(this._rows);
        if (_LOG.isFinest()) {
            for (Map.Entry entry : map.entrySet()) {
                _LOG.finest("Saving " + entry.getKey() + ", " + entry.getValue());
            }
        }
        out.writeObject(map);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int size = in.readInt();
        if (size > 0) {
            this._rows = (Map)in.readObject();
        }
        if (_LOG.isFinest()) {
            for (Map.Entry<DualKey, Object> entry : this._rows.entrySet()) {
                _LOG.finest("Restoring " + entry.getKey() + ", " + entry.getValue());
            }
        }
    }

    private static RowState _createState(UIComponent child) {
        RowState state;
        if (child instanceof EditableValueHolder) {
            state = new EVHState();
            state.saveRowState(child);
        } else if (child instanceof UIXCollection) {
            state = new TableState();
            state.saveRowState(child);
        } else {
            state = child instanceof UIXShowDetail ? SDState.getState((UIXShowDetail)child) : null;
        }
        return state;
    }

    private static boolean _eq(Object k1, Object k2) {
        if (k1 == null) {
            return k2 == null;
        }
        return k1.equals(k2);
    }

    private static final class DualKey
    implements Serializable {
        private final Object _key1;
        private final Object _key2;
        private final int _hash;
        private static final long serialVersionUID = 1L;

        public DualKey(Object key1, Object key2) {
            this._key1 = key1;
            this._key2 = key2;
            this._hash = DualKey._hash(key1) + DualKey._hash(key2);
        }

        public boolean equals(Object other) {
            if (other == this) {
                return true;
            }
            if (other instanceof DualKey) {
                DualKey otherKey = (DualKey)other;
                if (this.hashCode() != otherKey.hashCode()) {
                    return false;
                }
                return StampState._eq(this._key1, otherKey._key1) && StampState._eq(this._key2, otherKey._key2);
            }
            return false;
        }

        public int hashCode() {
            return this._hash;
        }

        public String toString() {
            return "<" + this._key1 + "," + this._key2 + ">";
        }

        private static int _hash(Object k) {
            return k == null ? 0 : k.hashCode();
        }
    }

    private static class EVHState
    extends RowState {
        private Object _submitted;
        private Object _local;
        private boolean _localSet;
        private boolean _valid = true;
        private transient UIComponent _assertStamp = null;
        private static final long serialVersionUID = 1L;

        @Override
        public void saveRowState(UIComponent child) {
            assert (this._assertIsStampCorrect(child));
            EditableValueHolder evh = (EditableValueHolder)child;
            this._submitted = evh.getSubmittedValue();
            this._localSet = evh.isLocalValueSet();
            this._local = evh.getLocalValue();
            this._valid = evh.isValid();
        }

        @Override
        public void restoreRowState(UIComponent child) {
            assert (this._assertIsStampCorrect(child));
            EditableValueHolder evh = (EditableValueHolder)child;
            evh.setSubmittedValue(this._submitted);
            evh.setValue(this._local);
            evh.setLocalValueSet(this._localSet);
            evh.setValid(this._valid);
            assert (this._assertStampHonoursState(evh));
        }

        @Override
        public boolean isNull() {
            return this._valid && !this._localSet && this._submitted == null;
        }

        public String toString() {
            return "EVHState[value=" + this._local + ",submitted=" + this._submitted + "]";
        }

        private boolean _assertStampHonoursState(EditableValueHolder evh) {
            return evh.getSubmittedValue() == this._submitted && evh.getLocalValue() == this._local && evh.isLocalValueSet() == this._localSet && evh.isValid() == this._valid;
        }

        private boolean _assertIsStampCorrect(UIComponent stamp) {
            if (this._assertStamp != null) {
                String stampId = stamp.getId();
                String assertStampId = this._assertStamp.getId();
                assert (assertStampId == null && stampId == null || assertStampId != null && assertStampId.equals(stampId)) : "Current stamp:" + stamp + " with id:" + stamp.getId() + ". Previously stamp was:" + this._assertStamp + " with id:" + this._assertStamp.getId();
            } else {
                this._assertStamp = stamp;
            }
            return true;
        }
    }

    private static final class TableState
    extends RowState {
        private Object _state = null;
        private static final long serialVersionUID = 1L;

        @Override
        public void saveRowState(UIComponent child) {
            this._state = ((UIXCollection)child).__getMyStampState();
        }

        @Override
        public void restoreRowState(UIComponent child) {
            UIXCollection myChild = child instanceof UIPanel ? (UIXCollection)((Object)child.getChildren().get(0)) : (UIXCollection)child;
            myChild.__setMyStampState(this._state);
        }

        @Override
        public boolean isNull() {
            return this._state == null;
        }
    }

    private static final class SDState
    extends RowState {
        private static final SDState _TRUE = new SDState(true);
        private static final SDState _FALSE = new SDState(false);
        private static final SDState _NULL = new SDState(null);
        private static final long serialVersionUID = -8605916495935317932L;
        private Boolean _disclosed;

        public static RowState getState(UIXShowDetail child) {
            FacesBean bean = child.getFacesBean();
            Boolean disclosed = (Boolean)bean.getLocalProperty(UIXShowDetail.DISCLOSED_KEY);
            if (disclosed == null) {
                return _NULL;
            }
            if (disclosed.booleanValue()) {
                return _TRUE;
            }
            return _FALSE;
        }

        public SDState() {
        }

        private SDState(Boolean disclosed) {
            this._disclosed = disclosed;
        }

        @Override
        public void saveRowState(UIComponent child) {
            FacesBean bean = ((UIXShowDetail)child).getFacesBean();
            this._disclosed = (Boolean)bean.getLocalProperty(UIXShowDetail.DISCLOSED_KEY);
        }

        @Override
        public void restoreRowState(UIComponent child) {
            FacesBean bean = ((UIXShowDetail)child).getFacesBean();
            bean.setProperty(UIXShowDetail.DISCLOSED_KEY, this._disclosed);
        }

        @Override
        public boolean isNull() {
            return this._disclosed == null;
        }

        public String toString() {
            return "SDState[disclosed=" + this._disclosed + "]";
        }
    }

    private static abstract class RowState
    implements Serializable {
        private static final long serialVersionUID = 1L;

        public abstract void saveRowState(UIComponent var1);

        public abstract void restoreRowState(UIComponent var1);

        public abstract boolean isNull();
    }
}

